package javax.microedition.lcdui;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2005  All Rights Reserved
 */

class ImageButton extends CommandButton {

	Image fImage;

	ImageButton(Composite parent, Image image) {
		this(parent, null, null);
		fImage = image;
	}

	ImageButton(Composite parent, Image image, Command command) {
		super(parent, null, command);
		fImage = image;
	}

	void paint(Graphics g) {
//		System.err.println("Painting pushbutton with bounds: " + fX + "," + fY + "," + fWidth + "," + fHeight + " translation: " + g.fData.fTranslateX + "," + g.fData.fTranslateY + " clip: " + g.fClipRect.x + "," + g.fClipRect.y + "," + g.fClipRect.width + "," + g.fClipRect.height);
//		new Exception().printStackTrace();
		g.setColor(DisplayPeer.COLOR_MENU_BACKGROUND_RGB);
		g.fillRect(BORDER_WIDTH, BORDER_HEIGHT, fWidth - TOTAL_BORDER_WIDTH, fHeight - TOTAL_BORDER_HEIGHT);
		paintBorder(g, fHighlighted, 0, 0, fWidth - 1, fHeight - 1);

		if (fEnabled) {
			g.setColor(DisplayPeer.COLOR_FOREGROUND_RGB);
		} else {
			g.setColor(DisplayPeer.COLOR_MENU_DISABLED_TEXT);
		}

		if (fImage != null) {
			if (fPressed) {
				g.drawImage(fImage, ImageItemPeer.BORDER_WIDTH + ImageItemPeer.MARGIN + SELECTION_OFFSET, ImageItemPeer.BORDER_HEIGHT + ImageItemPeer.MARGIN + SELECTION_OFFSET, Graphics.LEFT | Graphics.TOP);
			} else {
				g.drawImage(fImage, ImageItemPeer.BORDER_WIDTH + ImageItemPeer.MARGIN, ImageItemPeer.BORDER_HEIGHT + ImageItemPeer.MARGIN, Graphics.LEFT | Graphics.TOP);
			}
		}

		if (fHighlighted) {
			g.setStrokeStyle(Graphics.DOTTED);
			g.drawRect(BORDER_WIDTH + HIGHLIGHT_OFFSET, BORDER_HEIGHT + HIGHLIGHT_OFFSET, fWidth - TOTAL_BORDER_WIDTH - (2 * HIGHLIGHT_OFFSET) - 1, fHeight - TOTAL_BORDER_HEIGHT - (2 * HIGHLIGHT_OFFSET) - 1);
			g.setStrokeStyle(Graphics.SOLID);
		}
	}
}
