package javax.microedition.lcdui;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2005  All Rights Reserved
 */

import com.ibm.ive.midp.*;

abstract class ImageDecoder {

	/* These must match the definintions in jpegdecoder.h and other decoder files */
	public static final int IMAGE_NOT_HANDLED = 0;
	public static final int IMAGE_DECODING_ERROR = -1;

	static String[] gDecoderClassNames;
	static ImageDecoder[] gDecoders;

	static void registerDecoders(String[] decoders) {
		String property = System.getProperty("LcduiImageDecoders");
		if (property == null) {
			gDecoderClassNames = decoders;
		} else {
			/* parse property for decoder names */
			FastVector newDecoders = new FastVector();
			int start, end;
			for (start = 0; (end = property.indexOf(',', start)) != -1; start = end + 1) {
				if (end > start) newDecoders.addElement(property.substring(start, end));
			}
			if (start < property.length()) newDecoders.addElement(property.substring(start));

			gDecoderClassNames = new String[decoders.length + newDecoders.size()];

			/* copy parsed property decoders into beginning of array */
			newDecoders.copyInto(gDecoderClassNames);

			/* copy passed in decoders into array after them */
			System.arraycopy(decoders, 0, gDecoderClassNames, newDecoders.size(), decoders.length);
		}

		gDecoders = new ImageDecoder[gDecoderClassNames.length];
	}

	/**
	 * 	Detects image type and decodes image.
	 *
	 *  @return -1 if error occurrs, 0 if image type not handled by any available decoder
	 */
	static int createImageFromBytes(byte[] data, int offset, int length) {
		for (int i = 0; i < gDecoders.length; i++) {
			if (gDecoders[i] == null) {
				/* load decoder class */
				if (gDecoderClassNames[i] == null) continue; /* decoder removed */
				try {
					gDecoders[i] = (ImageDecoder) Class.forName(gDecoderClassNames[i]).newInstance();
				} catch (Exception e) {
					/* remove it from classNames list so that we don't try to load it every time.
					 * This should not be the usual case. */
					gDecoderClassNames[i] = null;
					continue;
				}
			}

			/* decodeImage() returns -1 if error occurrs, 0 if not handled by this decoder */
			int retVal = gDecoders[i].decodeImage(data, offset, length);

			if (retVal == IMAGE_NOT_HANDLED) continue; /* not handled by this decoder */

			return retVal;
		}
		return IMAGE_NOT_HANDLED;
	}

	/**
	 * 	Detects image type and decodes image.
	 *
	 *  @return image handle, or -1 if error occurrs, or 0 if image type not handled by this decoder
	 */
	abstract int decodeImage(byte[] data, int offset, int length);
}
