package javax.microedition.lcdui;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2002, 2005  All Rights Reserved
 */

import com.ibm.ive.midp.*;

/**
 * An <code>ImageItem</code> is an <code>Item</code>
 * subclass displaying an <code>Image</code>.
 **/

public class ImageItem extends Item {

	public static final int LAYOUT_CENTER = 3;
	public static final int LAYOUT_DEFAULT = 0;
	public static final int LAYOUT_LEFT = 1;
	public static final int LAYOUT_NEWLINE_AFTER = 0x200;
	public static final int LAYOUT_NEWLINE_BEFORE = 0x100;
	public static final int LAYOUT_RIGHT = 2;
	static final int NEWLINE_BEFORE_AND_AFTER = LAYOUT_NEWLINE_BEFORE | LAYOUT_NEWLINE_AFTER;

	Image fImage;
	String fAlternativeText;
	int fAppearanceMode;

	ImageItemPeer fPeer;

	public ImageItem(String label, Image image, int layout, String altText) {
		super(label);
		if (layout != LAYOUT_DEFAULT) {
			checkValidity(layout);
			setLayout(layout);
		}
		fImage = image;
		fAlternativeText = altText;
		fAppearanceMode = PLAIN;
	}

	public ImageItem(String label, Image image, int layoutNumber, String altText, int appearanceMode) {
		super(label);

		checkValidity(layoutNumber);

		checkAppearanceMode(appearanceMode);

		setLayout(layoutNumber);

		fImage = image;
		fAlternativeText = altText;
		fAppearanceMode = appearanceMode;
	}

	public String getAltText() {
		synchronized (Device.gDisplayableLock) {
			return fAlternativeText;
		}
	}

	public Image getImage() {
		synchronized (Device.gDisplayableLock) {
			return fImage;
		}
	}

	public void setAltText(String altText){
		synchronized (Device.gDisplayableLock) {
			fAlternativeText = altText;
		}
	}

	public void setLayout(int layout) {
		synchronized (Device.gDisplayableLock) {
			if ((layout & Item.LAYOUT_2) == 0) {
				checkValidity(layout);
			}

			super.setLayout(layout);
		}
	}

	public void setImage(Image image) {
		synchronized (Device.gDisplayableLock) {
			fImage = image;

			// Keep peer in sync
			if (fPeer != null) fPeer.setImage(image);
		}
	}

	public int getAppearanceMode() {
		synchronized (Device.gDisplayableLock) {
			return fAppearanceMode;
		}
	}

	int getType() {
		return TYPE_IMAGE;
	}

	ItemComponent getItemComponent() {
		if (fPeer == null) return null;
		return (ItemComponent) fPeer.fParent;
	}
}
