package javax.microedition.lcdui;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2005, 2006  All Rights Reserved
 */

class ItemComponentLayout extends Layout {

	ItemComponent fItemComponent;

	final static int LABEL_RIGHT_MARGIN = 3;

	int fPreferredHeight = -1;
	int fPreferredWidth = -1;
	int fMinimumHeight = -1;
	int fMinimumWidth = -1;

	ItemComponentLayout(ItemComponent component) {
		fItemComponent = component;
	}

	/**
	 * ItemComponent will insert a break after the label, if there is a label and the
	 * length of label + item exeeds the display length.
	 */
	boolean willBreakAfterLabel() {
		return fItemComponent.fLabelComponent != null
			&& ((fItemComponent.fLabelComponent.fWidth + fItemComponent.fContentComponent.getPreferredWidth() + LABEL_RIGHT_MARGIN) > fItemComponent.getWindow().fContentComponent.fWidth
			|| fItemComponent.fLayoutData != Item.LAYOUT_DEFAULT);
	}

	void layout() {
		int itemX = 0;
		int itemY = 0;
		int itemWidth = fItemComponent.fWidth;
		int itemHeight = fItemComponent.fHeight;

		LabelComponent labelComponent = fItemComponent.fLabelComponent;
		Component content = fItemComponent.fContentComponent;

		if (labelComponent != null) {
			labelComponent.sizeChanged(itemWidth, itemHeight);
			labelComponent.fX = 0;
			labelComponent.fY = 0;
			if (willBreakAfterLabel()) {
				itemY += labelComponent.fHeight;
				itemHeight -= labelComponent.fHeight;
			} else {
				int labelWidth = labelComponent.fWidth + LABEL_RIGHT_MARGIN;
				itemX += labelWidth;
				itemWidth -= labelWidth;
			}
		}

		content.fX = itemX;
		content.fY = itemY;
		content.fWidth = itemWidth;
		content.fHeight = itemHeight;
		content.sizeChanged(content.fWidth, content.fHeight);

		// if the itemPeer is a Composite, let it lay out its components
		content.layout();
	}

	Component getNextComponent(Component start, int direction) {
		if (start == null) {
			switch (direction) {
				case Canvas.RIGHT:
				case Canvas.DOWN:
					if (fItemComponent.fLabelComponent != null) return fItemComponent.fLabelComponent;
					/* Intentional fall through. */
				case Canvas.LEFT:
				case Canvas.UP:
					return fItemComponent.fContentComponent;
				default: // make compiler happy
					return null;
			}
		}
		switch (direction) {
			case Canvas.LEFT:
			case Canvas.UP:
				if (start == fItemComponent.fContentComponent) return fItemComponent.fLabelComponent;
				break;
			case Canvas.RIGHT:
			case Canvas.DOWN:
				if (start == fItemComponent.fLabelComponent) return fItemComponent.fContentComponent;
				break;
		}
		return null;
	}

	int getMinimumWidth() {
		if (fMinimumWidth == -1) {
			fMinimumWidth = fItemComponent.fContentComponent.getMinimumWidth();
			if (!willBreakAfterLabel() && fItemComponent.fLabelComponent != null) {
				fMinimumWidth += fItemComponent.fLabelComponent.fWidth + LABEL_RIGHT_MARGIN;
			}
		}
		return fMinimumWidth;
	}

	int getMinimumHeight() {
		if (fMinimumHeight == -1) {
			fMinimumHeight = fItemComponent.fContentComponent.getMinimumHeight();
			if (willBreakAfterLabel()) {
				fMinimumHeight += fItemComponent.fLabelComponent.getMinimumHeight();
			} else {
				if (fItemComponent.fLabelComponent != null) {
					fMinimumHeight = Math.max(fMinimumHeight, fItemComponent.fLabelComponent.getMinimumHeight());
				}
			}
		}
		return fMinimumHeight;
	}

	int getPreferredWidth() {
		if (fPreferredWidth == -1) {
			if (fItemComponent.fItem.fPreferredWidth != -1) {
				fPreferredWidth = fItemComponent.fItem.fPreferredWidth;
			} else {
				fPreferredWidth = fItemComponent.fContentComponent.getPreferredWidth();
			}
			if (fItemComponent.fLabelComponent != null) {
				if (willBreakAfterLabel()) {
					fPreferredWidth = Math.max(fPreferredWidth, fItemComponent.fLabelComponent.getPreferredWidth());
				} else {
					fPreferredWidth += fItemComponent.fLabelComponent.getPreferredWidth() + LABEL_RIGHT_MARGIN;
				}
			}
		}
//		System.err.println("ItemComponent prefWidth: " + fPreferredWidth + " itemPeer: " + fItemComponent.fContentComponent);
		return fPreferredWidth;
	}

	int getPreferredHeight() {
		if (fPreferredHeight == -1) {
			if (fItemComponent.fItem.fPreferredHeight == -1) {
				fPreferredHeight = fItemComponent.fContentComponent.getPreferredHeight();
			} else {
				fPreferredHeight = fItemComponent.fItem.fPreferredHeight;
			}
			if (willBreakAfterLabel()) {
				fPreferredHeight += fItemComponent.fLabelComponent.getPreferredHeight();
			} else if (fItemComponent.fLabelComponent != null) {
				fPreferredHeight = Math.max(fPreferredHeight, fItemComponent.fLabelComponent.getPreferredHeight());
			}
		}
//		System.err.println("ItemComponent prefHeight: " + fPreferredHeight + " - " + fItemComponent);
		return fPreferredHeight;
	}

	void clearCachedSizes() {
		fPreferredHeight = fPreferredWidth = -1;
		fMinimumHeight = fMinimumWidth = -1;
	}
}
