package javax.microedition.lcdui;

import com.ibm.ive.midp.*;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2003, 2005  All Rights Reserved
 */

class ItemMediaAccessor implements IMediaAccessor {

	private CustomItem fItem;
	private Graphics fGraphics;

	public ItemMediaAccessor(CustomItem item) {
		super();
		if (item == null) throw new IllegalArgumentException();
		fItem = item;
		MediaAccessManager.addAccessor(item,this);
	}

	public Graphics getGraphics() {

		if (fItem.fPeer == null) return null;

		if (fGraphics != null) {
			/*
			 * Dispose the previous Graphics only when
			 * the caller needs a new one.  Even though
			 * fGraphics becomes invalid after hideMedia,
			 * it is not thread safe to dispose it there.
			 */
			fGraphics.dispose();
		}

		fGraphics = fItem.fPeer.getDisplayGraphics();

		return fGraphics;
	}

	public void flushGraphics(Graphics g) {
		g.flush();
	}

	public void flushGraphics(Graphics g, int x, int y, int w, int h) {
		g.flush(x, y, w, h);
	}
}
