package javax.microedition.lcdui;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2003, 2005  All Rights Reserved
 */

import com.ibm.ive.midp.*;

class Menu {

	int fHandle;
	int fDisplayHandle;
	int fMenuItemCount;
	MenuBarComponent fMenuBar;
	String fMenuText;
	Command[] fMenuItems = new Command[1];
	Item item;
	int fID = -1;

	final static int ACTIONS = 0;
	final static int NAVIGATION = 1;
	final static int ITEM = 2;
	final static int HELP = 3;

	Menu(MenuBarComponent menuBar, int type) {
		fMenuBar = menuBar;
		fMenuText = getMenuName(type);
		fDisplayHandle = menuBar.getDisplayablePeer().getWindowHandle();
	}

	void dispose() {
		if (fHandle != 0) {
			MenuBarComponent.removeMenu(this);
			OS.DestroyMenu(fHandle);
			fHandle = 0;
		}
	}

	void addCommand(Command menuItem) {
		if (fMenuItems.length == fMenuItemCount) {
			Command[] newArray = new Command[fMenuItems.length * 2];
			System.arraycopy(fMenuItems, 0, newArray, 0, fMenuItemCount);
			fMenuItems = newArray;
		}
		fMenuItems[fMenuItemCount++] = menuItem;
	}

	private String getMenuName(int id) {
//TODO : Externalize the strings
		switch(id) {
			case ACTIONS: return MidpMsg.getString("Menu.Actions"); //$NON-NLS-1$
			case NAVIGATION: return MidpMsg.getString("Menu.Navigate"); //$NON-NLS-1$
			case HELP: return MidpMsg.getString("Menu.Help"); //$NON-NLS-1$
			default: return MidpMsg.getString("Menu.Item"); // ITEM //$NON-NLS-1$
		}
	}

	void create(MenuBarComponent menuBar) {
		fHandle = OS.CreatePopupMenu();

		for (int i = 0; i < fMenuItemCount; i++) {
			Command command = fMenuItems[i];

			/* Default to using the long label if it is available for menu items. */
			String label = command.fLongLabel;
			if (label == null) label = command.fLabel;

			/*
			 * The InsertMenu api needs to be used b/c the InsertMenuItem call
			 * is not available on PocketPC or Smartphone.
			 */
			OS.InsertMenu(fHandle, i, OS.MF_BYPOSITION, menuBar.registerCommand(fID, i, command), label);
		}
	}
}
