package javax.microedition.lcdui;

import com.ibm.ive.midp.MidpMsg;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2002, 2005  All Rights Reserved
 */

class PermissionForm extends Form {
	ChoiceGroup fChoice;
	boolean fRunning;

	PermissionForm(String message, String[] choices, int defaultSelection) {
		super(""); //$NON-NLS-1$
		append(message);
		fChoice = new ChoiceGroup(null, Choice.EXCLUSIVE, choices, null);
		fChoice.fChoice.setSelectedIndex(defaultSelection, true);
		append(fChoice);
		_addCommand(new Command(MidpMsg.getString("Common.Ok"), Command.SCREEN, 1)); //$NON-NLS-1$
		fCommandListener = new CommandListener() {
			public void commandAction(Command c, Displayable d) {
				fRunning = false;
				synchronized (d) {
					d.notifyAll();
				}
			}
		};
		fRunning = true;
	}

	int getSelection() {
		return fChoice.fChoice.fSelectedIndex;
	}
}
