package javax.microedition.lcdui;

import com.ibm.ive.midp.*;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2002, 2006  All Rights Reserved
 */

abstract class Popup extends Window implements IChoiceListener {

	ChoiceImpl fChoice;
	IChoiceListener fListener;

	static final int MARGIN = 2;
	static final int TOTAL_MARGIN = MARGIN * 2;

	Popup(ChoiceImpl choice, Display display) {
		super(null, display);
		fChoice = choice;
	}

	void popup(int x, int y) {
		fX = x;
		fY = y;
		show();
	}

	Layout createLayout() {
		return new CompositeLayout(this, MARGIN, MARGIN, MARGIN, 0, 0);
	}

	void layout() {
		initializeBounds();
		super.layout();
	}

	void cancel() {
		dispose();
	}

	boolean dispatchEvent(Event e) {
		/* No-op*/
		return false;
	}

	void resize(int w, int h) {
		cancel();
	}

	void create() {
		createContentComponent();
		((ChoiceComponent) fContentComponent.fComponents.elementAt(0)).setListener(this);
		createGraphics();
	}

	void paint(Graphics g) {
		super.paint(g);
		g.setColor(0);
		setOriginAndClip(g);
		g.drawRect(0, 0, fWidth - 1, fHeight - 1);
	}

	boolean pointerPressed(int x, int y, boolean containsPoint) {
		if (containsPoint) return super.pointerPressed(x - fX, y - fY);
		cancel();
		return false;
	}

	boolean pointerPressed(int x, int y) {
		if (containsAbsolutePoint(x, y)) return pointerPressed(x, y, true);

		cancel();
		Event e = new Event(Event.POINTER_PRESSED, x, y);
		fDisplay.fPeer.dispatchPointerEvent(e);
		return false;
	}

	boolean pointerDragged(int x, int y) {
		if (containsAbsolutePoint(x, y)) return pointerPressed(x, y, true);
		return false;
	}

	boolean pointerReleased(int x, int y) {
		if (containsAbsolutePoint(x, y)) return super.pointerReleased(x - fX, y - fY);
		cancel();
		return false;
	}

	public void itemSelected(int index) {
		notifyListener(index);
		dispose();
	}

	ChoiceImpl getChoice() {
		return fChoice;
	}

	void setListener(IChoiceListener listener) {
		fListener = listener;
	}

	void notifyListener(int index) {
		if (fListener != null) fListener.itemSelected(index);
	}

	void createContentComponent() {
		fContentComponent = new FillContentComponent(this);
	}

	abstract void initializeBounds();
}
