package javax.microedition.lcdui;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2002, 2006  All Rights Reserved
 */

import com.ibm.ive.midp.*;

class PopupChoice extends Popup {

	static final int MAX_VISIBLE_ITEMS = 8;
	Composite fParent;

	PopupChoice(Composite parent, ChoiceImpl choice, Display display) {
		super(choice, display);
		fParent = parent;
	}

	Layout createLayout() {
		return new CompositeLayout(this, MARGIN, MARGIN, MARGIN, 0, 0);
	}

	int getType() {
		return Displayable.TYPE_POPUP_CHOICE;
	}

	void create() {
		super.create();
		if (fChoice.fStrings == null) return;

		if (fChoice.fStrings.size() > MAX_VISIBLE_ITEMS) ((Scrollable)fContentComponent).createScrollBar();
	}

	boolean pointerPressed(int x, int y) {
		/*
		 * If clicked on the PopupChoice button, toggle between
		 * showing and shrinking the window
		 */
		if (fParent.fFocusComponent.containsAbsolutePoint(x,y)) return false;

		return super.pointerPressed(x, y);
	}

	boolean pointerDragged(int x, int y) {
		if (((Scrollable)fContentComponent).fScrollBarComponent == null) {
			// only do the nice popup list focus-follows-dragged-pointer behavior if
			// there is no scroll bar
			if (containsAbsolutePoint(x, y)) return pointerPressed(x, y, true);
		}
		return false;
	}

	void initializeBounds() {
		fWidth = 0;
		fHeight = ChoiceComponent.BORDER_HEIGHT + TOTAL_MARGIN;

		if (fChoice.fStrings == null) return;

		int length =  fChoice.fStrings.size();
		for (int i = 0; i < length; i++) {
			String string = fChoice.getString(i);
			Image image =  fChoice.getImage(i);
			Font font = fChoice.getFont(i);

			int iWidth = PopupChoiceButton.MIN_POPUP_WIDTH + font.getStringWidth(string);
			if (image != null) iWidth += ChoiceComponent.IMAGE_MARGIN_WIDTH;
			fWidth = Math.max(fWidth, iWidth);

			if (i < MAX_VISIBLE_ITEMS) {
				fHeight += font.getHeight() + ChoiceComponent.V_MARGIN;
			} else {
				fWidth += ScrollBarComponent.TOTAL_WIDTH;
				break;
			}
		}
		/* Border Margin at the bottom */
		fHeight += ChoiceComponent.BORDER_HEIGHT;

		int deviceWidth = Device.getDisplayWidth();
		int deviceHeight = Device.getDisplayHeight();

		fWidth = Math.min(fWidth, deviceWidth - 1);

		// adjust the coordinate according to the display size and location
		if (fX + fWidth > deviceWidth) fX = deviceWidth - fWidth - 1;
		if (fY + fHeight > deviceHeight) fY = deviceHeight - fHeight - 1;
	}

	void sizeChanged(int w, int h) {
		// Call sizeChanged of the ChoiceComponent
		fContentComponent.fFocusComponent.sizeChanged(w, h);
	}

	void createContentComponent() {
 		fContentComponent = new PopupChoiceContentComponent(this);
	}
}
