package javax.microedition.lcdui;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2003, 2006  All Rights Reserved
 */

import com.ibm.ive.midp.*;

class PopupChoiceButton extends ButtonWidget implements IChoicePeer, IButtonListener, IChoiceListener {

	static final int POPUP_INDICATOR_WIDTH = 9;
	static final int IMAGE_WIDTH = Device.getIconWidth();
	static final int IMAGE_HEIGHT = Device.getIconHeight();
	static final int MIN_POPUP_WIDTH = POPUP_INDICATOR_WIDTH + ButtonData.TOTAL_H_MARGIN + ChoiceComponent.TOTAL_BORDER_WIDTH + ChoiceComponent.TOTAL_H_MARGIN;
	static final int POPUP_WITH_IMAGE_WIDTH = ChoiceComponent.IMAGE_MARGIN_WIDTH + MIN_POPUP_WIDTH;
	static final int MIN_POPUP_HEIGHT = ChoiceComponent.TOTAL_BORDER_HEIGHT + ButtonData.TOTAL_TEXT_V_MARGIN;
	static final int POPUP_WITH_IMAGE_HEIGHT = IMAGE_HEIGHT + ChoiceComponent.TOTAL_BORDER_HEIGHT + ButtonData.TOTAL_IMAGE_V_MARGIN;

	ChoiceImpl fChoice;
	Image fImage;
	Font fFont;
	PopupChoice fPopup;
	Item fItem;
	String fFormattedText;

	PopupChoiceButton(Composite parent, ChoiceGroup item) {
		this(parent, item, Device.getDisplayWidth());
	}

	PopupChoiceButton(Composite parent, ChoiceGroup item, int width) {
		super(parent);
		fItem = item;
		fChoice = item.fChoice;
		fChoice.fPeer = this;

		create();
	}

	void create() {
		if (fChoice.fStrings == null) return;

		int index = fChoice.getSelectedIndex();
		setFields((String) fChoice.fStrings.elementAt(index), (Image) fChoice.fImages.elementAt(index),	fChoice.getFont(index));

		setListener(this);
		fWidth = getPreferredWidth();
		fHeight = getMinimumHeight();
	}

	void setFields(String text, Image image, Font font) {
		fImage = image;
		fFont = font;
		setText(text);
	}

	void dispose() {
		super.dispose();
		fChoice.fPeer = null;
	}

	public void delete(int index) {
		invalidate();
	}

	public void deleteAll() {
		invalidate();
	}

	void invalidate() {
		int index = fChoice.getSelectedIndex();
		if (index != -1) {
			setFields(fChoice.getString(index), fChoice.getImage(index), fChoice.getFont(index));
		} else {
			// Set it to empty string and null image
			setFields("", null, fFont);
		}

		fFormattedText = null;
		super.invalidate();
	}

	public void insert(int index, String elementName, Image snapshot) {
		invalidate();
	}

	public void set(int index, String elementName, Image snapshot) {
		if (index != fChoice.getSelectedIndex()) return;
		invalidate();
	}

	public void setFont(int index, Font font) {
		if (index != fChoice.getSelectedIndex()) return;
		invalidate();
	}

	public void setSelectedIndex(int index, boolean selected) {
		if (index != fChoice.getSelectedIndex()) return;
		invalidate();
	}

	int drawImage(Graphics g, int x, int y) {
		if (fImage == null) return x;
		int clipX = g.getClipX();
		int clipY = g.getClipY();
		int clipWidth = g.getClipWidth();
		int clipHeight = g.getClipHeight();
		int height = Math.min(fImage._getHeight(), IMAGE_HEIGHT);
		y += (fHeight - height) / 2;
		g.setClip(x, y, IMAGE_WIDTH, IMAGE_HEIGHT);
		g.drawImage(fImage, x, y, 0);
		g.setClip(clipX, clipY, clipWidth, clipHeight);
		return x + Math.min(fImage._getWidth(), IMAGE_WIDTH) + ChoiceComponent.H_MARGIN;
	}

	void paint(Graphics g) {
		if (fHighlighted) {
			g.setColor(DisplayPeer.COLOR_HIGHLIGHTED_BACKGROUND_RGB);
		} else {
			g.setColor(DisplayPeer.COLOR_BACKGROUND_RGB);
		}
		g.fillRect(0, 0, fWidth, fHeight);

		if (fHighlighted) {
			g.setColor(DisplayPeer.COLOR_HIGHLIGHTED_FOREGROUND_RGB);
		} else {
			g.setColor(DisplayPeer.COLOR_FOREGROUND_RGB);
		}

		int x = ButtonData.TEXT_H_MARGIN;
		int y = fHeight/2 - 1;
		g.fillTriangle(x, y, x + 6, y, x + 3, y + 3);
		x += POPUP_INDICATOR_WIDTH;
		if (fFont != null) y = (fHeight - fFont._getHeight()) / 2;
		x = drawImage(g, x + ButtonData.TEXT_H_MARGIN, 0);
		if (fText != null) {
			g.setFont(Component.gFont);
			if (fFormattedText == null) fFormattedText = format(fText, fWidth - x, Component.gFont);

			g.drawStringWithTabExpansion(fFormattedText, x, y, 0);
		}
	}

	int getPreferredWidth() {
		if (fText == null && fImage == null) return MIN_POPUP_WIDTH;
		int width = MIN_POPUP_WIDTH;
		if (fImage != null) width = POPUP_WITH_IMAGE_WIDTH;
		if (fText != null) width += fFont.getStringWidth(fText);
		return width;
	}

	int getMinimumWidth() {
		if (fImage != null) {
			return ChoiceComponent.IMAGE_MARGIN_WIDTH + fFont.getStringWidth("W...") + MIN_POPUP_WIDTH; //$NON-NLS-1$
		} else {
			return fFont.getStringWidth("W...") + MIN_POPUP_WIDTH; //$NON-NLS-1$
		}
	}

	int getMinimumHeight() {
		if (fImage != null) {
			return POPUP_WITH_IMAGE_HEIGHT;
		} else if (fFont != null) {
			return fFont._getHeight() + MIN_POPUP_HEIGHT;
		} else {
			return MIN_POPUP_HEIGHT + POPUP_INDICATOR_WIDTH;
		}
	}

	public void buttonFired(ButtonWidget button) {
		if (fPopup == null) {
			fPopup = new PopupChoice(fParent, fChoice, getDisplay());
			fPopup.setListener(this);
		}
		fPopup.popup(getOriginX(), getOriginY() + fHeight);
	}

	public void itemSelected(int index) {
		fItem.notifyStateChanged();
		/*
		 * Reset the fInvalidated flag for the previous window,
		 * so that we could relayout
		 */
		getWindow().fInvalidated = false;
		invalidate();
	}
}
