package javax.microedition.lcdui;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2005  All Rights Reserved
 */

class PushButton extends CommandButton {

	PushButton(Composite parent, String text) {
		this(parent, text, null);
	}

	PushButton(Composite parent, String text, Command command) {
		super(parent, text, command);
	}

	void paint(Graphics g) {
//		System.err.println("Painting pushbutton with bounds: " + fX + "," + fY + "," + fWidth + "," + fHeight + " translation: " + g.fData.fTranslateX + "," + g.fData.fTranslateY + " clip: " + g.fClipRect.x + "," + g.fClipRect.y + "," + g.fClipRect.width + "," + g.fClipRect.height);
//		new Exception().printStackTrace();
		g.setFont(gFont);
		g.setColor(DisplayPeer.COLOR_MENU_BACKGROUND_RGB);
		g.fillRect(BORDER_WIDTH, BORDER_HEIGHT, fWidth - TOTAL_BORDER_WIDTH, fHeight - TOTAL_BORDER_HEIGHT);
		paintBorder(g, fHighlighted, 0, 0, fWidth - 1, fHeight - 1);

		if (fEnabled) {
			g.setColor(DisplayPeer.COLOR_FOREGROUND_RGB);
		} else {
			g.setColor(DisplayPeer.COLOR_MENU_DISABLED_TEXT);
		}

		if (fPressed) {
			g.drawStringWithTabExpansion(fText, BORDER_WIDTH + TEXT_H_MARGIN + SELECTION_OFFSET, BORDER_HEIGHT + TEXT_V_MARGIN + SELECTION_OFFSET, Graphics.LEFT | Graphics.TOP);
		} else {
			g.drawStringWithTabExpansion(fText, BORDER_WIDTH + TEXT_H_MARGIN, BORDER_HEIGHT + TEXT_V_MARGIN, Graphics.LEFT | Graphics.TOP);
		}

		if (fHighlighted) {
			g.setStrokeStyle(Graphics.DOTTED);
			g.drawRect(BORDER_WIDTH + HIGHLIGHT_OFFSET, BORDER_HEIGHT + HIGHLIGHT_OFFSET, fWidth - TOTAL_BORDER_WIDTH - (2 * HIGHLIGHT_OFFSET) - 1, fHeight - TOTAL_BORDER_HEIGHT - (2 * HIGHLIGHT_OFFSET) - 1);
			g.setStrokeStyle(Graphics.SOLID);
		}
	}
}
