package javax.microedition.lcdui;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2002, 2006  All Rights Reserved
 */

import com.ibm.ive.midp.*;

class ScrollBarComponent extends Widget {

	public static int TOTAL_HEIGHT = 0;
	public static int TOTAL_WIDTH = getScrollBarWidth();

	int fHandle;

	public ScrollBarComponent(final Scrollable parent) {
		super(parent);
		fHandle = parent.getWindowHandle();
	}

	static boolean isAlwaysVisible() {
		return false;
	}

	void dispose() {
		super.dispose();
		setValues(0, 0, 0);
	}

	void setValues(final int max, final int y, final int visible) {
//		new Exception().printStackTrace();
		Device.asyncExec(new Runnable() {
			public void run() {
//				System.err.println("Setting scroll values: " + max + " visible: " + visible);
				setValues(fHandle, max, y, visible);
			}
		});
	}

	void hide() {
		setValues(fHandle, 0, 0, 0);
	}

	native void setValues(int handle, int newMax, int newScrollY, int visible);
	static native int getScrollBarWidth();
}
