package javax.microedition.lcdui;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2002, 2005  All Rights Reserved
 */

import com.ibm.ive.midp.*;

public class Spacer extends Item {

	int fMinWidth, fMinHeight;
	SpacerPeer fPeer;

	public Spacer(int minWidth, int minHeight) {
		super(null);

		setMinimumSize(minWidth, minHeight);
	}

	public void setMinimumSize(int width, int height) {
		synchronized (Device.gDisplayableLock) {
			if (width < 0) throw new IllegalArgumentException();
			if (height < 0) throw new IllegalArgumentException();

			fMinWidth = width;
			fMinHeight = height;

			if (fPeer != null) fPeer.setMinimumSize(width, height);
		}
	}

	public void addCommand(Command command) {
		throw new IllegalStateException();
	}

	public void setDefaultCommand(Command command) {
		throw new IllegalStateException();
	}

	public void setLabel(String label) {
		throw new IllegalStateException();
	}

	int getType() {
		return TYPE_SPACER;
	}

	public int getMinimumHeight() {
		synchronized (Device.gDisplayableLock) {
			return fMinHeight;
		}
	}

	public int getMinimumWidth() {
		synchronized (Device.gDisplayableLock) {
			return fMinWidth;
		}
	}

	ItemComponent getItemComponent() {
		if (fPeer == null) return null;
		return (ItemComponent) fPeer.fParent;
	}
}
