package javax.microedition.lcdui;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2002, 2005 All Rights Reserved
 */

import com.ibm.ive.midp.*;

public class TextBox extends Screen {

	TextImpl fText;

	public TextBox(String title, String text, int maxSize, int constraints) {
		super(title);

		fText = new TextImpl(text, maxSize, constraints);
	}

	public void delete(int offset, int length) {
		synchronized (Device.gDisplayableLock) {
			fText.delete(offset, length);
		}
	}

	public int getCaretPosition() {
		synchronized (Device.gDisplayableLock) {
			return fText.getCaretPosition();
		}
	}

	public int getChars(char[] chars) {
		synchronized (Device.gDisplayableLock) {
			return fText.getChars(chars);
		}
	}

	public int getConstraints() {
		synchronized (Device.gDisplayableLock) {
			return fText.getConstraints();
		}
	}

	public int getMaxSize() {
		synchronized (Device.gDisplayableLock) {
			return fText.getMaxSize();
		}
	}

	public String getString() {
		synchronized (Device.gDisplayableLock) {
			return fText.getString();
		}
	}

	public void insert(char[] chars, int offset, int length, int position) {
		synchronized (Device.gDisplayableLock) {
			fText.insert(chars, offset, length, position);
		}
	}

	public void insert(String text, int position) {
		synchronized (Device.gDisplayableLock) {
			fText.insert(text, position);
		}
	}

	public void setChars(char[] chars, int offset, int length) {
		synchronized (Device.gDisplayableLock) {
			fText.setChars(chars, offset, length);
		}
	}

	public void setConstraints(int constraints) {
		synchronized (Device.gDisplayableLock) {
			fText.setConstraints(constraints);
		}
	}

	public void setInitialInputMode(String characterSubset) {
		synchronized (Device.gDisplayableLock) {
			fText.setInitialInputMode(characterSubset);
		}
	}

	public int setMaxSize(int size) {
		synchronized (Device.gDisplayableLock) {
			return fText.setMaxSize(size);
		}
	}

	public void setString(String aString) {
		synchronized (Device.gDisplayableLock) {
			fText.setString(aString);
		}
	}

	public int size() {
		synchronized (Device.gDisplayableLock) {
			return fText.size();
		}
	}

	int getDisplayableType() {
		return TYPE_TEXTBOX;
	}
}
