package javax.microedition.lcdui;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2002, 2005  All Rights Reserved
 */

import com.ibm.ive.midp.*;

/**
 * A <code>Ticker</code> displays a stream of information
 * on the device's screen, such as sport results or stock prices.<p>
 * Instances can be shared among different <code>Displayable</code>
 * instances.
 **/
public class Ticker {

	private String fText;
	private String fFormattedText;
	TickerPeer fPeer;
	int fScrollOffset;

	public Ticker(String text) {
		if (text == null) throw new NullPointerException();
		fScrollOffset = 0;
		setString(text);
	}

	public String getString() {
		synchronized (Device.gDisplayableLock) {
			return fText;
		}
	}

	String getFormattedString() {
		return fFormattedText;
	}

	public void setString(String text){
		synchronized (Device.gDisplayableLock) {
			if (text == null) throw new NullPointerException();
			fText = text;
			fFormattedText = removeLineBreaks(fText);
			if (fPeer != null) fPeer.update();
		}
	}

	private String removeLineBreaks(String str) {
		StringBuffer buf = new StringBuffer(str);
		int length = buf.length();
		char c;
		boolean newString = false;

		for (int i = 0; i < length; i++) {
			c = buf.charAt(i);
			if (c == '\n') {
				newString = true;
				buf.setCharAt(i,' ');
			}
		}

		if (newString) return buf.toString();
		return str;
	}
}
