package javax.microedition.lcdui;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2005  All Rights Reserved
 */

abstract class Widget {

	Composite fParent;
	boolean fShown = true;

	Widget(Composite parent) {
		fParent = parent;
	}

	void dispose() {
		hide();
		if (fParent != null && hasFocus()) fParent.setFocus(null);
	}

	Display getDisplay() {
		return fParent.getDisplay();
	}

	DisplayPeer getDisplayPeer() {
		return getDisplay().fPeer;
	}

	Displayable getDisplayable() {
		return fParent.getDisplayable();
	}

	boolean isShown() {
		return fShown && fParent.isShown();
	}

	Graphics getGraphics() {
		return fParent.getGraphics();
	}

	boolean hasFocus() {
		return fParent.hasFocus() && fParent.getFocus() == this;
	}

	DisplayablePeer getDisplayablePeer() {
		return fParent.getDisplayablePeer();
	}

	Window getWindow() {
		return fParent.getWindow();
	}

	void show() {
		fShown = true;
	}

	void hide() {
		fShown = false;
	}

	boolean isDisposed() {
		return fParent.isDisposed();
	}

	boolean isInvalidated() {
		return fParent.isInvalidated();
	}

	void layout() {
		/* No-op */
	}

	int getWindowHandle() {
		return fParent.getWindowHandle();
	}

	void update() {
		/* Sub-classes should override to update fields with any changed data. */
	}

	/**
	 * Remove leading and trailing newLines from the text
	 * @param String text The text to be stripped of newlines
	 * @return String The stripped String
	 */
	protected static String stripNewlines(String text) {
		if (text == null) return null;
		StringBuffer buffer = new StringBuffer(text);
		int index = 0;
		while (true) {
			if (index > buffer.length() - 1) break;
			char c = buffer.charAt(index);
			if (c == '\n') {
				buffer.deleteCharAt(index);
				continue;
			}
			if (c == ' ') {
				index++;
				continue;
			}
			break;
		}

		index = buffer.length() - 1;
		while (true) {
			if (index < 0) break;
			char c = buffer.charAt(index);
			if (c == '\n') {
				buffer.deleteCharAt(index);
				index--;
				continue;
			}
			if (c == ' ') {
				index--;
				continue;
			}
			break;
		}

		return buffer.toString();
	}

	protected static String removeLineBreaks(String s) {
		return s.replace('\n', ' ');
	}

	protected static String format(String line, int maxWidth, Font font) {
		if (line == null) return null;
		int width = font.getStringWidth(line);
		int nlIndex = line.indexOf('\n');
		if (width <= maxWidth && nlIndex == -1) return line;

		StringBuffer buffer = new StringBuffer(line);

		if (nlIndex != -1) {
			buffer.delete(nlIndex, buffer.length());
			if (buffer.length() == 0) return ""; //$NON-NLS-1$

			// width may have changed due to stripped newline
			width = font.getStringWidth(buffer.toString());
		}

		maxWidth -= font.getStringWidth("..."); //$NON-NLS-1$

		while (width > maxWidth && buffer.length() > 1) {
			buffer.deleteCharAt(buffer.length()-1);
			width = font.getStringWidth(buffer.toString());
		}

		return buffer.append("...").toString(); //$NON-NLS-1$
	}
}
