package javax.microedition.lcdui;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2002, 2005  All Rights Reserved
 */

import com.ibm.ive.midp.*;

abstract class Win32Component extends Component {

	int fHandle;
	boolean fMousePressed;

	Win32Component(Composite parent) {
		super(parent);
	}

	void paint(Graphics g) {
		Device.syncExec(new Runnable() {
			public void run() {
				OS.InvalidateRect(fHandle, true);
			}
		});
	}

	void showNotify() {
		Device.syncExec(new Runnable() {
			public void run() {
				OS.ShowWindow(fHandle, OS.SW_SHOW);
			}
		});
	}

	void hideNotify() {
		Device.syncExec(new Runnable() {
			public void run() {
				OS.ShowWindow(fHandle, OS.SW_HIDE);
			}
		});
	}

	void sizeChanged(final int w, final int h) {
		final Win32Component peer = this;
		Device.syncExec(new Runnable() {
			public void run() {
				int flags = OS.SWP_NOZORDER | OS.SWP_DRAWFRAME | OS.SWP_NOACTIVATE;
				/*
				* Feature on WinCE.  The SWP_DRAWFRAME flag for SetWindowPos()
				* causes a WM_SIZE message to be sent even when the SWP_NOSIZE
				* flag is specified.  The fix is to clear SWP_DRAWFRAME.
				*/
				if (OS.IsWinCE) {
					if ((flags & OS.SWP_NOSIZE) != 0) flags &= ~OS.SWP_DRAWFRAME;
				}

				int x = fParent.getOriginX(peer);
				int y = fParent.getOriginY(peer);
				OS.SetWindowPos(fHandle, 0, x, y, w, getHeight(), flags);
				handleResize();
				show();
			}
		});
	}

	void handleResize() {
		/* No-op */
	}

	int getHeight() {
		/*
		 * Due to the way Windows handles the ComboBox, we have to hack
		 * this value for the PopupChoice widgets. So, we access the
		 * value indirectly.
		 */
		return fHeight;
	}

	void updatePosition() {
		final Win32Component peer = this;
		Device.syncExec(new Runnable() {
			public void run() {
				int x = fParent.getOriginX(peer);
				int y = fParent.getOriginY(peer);
				int flags = OS.SWP_NOZORDER | OS.SWP_DRAWFRAME | OS.SWP_NOACTIVATE;
				OS.SetWindowPos(fHandle, 0, x, y, fWidth, getHeight(), flags);
			}
		});
	}

	public void setText(final String label) {
		Device.syncExec(new Runnable() {
			public void run() {
				OS.SetWindowText(fHandle, label);
			}
		});
	}

	public boolean dispatchPointerEvent(Event e) {
		e.fX = fX + e.fX;
		e.fY = fY + e.fY;

		switch (e.fType) {
			case Event.POINTER_PRESSED:
				fMousePressed = true;
				return fParent.pointerPressed(e.fX, e.fY);
			case Event.POINTER_RELEASED:
				fMousePressed = false;
				return fParent.pointerReleased(e.fX, e.fY);
			case Event.POINTER_MOVED:
				if (!fMousePressed) return false;
				return fParent.pointerDragged(e.fX, e.fY);
			default:
				return false;
		}
	}
}
