package javax.microedition.media;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2002, 2005  All Rights Reserved
 */

/**
 * Controllable provides the methods to get the controls available for a media processor.
 */
public interface Controllable {

	/**
	 * Return a control of a specific type.
	 *
	 * @param  controlType The fully qualified name of the class implementing the control;
	 *         if a package is not specified in the name, javax.microedition.media.control is
	 *         assumed.
	 *
	 * @return A Control, if found, or null if not found.
	 *
	 * @throws IllegalArgumentException Thrown if controlType is null.
	 *
	 * @throws IllegalStateException    Thrown when the receiver is not in a valid state.
	 */
	public Control getControl(String controlType);

	/**
	 * Returns an array of controls available.
	 *
	 * @return An array of Control instances.  If no controls are available, a
	 *         zero-sized array is returned.
	 *
	 * @throws IllegalStateException    Thrown when the receiver is not in a valid state.
	 */
	public Control[] getControls();
}
