package javax.microedition.media;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2002, 2005  All Rights Reserved
 */

/**
 * PlayListener is an interface providing event notification of media events.
 */
public interface PlayerListener {

	/**
	 * This event is sent when a Player is closed.
	 * The event data is null.
	 */
	static public final String CLOSED              = "closed"; //$NON-NLS-1$

	/**
	 * This event is sent when a device for the Player becomes available.
	 * The event data is a String which is the name of the device.
	 */
	static public final String DEVICE_AVAILABLE    = "deviceAvailable"; //$NON-NLS-1$

	/**
	 * This event is sent when a device for the Player becomes unavailable.
	 * The event data is a String which is the name of the device.
	 */
	static public final String DEVICE_UNAVAILABLE  = "deviceUnavailable"; //$NON-NLS-1$

	/**
	 * This event is sent when the duration of the media is determined.
	 * The event data is a Long which indicates the duration of the media.
	 */
	static public final String DURATION_UPDATED    = "durationUpdated"; //$NON-NLS-1$

	/**
	 * This event is sent when the Player reaches the end of the media.
	 * The event data is a Long which indicates the media time at which the Player stopped.
	 */
	static public final String END_OF_MEDIA        = "endOfMedia"; //$NON-NLS-1$

	/**
	 * This event is sent when an error occurs.
	 * The event data is a String which provides an error message.
	 */
	static public final String ERROR               = "error"; //$NON-NLS-1$

	/**
	 * This event is sent when the Player is started.
	 * The event data is a Long indicating the media time at which the Player started.
	 */
	static public final String STARTED             = "started"; //$NON-NLS-1$

	/**
	 * This event is sent when the Player is stopped.
	 * The event data is a Long indicating the media time at which the Player stopped.
	 */
	static public final String STOPPED             = "stopped"; //$NON-NLS-1$

	/**
	 * This event is sent when the volume changes.
	 * The event data is a VolumeControl, from which the new volume can be queried.
	 */
	static public final String VOLUME_CHANGED      = "volumeChanged"; //$NON-NLS-1$

	/**
	 * This method is invoked when an event occurs in a Player.
	 *
	 * @param player    The player on which the event occurred.
	 *
	 * @param event     The type of event that occurred.
	 *                  Valid values are the String constants defined in this class.
	 *
	 * @param eventData Event-specific data.
	 * 					See the description in the String constants defined in this class.
	 */
	public void playerUpdate(Player player, String event, Object eventData);
}
