package javax.microedition.media.control;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2002, 2005  All Rights Reserved
 */

import javax.microedition.media.*;

/**
 * The ToneControl provides an interface to define and play simple sequences of tones.
 */
public interface ToneControl extends Control {

	/**
	 * The end of a block.
	 */
	public static final byte BLOCK_END = -6;

	/**
	 * The start of a block.
	 */
	public static final byte BLOCK_START = - 5;

	/**
	 * Note Middle C.  As a MIDI note.
	 */
	public static final byte C4 = 60;

	/**
	 * Play a block.
	 */
	public static final byte PLAY_BLOCK = -7;

	/**
	 * Repeat.
	 */
	public static final byte REPEAT = -9;

	/**
	 * Sets the note length.
	 */
	public static final byte RESOLUTION = -4;

	/**
	 * Sets the volume.
	 */
	public static final byte SET_VOLUME = -8;

	/**
	 * Indicates silence.
	 */
	public static final byte SILENCE = -1;

	/**
	 * Sets the tempo.
	 */
	public static final byte TEMPO = -3;

	/**
	 * Sets the version.
	 */
	public static final byte VERSION = -2;

	/**
	 * Sets the sequence of tones to play.
	 *
	 * @param  sequence The encoded tones to play.
	 *
	 * @throws IllegalArgumentException Thrown if sequence is null or invalid.
	 *
	 * @throws IllegalStateException    Thrown if the Player is not in a valid state.
	 */
	public void setSequence(byte[] sequence);

}
