package javax.microedition.pki;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 1998, 2005  All Rights Reserved
 */

/**
 * An abstract representation of identity certificates.  It represents
 * a way to verify the binding of a Principal and its public key.
 *
 * @author		OTI
 * @version		initial
 */
public interface Certificate {

/**
 * Return the issuer distinguished name for the receiver
 *
 * @author		OTI
 * @version		initial
 *
 * @return		string representation of the issuer distinguished name
 */
public String getIssuer();

/**
 * Return the time until when the certificate is valid
 *
 * @author		OTI
 * @version		initial
 *
 * @return		the number of milliseconds until when the certificate is valid or 0 if there is no time-based validity restriction
 */
public long getNotAfter();

/**
 * Return the time when the certificate starts to be valid
 *
 * @author		OTI
 * @version		initial
 *
 * @return		the number of milliseconds after which the certificate is valid or 0 if there is no time-based validity restriction
 */
public long getNotBefore();

/**
 * Return the serial number for the receiver
 *
 * @author		OTI
 * @version		initial
 *
 * @return		the string representation of the serial number
 */
public String getSerialNumber();

/**
 * Return the certificate signature algorithm name for the receiver.
 *
 * @author		OTI
 * @version		initial
 *
 * @return		the certificate signature algorithm name for the receiver.
 */
public String getSigAlgName();

/**
 * Return the subject distinguished name for the receiver
 *
 * @author		OTI
 * @version		initial
 *
 * @return		string representation of the subject distinguished name
 */
public String getSubject();

/**
 * Returns the type of certificate.  For X.509 certificates, "X.509" is returned.
 *
 * @author		OTI
 * @version		initial
 *
 * @return		the type of certificate
 */
public String getType();

/**
 * Returns the version of the certificate.
 *
 * @author		OTI
 * @version		initial
 *
 * @return		the version of the certificate
 */
public String getVersion();

}
