
package javax.microedition.pki;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2002, 2005  All Rights Reserved
 */

import java.io.IOException;

/**
 * This class represents various problems relating to certificates.
 *
 * @author		OTI
 * @version		initial
 */
public class CertificateException extends IOException {

	/**
	 * Bad certificate extension
	 */
	public static final byte BAD_EXTENSIONS = 1;
	/**
	 * Certificate chain too long
	 */
	public static final byte CERTIFICATE_CHAIN_TOO_LONG = 2;
	/**
	 * Expired certificate
	 */
	public static final byte EXPIRED = 3;
	/**
	 * Unauthorized intermediate CA
	 */
	public static final byte UNAUTHORIZED_INTERMEDIATE_CA = 4;
	/**
	 * Signature missing
	 */
	public static final byte MISSING_SIGNATURE = 5;
	/**
	 * Certificate not yet valid
	 */
	public static final byte NOT_YET_VALID = 6;
	/**
	 * Site name mismatch
	 */
	public static final byte SITENAME_MISMATCH = 7;
	/**
	 * Unrecognized issuer
	 */
	public static final byte UNRECOGNIZED_ISSUER = 8;
	/**
	 * Unsupported signature algorithm
	 */
	public static final byte UNSUPPORTED_SIGALG = 9;
	/**
	 * Inappropriate key usage
	 */
	public static final byte INAPPROPRIATE_KEY_USAGE = 10;
	/**
	 * Broken chain
	 */
	public static final byte BROKEN_CHAIN = 11;
	/**
	 * Root CA expired
	 */
	public static final byte ROOT_CA_EXPIRED = 12;
	/**
	 * Unsupported public key type
	 */
	public static final byte UNSUPPORTED_PUBLIC_KEY_TYPE = 13;
	/**
	 * Verification failed
	 */
	public static final byte VERIFICATION_FAILED = 14;

	private Certificate certificate = null;
	private byte status;

/**
 * Constructor.
 *
 * @author		OTI
 * @version		initial
 *
 * @param		detailMessage	The reason for the exception.
 * @param		certificate		The certificate that caused the exception.
 * @param		status			The status constant indicating the reason for the exception.
 */
public CertificateException(String detailMessage, Certificate certificate, byte status) {
	super(detailMessage);
	this.certificate = certificate;
	this.status = status;
}

/**
 * Constructor.
 *
 * @author		OTI
 * @version		initial
 *
 * @param		certificate		The certificate that caused the exception.
 * @param		status			The status constant indicating the reason for the exception.
 */
public CertificateException(Certificate certificate, byte status) {
	super();
	this.certificate = certificate;
	this.status = status;
}

/**
 * Returns the certificate that caused the exception.
 *
 * @author		OTI
 * @version		initial
 *
 * @return		the certificate that caused the exception
 */
public Certificate getCertificate() {
	return certificate;
}

/**
 * Returns the code representing the reason for the exception.
 *
 * @author		OTI
 * @version		initial
 *
 * @return		the code representing the reason for the exception
 */
public byte getReason() {
	return status;
}

}
