package javax.microedition.rms;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2000, 2004  All Rights Reserved
 */

/**
 * 	This interface defines a record comparator.
 * Implementing classes should be aware of the possible
 * null records.
 *
 * @author		OTI
 * @version		initial
 */
public interface RecordComparator {
	/**
	 */
	public static final int EQUIVALENT = 0;
	/**
	 */
	public static final int FOLLOWS = 1;
	/**
	 */
	public static final int PRECEDES = -1;

/**
 *  Compares two records.
 *
 * @author		OTI
 * @version		initial
 *
 * @param		rec1 byte[]
 *				the record to compare
 * @param 		rec2 byte[]
 *			 	the record to compare
 * @return		int
 *				the result of the record comparison
 */
public int compare(byte[] rec1, byte[] rec2);
}
