package javax.microedition.rms;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2000, 2004  All Rights Reserved
 */

/**
 * 	This interface defines a bidirectional record enumeration.
 *
 * @author		OTI
 * @version		initial
 */
public interface RecordEnumeration {

/**
 * 	Frees all the internal resources used by the enumeration.
 * Any method called on the enumeration after it has been destroyed will
 * throw a java.lang.IllegalStateException
 *
 * @author		OTI
 * @version		initial
 */
public void destroy();

/**
 * 	Returns true if there is a next element, false otherwise
 *
 * @author		OTI
 * @version		initial
 *
 * @return		whether there is a next element
 */
public boolean hasNextElement();

/**
 * 	Returns true if there is a previous element, false otherwise
 *
 * @author		OTI
 * @version		initial
 *
 * @return		whether there is a previous element
 */
public boolean hasPreviousElement();

/**
 * 	Returns true if the enumeration is kept updated, false otherwise
 *
 * @author		OTI
 * @version		initial
 *
 * @return		whether this enumeration is kept updated
 */
public boolean isKeptUpdated();

/**
 * 	Sets the keepUpdated flag. This method may trigger the enumeration
 * rebuild
 *
 * @author		OTI
 * @version		initial
 *
 * @param		keepUpdated		whether to keep this enumeration updated
 */
public void keepUpdated(boolean keepUpdated);

/**
 * 	Returns the next record
 *
 * @author		OTI
 * @version		initial
 *
 * @return		the next record
 *
 * @throws 		InvalidRecordIDException		if the record has been deleted
 * @throws 		RecordStoreNotOpenException		if the RS is closed
 * @throws 		RecordStoreException			if the method fails for any other reason
 */
public byte[] nextRecord()throws InvalidRecordIDException,
								 RecordStoreNotOpenException,
								 RecordStoreException;
/**
 * 	Returns the next record
 *
 * @author		OTI
 * @version		initial
 *
 * @return		next record
 *
 * @throws 		InvalidRecordIDException	If the record has been deleted
 */
public int nextRecordId() throws InvalidRecordIDException;

/**
 * 	Returns the number of records in this enumeration
 *
 * @author		OTI
 * @version		initial
 *
 * @return		the number of records
 */
public int numRecords();

/**
 * 	Returns the previous record
 *
 * @author		OTI
 * @version		initial
 *
 * @return		the previous record
 *
 * @throws 		InvalidRecordIDException		if the record has been deleted
 * @throws 		RecordStoreNotOpenException		if the RS is closed
 * @throws 		RecordStoreException			if the method fails for any other reason
 */
public byte[] previousRecord()throws InvalidRecordIDException,
								 RecordStoreNotOpenException,
								 RecordStoreException;
/**
 * 	Returns the previous record index
 *
 * @author		OTI
 * @version		initial
 *
 * @return		the previous record index
 *
 * @throws 		InvalidRecordIDException	if the record has been deleted
 */
public int previousRecordId() throws InvalidRecordIDException;

/**
 * 	Rebuilds the enumeration. Might be time-consuming.
 *
 * @author		OTI
 * @version		initial
 */
public void rebuild();

/**
 * 	Resets the pointer to the first element in the enum.
 *
 * @author		OTI
 * @version		initial
 */
public void reset();

}
