
/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2000, 2002  All Rights Reserved
 */

package com.ibm.oti.io;

import com.ibm.oti.util.BinarySearch;

abstract class CharacterConverterSJIS extends CharacterConverter {

abstract String getByteTable();
abstract String getCharTableKeys();
abstract String getCharTableValues();

public int countChars(byte[] value, int offset, int count) {
	if (count < 0) throw new StringIndexOutOfBoundsException();
	int length = offset + count, total = 0;
	while (offset < length) {
		int b = value[offset++] & 0xff;
		if ((b >= 0x80 && b <= 0xa0) || b >= 0xe0) {
			if (offset < length) {
				offset++;
				total++;
			}
		} else total++;
	}
	return total;
}

public int convert(byte[] value, int offset, char[] chars, int charOffset, int total) {
	total += charOffset;
	String table = getByteTable();
	while (charOffset < total) {
		int b = value[offset++] & 0xff;
		if (b < 128) chars[charOffset++] = (char)b;
		else if (b >= 0xa1 && b <= 0xdf)
			chars[charOffset++] = (char)((0xff61 - 0xa1) + b);
		else {
			int index = value[offset++] & 0xff;
			if (b == 0x80 || b == 0xa0 ||
				index < 0x40 || index > 0xfc || index == 0x7f)
			{
				chars[charOffset++] = 0xfffd;
			} else {
				index -= 0x40;
				if (index >= 0x40) index--;
				b -= 0x81;
				if (b > 0x1e) b -= 0x40;
				index += b * 188;
				if (index >= table.length())
					chars[charOffset++] = 0xfffd;
				else
					chars[charOffset++] = table.charAt(index);
			}
		}
	}
	return offset;
}

public byte[] convert(char[] value, int offset, int count) {
	int total = 0;
	count += offset;
	for (int i=offset; i<count; i++) {
		char ch = value[i];
		if (ch < 128 || ch == 0xa5 ||
			(ch >= 0xff61 && ch <= 0xff9f))
				total++;
		else total += 2;
	}
	int out = 0;
	String keys = getCharTableKeys();
	String values = getCharTableValues();
	byte[] result = new byte[total];
	for (int i=offset; i<count; i++) {
		char ch = value[i];
		if (ch < 128) result[out++] = (byte)ch;
		else {
			int index = BinarySearch.binarySearch(keys, ch);
			if (index == -1)
				result[out++] = '?';
			else {
				int cp = values.charAt(index);
				byte high = (byte)(cp >> 8);
				if (high != 0) result[out++] = high;
				result[out++] = (byte)cp;
			}
		}
	}
	if (out < result.length) {
		byte[] correct = new byte[out];
		System.arraycopy(result, 0, correct, 0, out);
		result = correct;
	}
	return result;
}

}
