
/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2000, 2002  All Rights Reserved
 */

package com.ibm.oti.io;

import com.ibm.oti.util.BinarySearch;

class CharacterConverter_SJIS extends CharacterConverterSJIS {

String getByteTable() {
	return CharacterConverter_EUC_JP.jis208;
}

String getCharTableKeys() {
	return CharacterConverter_EUC_JP.keys;
}

String getCharTableValues() {
	return CharacterConverter_EUC_JP.values;
}

public byte[] convert(char[] value, int offset, int count) {
	int total = 0;
	count += offset;
	for (int i=offset; i<count; i++) {
		char ch = value[i];
		if (ch < 128 || ch == 0xa5 ||
			(ch >= 0xff61 && ch <= 0xff9f))
				total++;
		else total += 2;
	}
	int out = 0;
	String keys = getCharTableKeys();
	String values = getCharTableValues();
	byte[] result = new byte[total];
	for (int i=offset; i<count; i++) {
		char ch = value[i];
		if (ch < 128) result[out++] = (byte)ch;
		else {
			int index = BinarySearch.binarySearch(keys, ch);
			if (index == -1)
				result[out++] = '?';
			else {
				int cp = values.charAt(index);
				byte high = (byte)(cp >> 8);
				if (high > 0)
					result[out++] = '?';
				else if (high < 0 && high >= (byte)0xa0) {
					byte r = (byte)(high - 0xa0);
					result[out++] = (byte)((r + 1 >> 1) + (r < 0x3f ? 0x80 : 0xc0));
					byte c = (byte)(cp - 0xa0);
					result[out++] = (byte)(c + (r % 2 != 0 ? (c > 0x3f ? 0x40 : 0x3f) : 0x9e));
				} else
					result[out++] = (byte)cp;
			}
		}
	}
	if (out < result.length) {
		byte[] correct = new byte[out];
		System.arraycopy(result, 0, correct, 0, out);
		result = correct;
	}
	return result;
}

}
