package com.ibm.oti.io;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2001, 2006  All Rights Reserved
 */

public class CharacterConverter_UNICODEBIG extends com.ibm.oti.io.CharacterConverter {

boolean readTag = true, writeTag = true;
boolean isModal = true;

public CharacterConverter getModeless() {
	isModal = false;
	return this;
}

/* byte[] -> length */
public int countChars(byte[] value, int offset, int count) {
	if (count < 0) throw new StringIndexOutOfBoundsException();
	if (count < 2) return 0;
	if (readTag) {
		int tag = ((value[offset] & 0xff) << 8) + (value[offset+1] & 0xff);
		if (tag == 0xfeff) return (count / 2) - 1;
		if (tag == 0xfffe) return -1;
		if (isModal) readTag = false;
	}
	return count / 2;
}

/* byte[] -> char[] + offset */
public int convert(byte[] value, int offset, char[] result, int charOffset, int total) {
	// Can't consume any bytes, it is unknown how many are available
	if (total == 0) return offset;
	if (readTag) {
		offset += 2;
		if (isModal) readTag = false;
	}
	int end = offset + (total << 1);
	for (int i=offset; i<end; i += 2)
		result[charOffset++] = (char)(((value[i] & 0xff) << 8) + (value[i+1] & 0xff));
	return end;
}

/* char[] -> byte[] */
public byte[] convert(char[] value, int offset, int count) {
	int total = (count << 1) + (writeTag ? 2 : 0);
	byte[] result = new byte[total];
	int index = 0;
	if (writeTag) {
		result[index++] = (byte)0xfe;
		result[index++] = (byte)0xff;
		if (isModal) writeTag = false;
	}
	int end = offset + count;
	for (int i=offset; i<end; i++) {
		result[index++] = (byte)(value[i] >> 8);
		result[index++] = (byte)value[i];
	}
	return result;
}

}

