/*****************************************************************************
 *
 * This program is free software ; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 * $Id: mp4_stream.c 131 2004-12-04 20:36:04Z picard $
 *
 * The Core Pocket Media Player
 * Copyright (c) 2004-2005 Gabor Kovacs
 *
 ****************************************************************************/

#include "stdafx.h"

#ifdef MPEG4

// msb..lsb
// 4bit flushbits, 1bit last, 6bit run, 5bit level

_CONST uint16_t vld_intra[112+96+120+64+16] = {
0x7881,0x7861,0x70c1,0x78a1,0x70e1,0x7042,0x7023,0x7009,
0x6802,0x6802,0x60a1,0x60a1,0x6841,0x6841,0x6821,0x6821,
0x6081,0x6081,0x6061,0x6061,0x6008,0x6008,0x6007,0x6007,
0x6022,0x6022,0x6006,0x6006,0x5041,0x5041,0x5041,0x5041,
0x5005,0x5005,0x5005,0x5005,0x5004,0x5004,0x5004,0x5004,
0x4801,0x4801,0x4801,0x4801,0x4801,0x4801,0x4801,0x4801,
0x2001,0x2001,0x2001,0x2001,0x2001,0x2001,0x2001,0x2001,
0x2001,0x2001,0x2001,0x2001,0x2001,0x2001,0x2001,0x2001,
0x2001,0x2001,0x2001,0x2001,0x2001,0x2001,0x2001,0x2001,
0x2001,0x2001,0x2001,0x2001,0x2001,0x2001,0x2001,0x2001,
0x3002,0x3002,0x3002,0x3002,0x3002,0x3002,0x3002,0x3002,
0x3002,0x3002,0x3002,0x3002,0x3002,0x3002,0x3002,0x3002,
0x4021,0x4021,0x4021,0x4021,0x4021,0x4021,0x4021,0x4021,
0x4003,0x4003,0x4003,0x4003,0x4003,0x4003,0x4003,0x4003,
0xa012,0xa011,0x99c1,0x99c1,0x99a1,0x99a1,0x9981,0x9981,
0x9961,0x9961,0x9941,0x9941,0x9822,0x9822,0x9804,0x9804,
0x9181,0x9181,0x9161,0x9161,0x90e2,0x90e2,0x90c2,0x90c2,
0x90a2,0x90a2,0x9063,0x9063,0x9043,0x9043,0x9026,0x9026,
0x9025,0x9025,0x9010,0x9010,0x9082,0x9082,0x900f,0x900f,
0x900e,0x900e,0x900d,0x900d,0x8901,0x8901,0x8901,0x8901,
0x88e1,0x88e1,0x88e1,0x88e1,0x88c1,0x88c1,0x88c1,0x88c1,
0x8803,0x8803,0x8803,0x8803,0x8141,0x8141,0x8141,0x8141,
0x8121,0x8121,0x8121,0x8121,0x8101,0x8101,0x8101,0x8101,
0x8921,0x8921,0x8921,0x8921,0x8062,0x8062,0x8062,0x8062,
0x8024,0x8024,0x8024,0x8024,0x800c,0x800c,0x800c,0x800c,
0x800b,0x800b,0x800b,0x800b,0x800a,0x800a,0x800a,0x800a,
0xb807,0xb807,0xb806,0xb806,0xb016,0xb016,0xb015,0xb015,
0xa842,0xa842,0xa842,0xa842,0xa823,0xa823,0xa823,0xa823,
0xa805,0xa805,0xa805,0xa805,0xa1a1,0xa1a1,0xa1a1,0xa1a1,
0xa0a3,0xa0a3,0xa0a3,0xa0a3,0xa102,0xa102,0xa102,0xa102,
0xa083,0xa083,0xa083,0xa083,0xa064,0xa064,0xa064,0xa064,
0xa044,0xa044,0xa044,0xa044,0xa027,0xa027,0xa027,0xa027,
0xa014,0xa014,0xa014,0xa014,0xa013,0xa013,0xa013,0xa013,
0xb017,0xb017,0xb018,0xb018,0xb028,0xb028,0xb122,0xb122,
0xb862,0xb862,0xb882,0xb882,0xb9e1,0xb9e1,0xba01,0xba01,
0xc019,0xc01a,0xc01b,0xc029,0xc0c3,0xc02a,0xc045,0xc0e3,
0xc1c1,0xc808,0xc8a2,0xc8c2,0xca21,0xca41,0xca61,0xca81,
0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,
0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,
0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,
0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,

0x0a1b,0x0405,0x0303,0x0303,0x0202,0x0101,0x0101,0x0001,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0308,0x0202,0x0202,0x0102,0x0101,0x0101,0x0101,0x0101,
0x0101,0x0101,0x0001,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0f02,0x080a,0x0304,0x0202,0x0202,0x0102,0x0101,0x0101,
0x1501,0x0207,0x0101,0x0101,0x0101,0x0101,0x0101,0x0101};

_CONST uint16_t vld_inter[112+96+120+64+16] = {
0x7901,0x78e1,0x78c1,0x78a1,0x7181,0x7161,0x7141,0x7004,
0x6881,0x6881,0x6861,0x6861,0x6841,0x6841,0x6821,0x6821,
0x6121,0x6121,0x6101,0x6101,0x60e1,0x60e1,0x60c1,0x60c1,
0x6022,0x6022,0x6003,0x6003,0x50a1,0x50a1,0x50a1,0x50a1,
0x5081,0x5081,0x5081,0x5081,0x5061,0x5061,0x5061,0x5061,
0x4801,0x4801,0x4801,0x4801,0x4801,0x4801,0x4801,0x4801,
0x2001,0x2001,0x2001,0x2001,0x2001,0x2001,0x2001,0x2001,
0x2001,0x2001,0x2001,0x2001,0x2001,0x2001,0x2001,0x2001,
0x2001,0x2001,0x2001,0x2001,0x2001,0x2001,0x2001,0x2001,
0x2001,0x2001,0x2001,0x2001,0x2001,0x2001,0x2001,0x2001,
0x3021,0x3021,0x3021,0x3021,0x3021,0x3021,0x3021,0x3021,
0x3021,0x3021,0x3021,0x3021,0x3021,0x3021,0x3021,0x3021,
0x4041,0x4041,0x4041,0x4041,0x4041,0x4041,0x4041,0x4041,
0x4002,0x4002,0x4002,0x4002,0x4002,0x4002,0x4002,0x4002,
0xa009,0xa008,0x9b01,0x9b01,0x9ae1,0x9ae1,0x9ac1,0x9ac1,
0x9aa1,0x9aa1,0x9a81,0x9a81,0x9a61,0x9a61,0x9a41,0x9a41,
0x9a21,0x9a21,0x9802,0x9802,0x92c1,0x92c1,0x92a1,0x92a1,
0x9281,0x9281,0x9261,0x9261,0x9241,0x9241,0x9221,0x9221,
0x9201,0x9201,0x91e1,0x91e1,0x9082,0x9082,0x9062,0x9062,
0x9007,0x9007,0x9006,0x9006,0x8a01,0x8a01,0x8a01,0x8a01,
0x89e1,0x89e1,0x89e1,0x89e1,0x89c1,0x89c1,0x89c1,0x89c1,
0x89a1,0x89a1,0x89a1,0x89a1,0x8981,0x8981,0x8981,0x8981,
0x8961,0x8961,0x8961,0x8961,0x8941,0x8941,0x8941,0x8941,
0x8921,0x8921,0x8921,0x8921,0x81c1,0x81c1,0x81c1,0x81c1,
0x81a1,0x81a1,0x81a1,0x81a1,0x8042,0x8042,0x8042,0x8042,
0x8023,0x8023,0x8023,0x8023,0x8005,0x8005,0x8005,0x8005,
0xb822,0xb822,0xb803,0xb803,0xb00b,0xb00b,0xb00a,0xb00a,
0xab81,0xab81,0xab81,0xab81,0xab61,0xab61,0xab61,0xab61,
0xab41,0xab41,0xab41,0xab41,0xab21,0xab21,0xab21,0xab21,
0xa122,0xa122,0xa122,0xa122,0xa102,0xa102,0xa102,0xa102,
0xa0e2,0xa0e2,0xa0e2,0xa0e2,0xa0c2,0xa0c2,0xa0c2,0xa0c2,
0xa0a2,0xa0a2,0xa0a2,0xa0a2,0xa063,0xa063,0xa063,0xa063,
0xa043,0xa043,0xa043,0xa043,0xa024,0xa024,0xa024,0xa024,
0xb00c,0xb00c,0xb025,0xb025,0xb2e1,0xb2e1,0xb301,0xb301,
0xbba1,0xbba1,0xbbc1,0xbbc1,0xbbe1,0xbbe1,0xbc01,0xbc01,
0xc026,0xc044,0xc083,0xc0a3,0xc0c3,0xc142,0xc321,0xc341,
0xcc21,0xcc41,0xcc61,0xcc81,0xcca1,0xccc1,0xcce1,0xcd01,
0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,
0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,
0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,
0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,0x7fff,

0x060c,0x0304,0x0303,0x0203,0x0202,0x0102,0x0101,0x0101,
0x0101,0x0101,0x0101,0x0101,0x0101,0x0001,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0203,0x0101,0x0101,0x0101,0x0101,0x0101,0x0101,0x0101,
0x0101,0x0101,0x0101,0x0101,0x0101,0x0101,0x0101,0x0101,
0x0101,0x0101,0x0101,0x0101,0x0001,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1b02,0x070b,0x0203,0x0102,0x0101,0x0101,0x0101,0x0101,
0x2901,0x0102,0x0101,0x0101,0x0101,0x0101,0x0101,0x0101};

#define vld_write									\
	block[scan[len & 63]] = (idct_block_t)level;	\
	DEBUG_MSG2(DEBUG_VCODEC,T("block[%i] %i"), scan[len & 63], level<0 ? (level+q_add)/q_scale : (level-q_add)/q_scale);\
	if (++len < 64)	continue;						\
	endbits_pos(dec);								\
	return len - 64;							

#define vld_quant									\
	level *= q_scale;								\
	level += q_add;									\
	if (getbits1_pos(dec))							\
		level = -level;

int vld_block_mpeg4( mp4_decode* dec, const uint16_t *table, const uint8_t *scan, int len ) 
{
	idct_block_t* block = dec->blockptr;
	int q_scale = (dec->quantizer) << 1;
	int q_add = (dec->quantizer-1)|1;
	beginbits_pos(dec);

	for (;;) // event vld
	{
		int code,level;
		loadbits_pos(dec);

		vld_code;
		level = code & 31; // 0x7FFF ESCAPE -> level = 31
		if (level != 31) {
			code >>= 5;
			code &= 127;
			len += code; // last|run
			vld_quant
			vld_write
		} else {
			// this value is escaped
			loadbits_pos(dec);
			if (!getbits1_pos(dec))	{ // Type 1
				vld_code;
				level = code & 31;
				code >>= 5;
				code &= 127;
				len   += code; // last|run
				level += ((uint8_t*)(table+TABLE_LMAX))[code]; // table_lmax[last][run]
				vld_quant
				vld_write
			}
			else
			if (!getbits1_pos(dec)) { // Type 2	
				vld_code;
				len += (code >> 5) & 127;
				code &= 31;
				level = code;
				if (code > 11) code = 11;
				if (len >= 64) code += 16; // add (last bit << 4)
				len += ((uint8_t*)(table+TABLE_RMAX))[code]; // table_rmax[last][min(11,level)]
				vld_quant
				vld_write
			}
			else { // Type 3  - fixed length codes
				code = showbits_pos(dec,21) >> 1;
				flushbits_pos(dec,21);
				level = (code << 20) >> 20; //sign extend the lower 12 bits
				level *= q_scale;
				len   += code >> 13;  // last|run
				if (level > 0)
					level += q_add;
				else
					level -= q_add;

				vld_write;
			}
		}
	}
	return 0;
}

#endif
