//////////////////////////////////////////////////////////////////////////////
//
// PocketHAL
// Copyright 2004 by Thierry Tremblay
//
//////////////////////////////////////////////////////////////////////////////

#ifndef POCKETHAL_GAMEBASE_H
#define POCKETHAL_GAMEBASE_H

#include <PocketHAL/PocketHAL.h>
#include "IGame.h"


#if defined(PHAL_SYMBIAN_SERIE60)

    // Use AVKON    
    #include <aknapp.h>
    #include <aknappui.h>
    #include <akndoc.h>

    typedef CAknAppUi       CSymbianAppUI;
    typedef CAknDocument    CSymbianDocument;
    typedef CAknApplication CApplication;

#elif defined(PHAL_SYMBIAN_UIQ)

    // Use QIKON
    #include <qikapplication.h>
    #include <qikappui.h>
    #include <qikdocument.h>

    typedef CQikAppUi       CSymbianAppUI;
    typedef CQikDocument    CSymbianDocument;
    typedef CQikApplication CApplication;

#else

    #error Unknown Symbian SDK

#endif



namespace PHAL
{

//////////////////////////////////////////////////////////////////////////////
//
// SymbianDocument
//
//////////////////////////////////////////////////////////////////////////////

template<class GameClass>
class SymbianDocument : public CSymbianDocument
{
public:

    static SymbianDocument<GameClass>* NewL( CEikApplication& app )
    {
        return new (ELeave) SymbianDocument( app );
    }


private:

    SymbianDocument( CEikApplication& app )
    :   CSymbianDocument( app )
    {
    }

    // From CEikDocument, create GameBase "App UI" object.
    CEikAppUi* CreateAppUiL()
    {
        return new (ELeave) GameClass;
    }
};




//////////////////////////////////////////////////////////////////////////////
//
// SymbianApplication
//
//////////////////////////////////////////////////////////////////////////////

template<class GameClass>
class SymbianApplication : public CApplication
{
private:

    // From CApaApplication, creates Document document object.
    CApaDocument* CreateDocumentL()
    {
        return SymbianDocument<GameClass>::NewL( *this );
    }

    // From CApaApplication, returns application's UID
    TUid AppDllUid() const
    {
        return TUid::Uid( GameClass::UID );
    }
};




//////////////////////////////////////////////////////////////////////////////
//
// GameBase
//
//////////////////////////////////////////////////////////////////////////////

class SymbianView;

class GameBase : public CSymbianAppUI, public IGame
{
public:

    typedef CSymbianAppUI Superclass;

    void ConstructL();
    ~GameBase();


protected:
    
    // Initialization
    bool Initialize( const Config& config );

    // Return the window handle
    RWindow& GetWindow() const;

    // Run
    virtual bool Run();

    // Reset inactivity (prevent the screen from dimming)
    void ResetInactivity() const;


private:
    
    // From CEikAppUi, takes care of command handling.
    void HandleCommandL( TInt aCommand );

    // Called when gaining focus
    void HandleForegroundEventL( TBool aForeground );

    // Idle timer callback
    static TInt IdleTimerCallback( TAny* AppUI );

    // Data
    SymbianView* m_view;
	CIdle*       m_idleTimer;
    uint32_t     m_lastYield;
};



//////////////////////////////////////////////////////////////////////////////
//
// SymbianView
//
//////////////////////////////////////////////////////////////////////////////

class SymbianView : public CCoeControl
{
public:

    void ConstructL( const TRect& aRect, GameBase* game );


private:

    // Event handlers
    virtual TKeyResponse OfferKeyEventL( const TKeyEvent& aKeyEvent,TEventCode aType );
    virtual void         HandlePointerEventL( const TPointerEvent& aPointerEvent );

    // Data
    GameBase* m_game;
};



} // end of namespace PHAL



//////////////////////////////////////////////////////////////////////////////
//
// Program entry point declaration
//
//////////////////////////////////////////////////////////////////////////////

#define PHAL_DECLARE_ENTRY_POINT( GameClass )                           \
                                                                        \
    EXPORT_C CApaApplication* NewApplication()                          \
    {                                                                   \
        return new SymbianApplication<GameClass>;                       \
    }                                                                   \
                                                                        \
    GLDEF_C TInt E32Dll( TDllReason )                                   \
    {                                                                   \
        return KErrNone;                                                \
    }



#endif
