//////////////////////////////////////////////////////////////////////////////
//
// Firework
// Copyright 2004 by Thierry Tremblay
//
// Firework Sample for PocketHAL
// For more info: http://www.droneship.com
//
// Adapted from the Fire Demo at http://www.xdr.com/dash/fire.html
//
//////////////////////////////////////////////////////////////////////////////

#ifndef INCLUDED_FIREWORK_H
#define INCLUDED_FIREWORK_H

#include <PocketHAL/PocketHAL.h>
#include "../common/game.h"

using namespace PHAL;



//////////////////////////////////////////////////////////////////////////////
//
// Firework
//
//////////////////////////////////////////////////////////////////////////////

class Firework : public Game
{
public:

    enum { UID = 0x0B6BE660 };

    Firework();
    ~Firework();


private:
    
    // Framework callbacks
    virtual bool OnInitialize();            // Return true or false depending on success
    virtual bool OnGameLoop();              // Game loop, return true to continue running or false to shutdown


    // Animate the fire
    void Animate();

    // Draw one frame of fire
    void Draw( PHAL::Surface* backbuffer ) const;


    // Setup the palette
    void SetupPalette();

    
    // Blob helpers
    void AddBlob();
    void MoveBlobs();
    void PutBlobs();
    void Disk( int x, int y, int radius );
    void DoFire( const uint8_t* p1, uint8_t* p2, int pitch, const uint8_t* map );


    // Definitions
    struct Blob
    {
	    Blob* next;
	    int   x, y;
        int   dx, dy;
        int   life;
        int   size;
    };


    // Data
    int      m_width;        // Width of the fire in pixels
    int      m_height;       // Height of the fire in pixels

    uint16_t m_palette[256]; // Color palette

    uint8_t* m_buffer1;      // Buffer 1
    uint8_t* m_buffer2;      // Buffer 2

    uint8_t* m_map1;         // Map 1
    uint8_t* m_map2;         // Map 2

    Blob*    m_blobs;        // Blobs
    Blob*    m_freeBlobs;    // Free blobs
    Blob*    m_activeBlobs;  // Active blobs

    int      m_flash;
    int      m_explode;
    int      m_now;
};




#endif
