/*****************************************************************************
 *
 * This program is free software ; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 * $Id: divx3_data.c 131 2004-12-04 20:36:04Z picard $
 *
 * The Core Pocket Media Player
 * Copyright (c) 2004-2005 Gabor Kovacs
 *
 ****************************************************************************/
 
#include "stdafx.h"

#ifdef MSMPEG4

_CONST uint32_t mv0_code[1100] = { // maxbit 17
0x00000021,0x00000064,0x000000A4,0x000000E4,
0x00000065,0x00000105,0x00000185,0x00000026,
0x00000046,0x00000366,0x000000C7,0x00000167,
0x000002A7,0x00000048,0x000001C8,0x000001E8,
0x00000288,0x00000408,0x00000448,0x000004A8,
0x000004E8,0x00000528,0x000005A8,0x00000968,
0x000009A8,0x00000069,0x00000449,0x00000469,
0x000004A9,0x000004E9,0x00000849,0x00000909,
0x00000929,0x00000A09,0x00000B89,0x00001229,
0x000013E9,0x000001CA,0x0000086A,0x0000098A,
0x00000A8A,0x00000ACA,0x0000118A,0x0000130A,
0x0000134A,0x0000136A,0x0000162A,0x0000164A,
0x0000240A,0x0000242A,0x000024CA,0x0000266A,
0x0000272A,0x0000342A,0x0000348A,0x000034AA,
0x000034CA,0x000034EA,0x000035CA,0x000035EA,
0x0000016B,0x0000032B,0x000010AB,0x0000120B,
0x0000136B,0x0000154B,0x000015EB,0x0000218B,
0x000021CB,0x0000238B,0x000023CB,0x0000266B,
0x0000288B,0x00002C0B,0x00002E8B,0x00002EAB,
0x00002EEB,0x00002F0B,0x0000492B,0x0000496B,
0x00004A4B,0x00004C2B,0x00004CAB,0x00004E0B,
0x00006A4B,0x00006A6B,0x00006AAB,0x00006B2B,
0x0000020C,0x0000022C,0x0000026C,0x0000068C,
0x000006AC,0x000006CC,0x000006EC,0x000007AC,
0x000007CC,0x0000212C,0x000024CC,0x00002ACC,
0x0000434C,0x000043CC,0x0000474C,0x000047CC,
0x000051CC,0x000051EC,0x000059EC,0x0000922C,
0x0000928C,0x000093EC,0x0000940C,0x0000946C,
0x000094CC,0x000094EC,0x000095AC,0x000095CC,
0x0000980C,0x0000988C,0x000098CC,0x0000990C,
0x0000992C,0x00009EAC,0x00009ECC,0x00009EEC,
0x0000D00C,0x0000D04C,0x0000D06C,0x0000D10C,
0x0000D12C,0x0000D1AC,0x0000D1CC,0x0000D1EC,
0x0000D44C,0x0000D46C,0x0000D52C,0x0000D60C,
0x0000D62C,0x0000D68C,0x0000D6AC,0x0000048D,
0x00000C0D,0x00000C6D,0x00000F0D,0x00000F2D,
0x0000422D,0x0000488D,0x000048AD,0x000048ED,
0x0000490D,0x0000492D,0x0000494D,0x0000496D,
0x00004D6D,0x000055ED,0x0000570D,0x0000576D,
0x000086CD,0x00008ECD,0x00008EED,0x00008FCD,
0x0000990D,0x0000992D,0x0000994D,0x0000A28D,
0x0000B0CD,0x0000B0ED,0x0000B30D,0x0000B3AD,
0x0000BB2D,0x0000BB4D,0x0001240D,0x0001242D,
0x0001276D,0x0001278D,0x000127AD,0x0001284D,
0x0001286D,0x0001288D,0x000128AD,0x00012B2D,
0x00012BCD,0x00012BED,0x0001304D,0x0001306D,
0x000131CD,0x000131ED,0x0001388D,0x00013CED,
0x00013D0D,0x00013D2D,0x0001A04D,0x0001A2ED,
0x0001A30D,0x0001A32D,0x0001A82D,0x0001A84D,
0x0001A86D,0x0001AA0D,0x0001ABED,0x0001ADAD,
0x0001ADCD,0x0001ADED,0x00000A4E,0x00000A6E,
0x00000A8E,0x00000AAE,0x00000ACE,0x00000AEE,
0x0000184E,0x0000186E,0x0000188E,0x000018AE,
0x000083CE,0x000083EE,0x0000840E,0x0000842E,
0x0000918E,0x000091AE,0x00009A6E,0x00009A8E,
0x00009AAE,0x0000AB8E,0x0000ABAE,0x0000AE4E,
0x0000AE6E,0x0000AE8E,0x0000AEAE,0x00011BCE,
0x00011BEE,0x00011FCE,0x00011FEE,0x000132CE,
0x000146CE,0x000146EE,0x0001610E,0x0001612E,
0x0001614E,0x0001616E,0x0001664E,0x0001666E,
0x0001668E,0x000166AE,0x000166CE,0x000166EE,
0x0001670E,0x0001672E,0x0001760E,0x00017EEE,
0x00017F0E,0x00017F2E,0x00017F4E,0x00017F6E,
0x00017F8E,0x00017FAE,0x00017FCE,0x00017FEE,
0x00024A8E,0x00024AAE,0x00024ACE,0x00024AEE,
0x00024E0E,0x00024E2E,0x00024E4E,0x00024E6E,
0x00024E8E,0x00024EAE,0x0002556E,0x0002558E,
0x000255AE,0x000255CE,0x000255EE,0x0002560E,
0x0002562E,0x000262AE,0x000262CE,0x000262EE,
0x000277EE,0x0002780E,0x0002782E,0x0002784E,
0x0002786E,0x0002788E,0x000278AE,0x000278CE,
0x000278EE,0x0002790E,0x0002792E,0x0002794E,
0x0002796E,0x0002798E,0x000279AE,0x000340CE,
0x000340EE,0x0003450E,0x0003452E,0x0003454E,
0x0003456E,0x0003458E,0x000345AE,0x0003500E,
0x0003576E,0x0003578E,0x000357AE,0x00035B0E,
0x00035B2E,0x0000128F,0x000012AF,0x000012CF,
0x000012EF,0x0000140F,0x0000142F,0x0000144F,
0x0000146F,0x0001062F,0x0001064F,0x0001066F,
0x0001068F,0x000106AF,0x000106CF,0x000106EF,
0x0001070F,0x0001072F,0x0001074F,0x0001076F,
0x0001272F,0x0001274F,0x0001276F,0x0001278F,
0x000127AF,0x000127CF,0x000127EF,0x0001340F,
0x0001342F,0x0001344F,0x0001346F,0x0001348F,
0x000134AF,0x0002358F,0x000235AF,0x000235CF,
0x000235EF,0x0002360F,0x0002362F,0x0002364F,
0x0002366F,0x0002368F,0x000236AF,0x000236CF,
0x000236EF,0x0002370F,0x0002372F,0x0002374F,
0x0002376F,0x000265EF,0x00028A8F,0x00028AAF,
0x00028ACF,0x00028AEF,0x00028B0F,0x00028B2F,
0x00028B4F,0x00028B6F,0x00028B8F,0x00028BAF,
0x00028BCF,0x00028BEF,0x00028C0F,0x00028C2F,
0x00028C4F,0x00028C6F,0x00028C8F,0x00028CAF,
0x00028CCF,0x00028CEF,0x00028D0F,0x00028D2F,
0x00028D4F,0x00028D6F,0x0002FBCF,0x0002FBEF,
0x0002FC0F,0x0002FC2F,0x0002FC4F,0x0002FC6F,
0x0002FC8F,0x0002FCAF,0x0002FCCF,0x0002FCEF,
0x0002FD0F,0x0002FD2F,0x0002FD4F,0x0002FD6F,
0x0002FD8F,0x0002FDAF,0x0004A80F,0x0004A82F,
0x0004A84F,0x0004A86F,0x0004A88F,0x0004A8AF,
0x0004A8CF,0x0004A8EF,0x0004A90F,0x0004A92F,
0x0004A94F,0x0004A96F,0x0004A98F,0x0004A9AF,
0x0004A9CF,0x0004A9EF,0x0004AA0F,0x0004AA2F,
0x0004AA4F,0x0004AA6F,0x0004AA8F,0x0004AAAF,
0x0004C50F,0x0004ECCF,0x0004ECEF,0x0004ED0F,
0x0004ED2F,0x0004ED4F,0x0004ED6F,0x0004ED8F,
0x0004EDAF,0x0004EDCF,0x0004EDEF,0x0004EE0F,
0x0004EE2F,0x0004EE4F,0x0004EE6F,0x0004EE8F,
0x0004EEAF,0x0004EECF,0x0004EEEF,0x0004EF0F,
0x0004EF2F,0x0004EF4F,0x0004EF6F,0x0004EF8F,
0x0004EFAF,0x0006A06F,0x0006A88F,0x0006A8AF,
0x0006A8CF,0x0006A8EF,0x0006AC0F,0x0006AC2F,
0x0006AC4F,0x0006AC6F,0x0006AC8F,0x0006ACAF,
0x0006ACCF,0x0006ACEF,0x0006AD0F,0x0006AD2F,
0x0006AD4F,0x0006AD6F,0x0006AD8F,0x0006ADAF,
0x0006ADCF,0x0006ADEF,0x0006AE0F,0x0006AE2F,
0x0006AE4F,0x0006AE6F,0x0006AE8F,0x0006AEAF,
0x00007E10,0x000207B0,0x000207D0,0x000207F0,
0x00020810,0x00020830,0x00020850,0x00020870,
0x00020890,0x000208B0,0x000208D0,0x000208F0,
0x00020910,0x00020930,0x00020950,0x00020970,
0x00020990,0x000209B0,0x000209D0,0x000209F0,
0x00020A10,0x00020A30,0x00020A50,0x00020A70,
0x00020A90,0x00020AB0,0x00020AD0,0x00020AF0,
0x00020B10,0x00020B30,0x00020B50,0x00020B70,
0x00020B90,0x00020BB0,0x00020BD0,0x00020BF0,
0x00020C10,0x00020C30,0x00024E10,0x00024E30,
0x00043710,0x00043730,0x00043750,0x00043770,
0x00043790,0x000437B0,0x000437D0,0x000437F0,
0x00043E10,0x00043E30,0x00043E50,0x00043E70,
0x00043E90,0x00043EB0,0x00043ED0,0x00043EF0,
0x00043F10,0x00043F30,0x00043F50,0x00043F70,
0x00043F90,0x00043FB0,0x00043FD0,0x00043FF0,
0x00046810,0x00046830,0x00046850,0x00046870,
0x00046890,0x000468B0,0x000468D0,0x000468F0,
0x00046910,0x00046930,0x00046950,0x00046970,
0x00046990,0x000469B0,0x000469D0,0x000469F0,
0x00046A10,0x00046A30,0x00046A50,0x00046A70,
0x00046A90,0x00046AB0,0x00046AD0,0x00046AF0,
0x0004CB90,0x0005F110,0x0005F130,0x0005F150,
0x0005F170,0x0005F190,0x0005F1B0,0x0005F1D0,
0x0005F1F0,0x0005F210,0x0005F230,0x0005F250,
0x0005F270,0x0005F290,0x0005F2B0,0x0005F2D0,
0x0005F2F0,0x0005F310,0x0005F330,0x0005F350,
0x0005F370,0x0005F390,0x0005F3B0,0x0005F3D0,
0x0005F3F0,0x0005F410,0x0005F430,0x0005F450,
0x0005F470,0x0005F490,0x0005F4B0,0x0005F4D0,
0x0005F4F0,0x0005F510,0x0005F530,0x0005F550,
0x0005F570,0x0005F590,0x0005F5B0,0x0005F5D0,
0x0005F5F0,0x0005F610,0x0005F630,0x0005F650,
0x0005F670,0x0005F690,0x0005F6B0,0x0005F6D0,
0x0005F6F0,0x0005F710,0x0005F730,0x0005F750,
0x0005F770,0x00098A50,0x00098A70,0x0009C510,
0x0009C530,0x0009C550,0x0009C570,0x0009C590,
0x0009C5B0,0x0009C5D0,0x0009C5F0,0x0009C610,
0x0009C630,0x0009C650,0x0009C670,0x0009C690,
0x0009C6B0,0x0009C6D0,0x0009C6F0,0x0009C710,
0x0009C730,0x0009C750,0x0009C770,0x0009C790,
0x0009C7B0,0x0009C7D0,0x0009C7F0,0x0009D010,
0x0009D030,0x0009D050,0x0009D070,0x0009D090,
0x0009D0B0,0x0009D0D0,0x0009D0F0,0x0009D110,
0x0009D130,0x0009D150,0x0009D170,0x0009D190,
0x0009D1B0,0x0009D1D0,0x0009D1F0,0x0009D210,
0x0009D230,0x0009D250,0x0009D270,0x0009D290,
0x0009D2B0,0x0009D2D0,0x0009D2F0,0x0009D310,
0x0009D330,0x0009D350,0x0009D370,0x0009D390,
0x0009D3B0,0x0009D3D0,0x0009D3F0,0x0009D410,
0x0009D430,0x0009D450,0x0009D470,0x0009D490,
0x0009D4B0,0x0009D4D0,0x0009D4F0,0x0009D510,
0x0009D530,0x0009D550,0x0009D570,0x0009D590,
0x0009D5B0,0x0009D5D0,0x0009D5F0,0x0009D610,
0x0009D630,0x0009D650,0x0009D670,0x0009D690,
0x0009D6B0,0x0009D6D0,0x0009D6F0,0x0009D710,
0x0009D730,0x0009D750,0x0009D770,0x0009D790,
0x0009D7B0,0x0009D7D0,0x0009D7F0,0x0009D810,
0x0009D830,0x0009D850,0x0009D870,0x0009D890,
0x0009D8B0,0x0009D8D0,0x0009D8F0,0x0009D910,
0x0009D930,0x0009D950,0x0009D970,0x000D4090,
0x000D40B0,0x0000FC51,0x0000FC71,0x0000FC91,
0x0000FCB1,0x0000FCD1,0x0000FCF1,0x0000FD11,
0x0000FD31,0x0000FD51,0x0000FD71,0x0000FD91,
0x0000FDB1,0x0000FDD1,0x0000FDF1,0x0000FE11,
0x0000FE31,0x0000FE51,0x0000FE71,0x0000FE91,
0x0000FEB1,0x0000FED1,0x0000FEF1,0x0000FF11,
0x0000FF31,0x0000FF51,0x0000FF71,0x0000FF91,
0x0000FFB1,0x0000FFD1,0x0000FFF1,0x00040011,
0x00040031,0x00040051,0x00040071,0x00040091,
0x000400B1,0x000400D1,0x000400F1,0x00040111,
0x00040131,0x00040151,0x00040171,0x00040191,
0x000401B1,0x000401D1,0x000401F1,0x00040211,
0x00040231,0x00040251,0x00040271,0x00040291,
0x000402B1,0x000402D1,0x000402F1,0x00040311,
0x00040331,0x00040351,0x00040371,0x00040391,
0x000403B1,0x000403D1,0x000403F1,0x00040411,
0x00040431,0x00040451,0x00040471,0x00040491,
0x000404B1,0x000404D1,0x000404F1,0x00040511,
0x00040531,0x00040551,0x00040571,0x00040591,
0x000405B1,0x000405D1,0x000405F1,0x00040611,
0x00040631,0x00040651,0x00040671,0x00040691,
0x000406B1,0x000406D1,0x000406F1,0x00040711,
0x00040731,0x00040751,0x00040771,0x00040791,
0x000407B1,0x000407D1,0x000407F1,0x00040811,
0x00040831,0x00040851,0x00040871,0x00040891,
0x000408B1,0x000408D1,0x000408F1,0x00040911,
0x00040931,0x00040951,0x00040971,0x00040991,
0x000409B1,0x000409D1,0x000409F1,0x00040A11,
0x00040A31,0x00040A51,0x00040A71,0x00040A91,
0x00040AB1,0x00040AD1,0x00040AF1,0x00040B11,
0x00040B31,0x00040B51,0x00040B71,0x00040B91,
0x00040BB1,0x00040BD1,0x00040BF1,0x00040C11,
0x00040C31,0x00040C51,0x00040C71,0x00040C91,
0x00040CB1,0x00040CD1,0x00040CF1,0x00040D11,
0x00040D31,0x00040D51,0x00040D71,0x00040D91,
0x00040DB1,0x00040DD1,0x00040DF1,0x00040E11,
0x00040E31,0x00040E51,0x00040E71,0x00040E91,
0x00040EB1,0x00040ED1,0x00040EF1,0x00040F11,
0x00040F31,0x00099751,0x00099771,0x000BB111,
0x000BB131,0x000BB151,0x000BB171,0x000BB191,
0x000BB1B1,0x000BB1D1,0x000BB1F1,0x000BB611,
0x000BB631,0x000BB651,0x000BB671,0x000BB691,
0x000BB6B1,0x000BB6D1,0x000BB6F1,0x000BB711,
0x000BB731,0x000BB751,0x000BB771,0x000BB791,
0x000BB7B1,0x000BB7D1,0x000BB7F1,0x000BC811,
0x000BC831,0x000BC851,0x000BC871,0x000BC891,
0x000BC8B1,0x000BC8D1,0x000BC8F1,0x000BC911,
0x000BC931,0x000BC951,0x000BC971,0x000BC991,
0x000BC9B1,0x000BC9D1,0x000BC9F1,0x000BCA11,
0x000BCA31,0x000BCA51,0x000BCA71,0x000BCA91,
0x000BCAB1,0x000BCAD1,0x000BCAF1,0x000BCB11,
0x000BCB31,0x000BCB51,0x000BCB71,0x000BCB91,
0x000BCBB1,0x000BCBD1,0x000BCBF1,0x000BCC11,
0x000BCC31,0x000BCC51,0x000BCC71,0x000BCC91,
0x000BCCB1,0x000BCCD1,0x000BCCF1,0x000BCD11,
0x000BCD31,0x000BCD51,0x000BCD71,0x000BCD91,
0x000BCDB1,0x000BCDD1,0x000BCDF1,0x000BCE11,
0x000BCE31,0x000BCE51,0x000BCE71,0x000BCE91,
0x000BCEB1,0x000BCED1,0x000BCEF1,0x000BCF11,
0x000BCF31,0x000BCF51,0x000BCF71,0x000BCF91,
0x000BCFB1,0x000BCFD1,0x000BCFF1,0x000BD011,
0x000BD031,0x000BD051,0x000BD071,0x000BD091,
0x000BD0B1,0x000BD0D1,0x000BD0F1,0x000BD111,
0x000BD131,0x000BD151,0x000BD171,0x000BD191,
0x000BD1B1,0x000BD1D1,0x000BD1F1,0x000BD211,
0x000BD231,0x000BD251,0x000BD271,0x000BD291,
0x000BD2B1,0x000BD2D1,0x000BD2F1,0x000BD311,
0x000BD331,0x000BD351,0x000BD371,0x000BD391,
0x000BD3B1,0x000BD3D1,0x000BD3F1,0x000BD411,
0x000BD431,0x000BD451,0x000BD471,0x000BD491,
0x000BD4B1,0x000BD4D1,0x000BD4F1,0x000BD511,
0x000BD531,0x000BD551,0x000BD571,0x000BD591,
0x000BD5B1,0x000BD5D1,0x000BD5F1,0x000BD611,
0x000BD631,0x000BD651,0x000BD671,0x000BD691,
0x000BD6B1,0x000BD6D1,0x000BD6F1,0x000BD711,
0x000BD731,0x000BD751,0x000BD771,0x000BD791,
0x000BD7B1,0x000BD7D1,0x000BD7F1,0x000BD811,
0x000BD831,0x000BD851,0x000BD871,0x000BD891,
0x000BD8B1,0x000BD8D1,0x000BD8F1,0x000BD911,
0x000BD931,0x000BD951,0x000BD971,0x000BD991,
0x000BD9B1,0x000BD9D1,0x000BD9F1,0x000BDA11,
0x000BDA31,0x000BDA51,0x000BDA71,0x000BDA91,
0x000BDAB1,0x000BDAD1,0x000BDAF1,0x000BDB11,
0x000BDB31,0x000BDB51,0x000BDB71,0x000BDB91,
0x000BDBB1,0x000BDBD1,0x000BDBF1,0x000BDC11,
0x000BDC31,0x000BDC51,0x000BDC71,0x000BDC91,
0x000BDCB1,0x000BDCD1,0x000BDCF1,0x000BDD11,
0x000BDD31,0x000BDD51,0x000BDD71,0x000BDD91,
0x000BDDB1,0x000BDDD1,0x000BDDF1,0x000BDE11,
0x000BDE31,0x000BDE51,0x000BDE71,0x000BDE91,
0x000BDEB1,0x000BDED1,0x000BDEF1,0x000BDF11,
0x000BDF31,0x000BDF51,0x000BDF71,0x000BDF91,
0x000BDFB1,0x000BDFD1,0x000BDFF1,0x000BE011,
0x000BE031,0x000BE051,0x000BE071,0x000BE091,
0x000BE0B1,0x000BE0D1,0x000BE0F1,0x000BE111,
0x000BE131,0x000BE151,0x000BE171,0x000BE191,
0x000BE1B1,0x000BE1D1,0x000BE1F1,0x00000008};
_CONST uint16_t mv0_data[1100] = {
0x0820,0x07e0,0x081f,0x0860,0x0821,0x07df,0x07e1,0x085f,
0x0861,0x08a0,0x0822,0x07a0,0x081e,0x08e0,0x089f,0x07e2,
0x0823,0x0760,0x0862,0x07a1,0x081d,0x08a1,0x085e,0x07de,
0x079f,0x08df,0x07e3,0x07dd,0x0761,0x0863,0x08e1,0x07a2,
0x075f,0x085d,0x089e,0x08a2,0x079e,0x0824,0x081c,0x0920,
0x0762,0x0825,0x08de,0x081b,0x0720,0x0819,0x0827,0x06e0,
0x08e2,0x0960,0x08a3,0x0763,0x07a3,0x091f,0x08e3,0x089d,
0x0660,0x079d,0x075e,0x08dd,0x0865,0x07db,0x07e4,0x0826,
0x07e5,0x0721,0x09e0,0x071f,0x075d,0x095f,0x07dc,0x0864,
0x06e1,0x091e,0x0722,0x0921,0x0961,0x085c,0x085b,0x07d9,
0x06df,0x081a,0x07e7,0x09a0,0x06a0,0x065f,0x0661,0x0867,
0x09df,0x07e6,0x089c,0x07a4,0x0815,0x0817,0x082b,0x08a4,
0x0922,0x0829,0x071e,0x0859,0x079c,0x099f,0x095e,0x06e2,
0x0866,0x0723,0x083d,0x0962,0x08dc,0x099e,0x0765,0x08a5,
0x06e3,0x075b,0x0764,0x0803,0x083b,0x08a6,0x08e5,0x00e0,
0x069f,0x091d,0x07da,0x09a1,0x07a5,0x06a1,0x08db,0x089b,
0x0963,0x06a2,0x0662,0x0828,0x082a,0x09e1,0x05e0,0x095d,
0x0804,0x0805,0x075c,0x0818,0x0759,0x0923,0x0767,0x07a6,
0x0a60,0x07d7,0x079b,0x0560,0x09de,0x0663,0x089a,0x09a2,
0x083c,0x08e4,0x09dd,0x0816,0x085a,0x0869,0x0807,0x06de,
0x0766,0x065e,0x0724,0x06dd,0x069e,0x07e9,0x079a,0x08d9,
0x0620,0x0622,0x07d8,0x08a7,0x0801,0x0799,0x08e7,0x0a20,
0x071c,0x099d,0x0160,0x08e6,0x075a,0x0924,0x091c,0x083f,
0x099c,0x07a7,0x0857,0x07d5,0x08da,0x06a3,0x05df,0x09a3,
0x0839,0x0a5f,0x071d,0x065d,0x095c,0x0a1e,0x095b,0x09e3,
0x0802,0x0926,0x0868,0x09e2,0x0665,0x069d,0x0726,0x07eb,
0x071a,0x0aa0,0x05e1,0x07ea,0x0858,0x07e8,0x09dc,0x0060,
0x0ee0,0x05a0,0x06e4,0x0120,0x086b,0x0899,0x0855,0x061f,
0x0a5e,0x00df,0x08e9,0x0a5d,0x0a61,0x0725,0x091a,0x0925,
0x071b,0x087b,0x08d7,0x0561,0x05e3,0x055f,0x059f,0x0965,
0x06e6,0x06e7,0x0ae0,0x0757,0x0f20,0x09db,0x06e5,0x0664,
0x0edf,0x08a8,0x06d9,0x06db,0x06a6,0x0a1f,0x0964,0x06dc,
0x0f5f,0x06a4,0x09d9,0x086d,0x07c3,0x05a2,0x0966,0x0667,
0x07a8,0x0666,0x061e,0x0f60,0x07d3,0x0898,0x0659,0x099a,
0x082d,0x0814,0x0798,0x00e1,0x0f61,0x0adf,0x0769,0x05e2,
0x0727,0x082f,0x0728,0x083a,0x07fb,0x08a9,0x0161,0x0843,
0x0811,0x087d,0x086a,0x0a9e,0x095a,0x05dd,0x09a4,0x07fd,
0x0a21,0x06a5,0x083e,0x069c,0x0959,0x09a6,0x0919,0x0626,
0x0751,0x0797,0x0522,0x05a1,0x0755,0x0621,0x0831,0x0a5b,
0x00a0,0x0897,0x065b,0x0856,0x0758,0x07d6,0x09e7,0x08eb,
0x091b,0x0625,0x0806,0x07aa,0x086f,0x06da,0x0b1e,0x0f1f,
0x07a9,0x0927,0x04e1,0x0896,0x07ed,0x0624,0x0420,0x08ed,
0x0813,0x0996,0x055e,0x0845,0x07c5,0x07d1,0x055d,0x08d6,
0x015f,0x045f,0x076b,0x09a5,0x099b,0x04a0,0x0ea0,0x04e0,
0x0ae1,0x0a62,0x07ab,0x0a63,0x0add,0x09da,0x0756,0x01e0,
0x0753,0x0460,0x0719,0x04df,0x0729,0x07f1,0x065c,0x04e2,
0x0a1c,0x06a7,0x0562,0x0853,0x09e5,0x05e6,0x0a1d,0x0795,
0x09e4,0x08aa,0x08d8,0x0830,0x0810,0x061c,0x0871,0x0796,
0x0a22,0x0bdf,0x09e6,0x0967,0x082c,0x084b,0x0623,0x05de,
0x0b61,0x0be1,0x06d7,0x05dc,0x0aa1,0x082e,0x080f,0x084d,
0x0918,0x0969,0x0958,0x0462,0x04a2,0x059e,0x0a1a,0x0998,
0x080e,0x07fc,0x08d5,0x061d,0x0467,0x0657,0x0463,0x05e5,
0x087f,0x08ad,0x0ce1,0x0aa2,0x07ef,0x0929,0x0916,0x076a,
0x0563,0x05a3,0x0957,0x0b20,0x0ae3,0x066b,0x0be0,0x0847,
0x0b5f,0x06e9,0x07d4,0x0e9f,0x07d0,0x080d,0x07ff,0x0999,
0x0ade,0x0520,0x0be3,0x0b5e,0x0d9e,0x005f,0x06aa,0x08af,
0x09a7,0x03a6,0x05a8,0x0628,0x0873,0x08b7,0x0838,0x0812,
0x0955,0x0567,0x05e7,0x0c61,0x08d1,0x05e9,0x0717,0x09d8,
0x09eb,0x05d9,0x0ddf,0x0854,0x0793,0x07ad,0x0fc1,0x0422,
0x0a9f,0x0716,0x0363,0x084f,0x086e,0x08ee,0x04e3,0x0b9f,
0x0adc,0x045d,0x04dd,0x0917,0x09e9,0x061b,0x07ce,0x0835,
0x0875,0x069b,0x0718,0x0fa0,0x0879,0x0fe0,0x0851,0x09ea,
0x04e5,0x0c5d,0x0461,0x07c1,0x0ad9,0x0360,0x03e0,0x077f,
0x065a,0x08e8,0x086c,0x05e4,0x0c5f,0x0a67,0x0714,0x0754,
0x08ac,0x0997,0x01e1,0x0f62,0x02e3,0x0ca1,0x0361,0x0a5c,
0x04e9,0x0bd7,0x0669,0x06a9,0x03dd,0x0a99,0x0a5a,0x0771,
0x0b5d,0x06d8,0x0465,0x08f1,0x0832,0x0773,0x0833,0x061a,
0x0367,0x0699,0x069a,0x07cf,0x0627,0x0852,0x072a,0x0791,
0x07c4,0x02df,0x0b60,0x0ba0,0x087c,0x0841,0x08ea,0x0e60,
0x0800,0x080c,0x08d3,0x0b63,0x0895,0x02e9,0x0951,0x0a9a,
0x09d4,0x096d,0x07ee,0x0c60,0x0565,0x06d6,0x076f,0x0bdd,
0x0d5f,0x0a1b,0x0cdd,0x041e,0x0695,0x0061,0x0a23,0x0792,
0x0a59,0x0b21,0x08b2,0x0673,0x06ea,0x07c2,0x08cf,0x08f3,
0x07f5,0x03e1,0x0c59,0x005d,0x08f7,0x0a25,0x0166,0x0ea1,
0x0566,0x077b,0x05a6,0x0ee1,0x0b67,0x07cd,0x0260,0x06a8,
0x027d,0x077d,0x02e0,0x0809,0x07ac,0x00c3,0x035f,0x051d,
0x0499,0x051f,0x02db,0x00d7,0x0749,0x0a19,0x07c9,0x0d5d,
0x0794,0x045e,0x051e,0x096a,0x07d2,0x0a9c,0x0bd9,0x0bdc,
0x0d9c,0x0995,0x025d,0x08ab,0x035d,0x096b,0x055a,0x066c,
0x06ec,0x0ad5,0x0aa6,0x0b55,0x0a18,0x066d,0x06ed,0x0ba3,
0x05a7,0x0656,0x0d63,0x0524,0x00a2,0x03a2,0x09ed,0x03e2,
0x059d,0x0b1f,0x08ae,0x0559,0x09ae,0x0850,0x06d1,0x0c1f,
0x0894,0x0d20,0x08ef,0x0bef,0x0c6f,0x0da0,0x00b1,0x0371,
0x05f1,0x0d1f,0x0741,0x0b5b,0x059c,0x0c67,0x0da7,0x0555,
0x0a24,0x0a97,0x07f3,0x0782,0x0768,0x08b3,0x0020,0x0675,
0x05d8,0x0cde,0x0618,0x0ede,0x0715,0x09a8,0x0779,0x07f9,
0x009f,0x0369,0x07fa,0x0220,0x07cc,0x0844,0x0320,0x0b62,
0x0a7b,0x01df,0x03a0,0x078d,0x0649,0x04a3,0x0ada,0x0523,
0x0ae5,0x08fd,0x0b25,0x007f,0x0c5a,0x0a9d,0x0aa9,0x04a6,
0x0a57,0x0994,0x0a69,0x0b1a,0x0d69,0x02ea,0x052a,0x066a,
0x0b5a,0x0b9a,0x0bda,0x0c1a,0x09c1,0x0d1a,0x0ba5,0x0c65,
0x0fe5,0x0dd7,0x0b22,0x09aa,0x035b,0x036b,0x0e62,0x059b,
0x0cdf,0x0418,0x0321,0x0710,0x08c3,0x0e5f,0x0658,0x0521,
0x0698,0x0704,0x072c,0x076c,0x080b,0x07ec,0x0f9f,0x088d,
0x08cd,0x08ec,0x04ed,0x0c4d,0x0c19,0x09d6,0x0a26,0x049a,
0x0ae6,0x0ba6,0x02e7,0x01a0,0x0c1e,0x04e7,0x0c5e,0x0a56,
0x02a0,0x05da,0x0e9e,0x046f,0x056f,0x05ef,0x0893,0x07af,
0x0f1e,0x001f,0x0b23,0x0888,0x0697,0x096f,0x0baf,0x0adb,
0x0c63,0x0eef,0x011f,0x08b0,0x0ee3,0x0953,0x05a4,0x0671,
0x0731,0x0ba1,0x019f,0x0a27,0x0edb,0x0aa7,0x0931,0x0f71,
0x0732,0x07b2,0x07f2,0x0ae7,0x029f,0x05b3,0x05f3,0x0be7,
0x051c,0x0d21,0x0de1,0x0915,0x0668,0x041f,0x0074,0x02f5,
0x06e8,0x0775,0x0149,0x0fe1,0x049f,0x0a75,0x07f6,0x08b6,
0x09b6,0x0077,0x0177,0x0362,0x070f,0x07f8,0x0459,0x09b8,
0x09d5,0x0a55,0x0928,0x0968,0x0599,0x09e8,0x087a,0x0ae4,
0x0ac5,0x03e9,0x0469,0x0c4c,0x07bc,0x0569,0x05a9,0x0525,
0x0296,0x047d,0x0652,0x0d9d,0x0e5d,0x00de,0x08bd,0x021e,
0x093d,0x067e,0x07fe,0x039e,0x03de,0x04ff,0x0752,0x064d,
0x049e,0x09d7,0x0d53,0x0594,0x06d4,0x0529,0x074d,0x0842,
0x0a45,0x0a85,0x08c1,0x0f85,0x0ca0,0x0746,0x0d60,0x0ca3,
0x08d4,0x0de3,0x0a9b,0x0f63,0x0fe3,0x0124,0x01e4,0x0a8d,
0x0564,0x0ba9,0x0be9,0x0c69,0x06c3,0x0b9e,0x046a,0x0ddb,
0x0a54,0x0c9e,0x0fdb,0x011c,0x0e1e,0x0495,0x0221,0x02a1,
0x048e,0x0cd8,0x0fde,0x092a,0x0dd8,0x04a1,0x0159,0x0dea,
0x026b,0x074e,0x046b,0x056b,0x078e,0x06eb,0x0047,0x0ee4,
0x01e5,0x02e5,0x0325,0x03e5,0x0147,0x0a8e,0x0619,0x0a6b,
0x0aeb,0x01ec,0x06cf,0x05a5,0x0647,0x07c7,0x0783,0x0941,
0x0588,0x09cf,0x0d4f,0x0748,0x092c,0x096c,0x0c2c,0x002d,
0x016d,0x036d,0x046d,0x07c8,0x0808,0x06ad,0x0b95,0x072d,
0x0b1c,0x0b5c,0x0b9c,0x0d55,0x0c5c,0x0cdc,0x00d6,0x0a65,
0x00ee,0x05ae,0x0aa5,0x0848,0x015d,0x0b65,0x01dd,0x0596,
0x0a2e,0x0d65,0x0616,0x039d,0x066f,0x06ef,0x02a6,0x0326,
0x0890,0x0426,0x0466,0x0d61,0x0526,0x0696,0x09ef,0x0b6f,
0x049d,0x0b59,0x08d0,0x0840,0x07f0,0x0c41,0x0122,0x09f0,
0x0ab0,0x02e2,0x0cd9,0x015a,0x035a,0x06b1,0x06f1,0x045a,
0x0d01,0x07b1,0x0004,0x059a,0x0304,0x08b1,0x0f81,0x0909,
0x09b1,0x0a71,0x0bf1,0x078a,0x0ff1,0x0991,0x0a66,0x0ad1,
0x0ed1,0x0872,0x0b66,0x0972,0x09b2,0x0a16,0x0be6,0x0633,
0x0c26,0x0c66,0x07b3,0x0067,0x02a7,0x0592,0x0c56,0x03e7,
0x09f3,0x0ed6,0x07f4,0x0834,0x0874,0x04a7,0x0375,0x03f5,
0x07ca,0x0557,0x06d2,0x0b1d,0x0a8a,0x09f5,0x0b9d,0x0476,
0x068b,0x0836,0x078b,0x07cb,0x0037,0x0781,0x0892,0x0277,
0x0337,0x0377,0x0677,0x07f7,0x0837,0x0ddd,0x0ae2,0x08d2,
0x0f5d,0x0878,0x08f8,0x0ba2,0x0679,0x0be2,0x0c22,0x0f9d,
0x0fdd,0x09b9,0x0f79,0x0063,0x00a3,0x0163,0x01e3,0x0263,
0x0ba7,0x02a3,0x08bb,0x08fb,0x0912,0x0dfb,0x0ce7,0x01de,
0x0a12,0x05e8,0x08bc,0x097c,0x017d,0x035e,0x0a92,0x04bd,
0x067d,0x06d3,0x0713,0x0ff0};

_CONST uint32_t mv1_code[1100] = { // maxbit 15
0x00000002,0x000000E4,0x00000124,0x000001E4,
0x00000145,0x00000225,0x00000345,0x00000385,
0x00000226,0x00000626,0x000004A7,0x000005A7,
0x000005E7,0x00000DE7,0x00000EA7,0x00000828,
0x00000988,0x000009C8,0x00000B88,0x00000C08,
0x00000C48,0x00000CC8,0x00000D08,0x00000D28,
0x00000D68,0x000014C8,0x00001828,0x00001968,
0x00001988,0x000019C8,0x00001B48,0x00001D08,
0x00001DC8,0x000010E9,0x00001209,0x000013C9,
0x000013E9,0x00001749,0x00001949,0x00001B09,
0x00001B69,0x00001BE9,0x00002089,0x00002129,
0x00002189,0x00002869,0x000028A9,0x00002949,
0x00002AC9,0x00002B89,0x00003669,0x00003A69,
0x00003B49,0x0000206A,0x0000212A,0x0000216A,
0x0000244A,0x000024EA,0x0000268A,0x00002C2A,
0x00002C8A,0x00002ECA,0x0000308A,0x000031AA,
0x000031CA,0x000031EA,0x0000320A,0x0000326A,
0x000032CA,0x000033AA,0x000033CA,0x000033EA,
0x0000352A,0x0000364A,0x0000368A,0x0000374A,
0x0000376A,0x0000378A,0x0000402A,0x0000404A,
0x000040AA,0x000040EA,0x000041AA,0x0000420A,
0x0000422A,0x000042AA,0x0000436A,0x000043EA,
0x0000502A,0x000050AA,0x0000520A,0x0000538A,
0x000053AA,0x0000544A,0x000054EA,0x0000550A,
0x0000554A,0x0000560A,0x0000562A,0x0000568A,
0x0000578A,0x000057EA,0x0000640A,0x000064CA,
0x000064EA,0x0000652A,0x0000654A,0x000066CA,
0x00006C0A,0x00006C4A,0x00006C6A,0x00006E4A,
0x0000764A,0x0000778A,0x000077AA,0x0000406B,
0x000040AB,0x0000434B,0x0000492B,0x0000494B,
0x0000498B,0x000058EB,0x0000594B,0x000059CB,
0x00005DEB,0x000061AB,0x0000644B,0x000064AB,
0x0000670B,0x00006E6B,0x00006F4B,0x0000812B,
0x000082AB,0x000082CB,0x0000830B,0x0000850B,
0x000085AB,0x000085EB,0x0000868B,0x0000A10B,
0x0000A12B,0x0000A20B,0x0000A22B,0x0000A38B,
0x0000A3CB,0x0000A48B,0x0000A82B,0x0000A86B,
0x0000A8CB,0x0000A8EB,0x0000A9AB,0x0000AAEB,
0x0000ABEB,0x0000AD4B,0x0000AD8B,0x0000ADAB,
0x0000ADEB,0x0000AECB,0x0000AEEB,0x0000AF4B,
0x0000AF6B,0x0000AF8B,0x0000AFAB,0x0000C00B,
0x0000C02B,0x0000C06B,0x0000C28B,0x0000C2CB,
0x0000C2EB,0x0000C38B,0x0000C3EB,0x0000C84B,
0x0000C90B,0x0000C92B,0x0000C94B,0x0000C96B,
0x0000CAEB,0x0000CD0B,0x0000CD2B,0x0000CD6B,
0x0000CDCB,0x0000CFEB,0x0000D84B,0x0000D90B,
0x0000D96B,0x0000DBCB,0x0000DBEB,0x0000DC4B,
0x0000DC6B,0x0000DDEB,0x0000E90B,0x0000E96B,
0x0000EDCB,0x0000EDEB,0x0000EF8B,0x0000812C,
0x0000846C,0x0000850C,0x0000852C,0x0000854C,
0x0000856C,0x0000864C,0x0000866C,0x000092CC,
0x0000934C,0x00009AAC,0x00009B6C,0x0000B02C,
0x0000B04C,0x0000B16C,0x0000B18C,0x0000B1AC,
0x0000B30C,0x0000B32C,0x0000B34C,0x0000B3CC,
0x0000BBAC,0x0000C32C,0x0000C64C,0x0000C66C,
0x0000C90C,0x0000CE4C,0x0000D42C,0x0000D44C,
0x0000D46C,0x0000D5EC,0x0000DC4C,0x0000DC6C,
0x0000DC8C,0x0001000C,0x0001002C,0x0001004C,
0x0001006C,0x0001034C,0x0001036C,0x0001052C,
0x000105EC,0x0001064C,0x000107CC,0x000107EC,
0x00010A4C,0x00010A6C,0x00010B0C,0x00010D6C,
0x00010EEC,0x00010F0C,0x00010F2C,0x00010F4C,
0x00010F6C,0x0001400C,0x0001402C,0x000141AC,
0x000141CC,0x000141EC,0x0001448C,0x000146EC,
0x0001474C,0x0001476C,0x000147CC,0x000148CC,
0x000148EC,0x0001494C,0x0001496C,0x00014BEC,
0x00014F2C,0x00014F4C,0x00014F6C,0x0001500C,
0x0001502C,0x0001508C,0x000150AC,0x0001532C,
0x000154AC,0x000154CC,0x0001570C,0x0001574C,
0x0001576C,0x0001578C,0x000157AC,0x0001590C,
0x000159CC,0x000159EC,0x00015AEC,0x00015B8C,
0x00015D6C,0x0001808C,0x000184AC,0x000184CC,
0x000184EC,0x0001854C,0x0001856C,0x0001874C,
0x0001876C,0x0001878C,0x000187AC,0x0001940C,
0x000195AC,0x00019A8C,0x00019AAC,0x00019F8C,
0x00019FAC,0x0001B0CC,0x0001B24C,0x0001B26C,
0x0001B28C,0x0001B2AC,0x0001B60C,0x0001B70C,
0x0001B72C,0x0001B74C,0x0001B76C,0x0001B80C,
0x0001B84C,0x0001B86C,0x0001BB4C,0x0001BB6C,
0x0001BB8C,0x0001BBAC,0x0001D24C,0x0001D26C,
0x0001D28C,0x0001D2AC,0x0001D8EC,0x0001D98C,
0x0001D9CC,0x0001D9EC,0x0001DB0C,0x0001DB2C,
0x0001DB4C,0x0001DB6C,0x0001010D,0x0001012D,
0x0001014D,0x0001020D,0x0001022D,0x0001088D,
0x000108AD,0x00010C2D,0x00010C4D,0x00010C6D,
0x00010D8D,0x0001244D,0x0001246D,0x000125CD,
0x000125ED,0x000126CD,0x000126ED,0x0001362D,
0x0001364D,0x0001366D,0x0001368D,0x000136AD,
0x0001370D,0x0001372D,0x0001374D,0x0001376D,
0x0001378D,0x000137AD,0x000137CD,0x000137ED,
0x0001600D,0x000162AD,0x0001658D,0x000165AD,
0x000165CD,0x000165ED,0x000166CD,0x0001772D,
0x0001850D,0x0001854D,0x0001856D,0x0001858D,
0x000185AD,0x000185CD,0x000185ED,0x0001860D,
0x0001862D,0x0001870D,0x00018C0D,0x00018C2D,
0x00018C4D,0x00018C6D,0x000191AD,0x000191CD,
0x000191ED,0x0001924D,0x000197CD,0x000197ED,
0x00019CCD,0x00019CED,0x0001A80D,0x0001A82D,
0x0001AAED,0x0001AB0D,0x0001AB2D,0x0001AB4D,
0x0001AB6D,0x0001AB8D,0x0001ABAD,0x0001B30D,
0x0001B32D,0x0001B34D,0x0001B36D,0x0001B38D,
0x0001B3AD,0x0001B5AD,0x0001B5CD,0x0001B5ED,
0x0001B80D,0x0001B82D,0x0001B84D,0x0001B86D,
0x0001B94D,0x0001B96D,0x0001BD8D,0x0001BDAD,
0x0001BDCD,0x0001BDED,0x0002030D,0x0002044D,
0x0002046D,0x0002060D,0x0002062D,0x0002064D,
0x0002066D,0x00020A0D,0x00020A2D,0x00020B8D,
0x00020E8D,0x00020EAD,0x00020ECD,0x00020EED,
0x00020F0D,0x00020F2D,0x00020F4D,0x00020F6D,
0x0002164D,0x0002166D,0x0002170D,0x0002172D,
0x0002174D,0x0002176D,0x00021A8D,0x00021D4D,
0x00021D6D,0x00021D8D,0x00021DAD,0x0002808D,
0x000280AD,0x000280CD,0x000280ED,0x0002820D,
0x0002822D,0x0002824D,0x0002826D,0x0002828D,
0x000282AD,0x000282CD,0x000282ED,0x0002830D,
0x0002832D,0x00028CCD,0x00028CED,0x00028D0D,
0x00028D2D,0x00028D4D,0x00028D6D,0x00028D8D,
0x00028DAD,0x00028FCD,0x00028FED,0x0002910D,
0x0002912D,0x0002914D,0x0002916D,0x000296CD,
0x000296ED,0x0002970D,0x0002972D,0x0002974D,
0x0002976D,0x0002978D,0x000297AD,0x00029E0D,
0x00029E2D,0x00029F0D,0x00029F2D,0x00029F4D,
0x00029F6D,0x00029F8D,0x00029FAD,0x00029FCD,
0x00029FED,0x0002A54D,0x0002A56D,0x0002A58D,
0x0002A5AD,0x0002A5CD,0x0002A5ED,0x0002A60D,
0x0002A62D,0x0002A90D,0x0002A92D,0x0002A9CD,
0x0002A9ED,0x0002AB0D,0x0002AB2D,0x0002AB4D,
0x0002AB6D,0x0002AE4D,0x0002B34D,0x0002B36D,
0x0002B58D,0x0002B74D,0x0002B76D,0x0002BA0D,
0x0002BA2D,0x0002BA4D,0x0002BA6D,0x0002BA8D,
0x0002BAAD,0x000303AD,0x000303CD,0x000303ED,
0x0003080D,0x0003082D,0x0003084D,0x0003086D,
0x0003088D,0x000308AD,0x000308CD,0x000308ED,
0x0003090D,0x0003092D,0x00030C2D,0x00030C4D,
0x00030C6D,0x00030C8D,0x00030CAD,0x00030CCD,
0x00030CED,0x00030D0D,0x00030D2D,0x00030D4D,
0x00030D6D,0x00030D8D,0x00030DAD,0x00030DCD,
0x0003236D,0x0003238D,0x000323AD,0x000323CD,
0x000323ED,0x0003284D,0x0003286D,0x0003288D,
0x000328AD,0x000328CD,0x000328ED,0x00032B0D,
0x00032B2D,0x00033DAD,0x00033DCD,0x00033DED,
0x00033E0D,0x00033E2D,0x00033E4D,0x00033E6D,
0x00033E8D,0x00033EAD,0x00033ECD,0x00033EED,
0x000361CD,0x000361ED,0x00036C4D,0x00036C6D,
0x00036C8D,0x00036CAD,0x00036CCD,0x00036CED,
0x00036D0D,0x00036D2D,0x00036D4D,0x00036D6D,
0x00036D8D,0x00036DAD,0x00036DCD,0x00036DED,
0x0003704D,0x0003750D,0x0003752D,0x0003754D,
0x0003756D,0x0003758D,0x000375AD,0x000375CD,
0x000375ED,0x0003760D,0x0003762D,0x0003764D,
0x0003766D,0x0003B00D,0x0003B02D,0x0003B04D,
0x0003B06D,0x0003B08D,0x0003B0AD,0x0003B0CD,
0x0003B0ED,0x0003B10D,0x0003B12D,0x0003B14D,
0x0003B16D,0x0003B18D,0x0003B1AD,0x000200EE,
0x0002010E,0x0002012E,0x0002014E,0x0002016E,
0x0002018E,0x000201AE,0x000201CE,0x000201EE,
0x000202CE,0x0002100E,0x0002102E,0x0002104E,
0x0002106E,0x0002108E,0x000210AE,0x000210CE,
0x000210EE,0x0002180E,0x0002474E,0x0002476E,
0x0002478E,0x000247AE,0x000247CE,0x000247EE,
0x0002480E,0x0002482E,0x0002484E,0x0002486E,
0x00026A0E,0x00026A4E,0x00026A6E,0x00026B0E,
0x00026B2E,0x00026B4E,0x00026B6E,0x00026B8E,
0x00026BAE,0x00026BCE,0x00026BEE,0x00026C0E,
0x00026C2E,0x0002C04E,0x0002C06E,0x0002C18E,
0x0002C1AE,0x0002C1CE,0x0002C1EE,0x0002C40E,
0x0002C42E,0x0002C44E,0x0002C46E,0x0002C48E,
0x0002C4AE,0x0002C4CE,0x0002C4EE,0x0002C50E,
0x0002C52E,0x0002CDCE,0x0002CDEE,0x0002CF8E,
0x0002CFAE,0x0002CFCE,0x0002CFEE,0x0002EE0E,
0x0002EE2E,0x00030A4E,0x00030A6E,0x00030E4E,
0x00030E6E,0x00030E8E,0x00030EAE,0x00030ECE,
0x00030EEE,0x00030F0E,0x00030F2E,0x00030F4E,
0x00030F6E,0x00030F8E,0x00030FAE,0x00030FCE,
0x00030FEE,0x0003230E,0x0003232E,0x000324CE,
0x000324EE,0x00032E0E,0x00032E2E,0x00032E4E,
0x00032E6E,0x00032E8E,0x00032EAE,0x00032ECE,
0x00032EEE,0x00032F0E,0x00032F2E,0x00032F4E,
0x00032F6E,0x0003540E,0x0003542E,0x0003544E,
0x0003546E,0x0003548E,0x000354AE,0x000354CE,
0x000354EE,0x0003550E,0x0003552E,0x0003554E,
0x0003556E,0x0003558E,0x000355AE,0x0003678E,
0x000367AE,0x000367CE,0x000367EE,0x00036A0E,
0x00036A2E,0x00036A4E,0x00036A6E,0x00036A8E,
0x00036AAE,0x00036ACE,0x00036AEE,0x00036B0E,
0x00036B2E,0x0004064E,0x0004066E,0x0004068E,
0x000406AE,0x000406CE,0x000406EE,0x0004070E,
0x0004072E,0x0004074E,0x0004076E,0x0004078E,
0x000407AE,0x000407CE,0x000407EE,0x0004080E,
0x0004082E,0x0004084E,0x0004086E,0x0004174E,
0x0004176E,0x0004198E,0x000419AE,0x000419CE,
0x000419EE,0x00041C0E,0x00041C2E,0x00041C4E,
0x00041C6E,0x00041C8E,0x00041CAE,0x00041CCE,
0x00041CEE,0x0004354E,0x0004356E,0x0004380E,
0x0004382E,0x0004384E,0x0004386E,0x0004388E,
0x000438AE,0x000438CE,0x000438EE,0x0004390E,
0x0004392E,0x0004394E,0x0004396E,0x0004398E,
0x000439AE,0x000439CE,0x000439EE,0x00043A0E,
0x00043A2E,0x00043A4E,0x00043A6E,0x0005128E,
0x000512AE,0x000512CE,0x000512EE,0x0005130E,
0x0005132E,0x0005134E,0x0005136E,0x0005138E,
0x000513AE,0x000513CE,0x000513EE,0x0005180E,
0x0005182E,0x0005184E,0x0005186E,0x0005188E,
0x000518AE,0x000518CE,0x000518EE,0x0005190E,
0x0005192E,0x0005194E,0x0005196E,0x0005260E,
0x0005262E,0x0005264E,0x0005266E,0x0005268E,
0x000526AE,0x000526CE,0x000526EE,0x0005270E,
0x0005272E,0x0005274E,0x0005276E,0x0005278E,
0x000527AE,0x000527CE,0x000527EE,0x00052C0E,
0x00052C2E,0x00052C4E,0x00052C6E,0x00052C8E,
0x00052CAE,0x00052CCE,0x00052CEE,0x00052D0E,
0x00052D2E,0x00052D4E,0x00052D6E,0x0005480E,
0x0005482E,0x0005484E,0x0005486E,0x0005488E,
0x000548AE,0x000548CE,0x000548EE,0x0005490E,
0x0005492E,0x0005494E,0x0005496E,0x0005498E,
0x000549AE,0x000549CE,0x000549EE,0x00054A0E,
0x00054A2E,0x00054A4E,0x00054A6E,0x00055CCE,
0x00055CEE,0x0005648E,0x000564AE,0x000564CE,
0x000564EE,0x0005650E,0x0005652E,0x0005654E,
0x0005656E,0x0005658E,0x000565AE,0x000565CE,
0x000565EE,0x0005660E,0x0005662E,0x0005664E,
0x0005666E,0x00056B4E,0x00056B6E,0x0006028E,
0x000602AE,0x000602CE,0x000602EE,0x0006040E,
0x0006042E,0x0006044E,0x0006046E,0x0006048E,
0x000604AE,0x000604CE,0x000604EE,0x0006050E,
0x0006052E,0x0006054E,0x0006056E,0x0006058E,
0x000605AE,0x000605CE,0x000605EE,0x0006060E,
0x0006062E,0x0006064E,0x0006066E,0x0006068E,
0x000606AE,0x000606CE,0x000606EE,0x0006070E,
0x0006072E,0x0006180E,0x0006182E,0x00061BCE,
0x00061BEE,0x0006430E,0x0006432E,0x0006434E,
0x0006436E,0x0006438E,0x000643AE,0x000643CE,
0x000643EE,0x0006440E,0x0006442E,0x0006444E,
0x0006446E,0x0006448E,0x000644AE,0x000644CE,
0x000644EE,0x0006450E,0x0006452E,0x0006454E,
0x0006456E,0x0006458E,0x000645AE,0x000645CE,
0x000645EE,0x0006460E,0x0006462E,0x0006464E,
0x0006466E,0x0006468E,0x000646AE,0x00066F0E,
0x00066F2E,0x00066F4E,0x00066F6E,0x00066F8E,
0x00066FAE,0x00066FCE,0x00066FEE,0x0006780E,
0x0006782E,0x0006784E,0x0006786E,0x0006788E,
0x000678AE,0x000678CE,0x000678EE,0x0006790E,
0x0006792E,0x0006794E,0x0006796E,0x0006798E,
0x000679AE,0x000679CE,0x000679EE,0x00067A0E,
0x00067A2E,0x00067A4E,0x00067A6E,0x00067A8E,
0x00067AAE,0x00067ACE,0x00067AEE,0x00067B0E,
0x00067B2E,0x0006E0CE,0x0006E0EE,0x0006E60E,
0x0006E62E,0x0006E64E,0x0006E66E,0x0006E68E,
0x0006E6AE,0x0006E6CE,0x0006E6EE,0x0006E70E,
0x0006E72E,0x0006E74E,0x0006E76E,0x0006E78E,
0x0006E7AE,0x0006E7CE,0x0006E7EE,0x0006E80E,
0x0006E82E,0x0006E84E,0x0006E86E,0x0006E88E,
0x0006E8AE,0x0006E8CE,0x0006E8EE,0x0006E90E,
0x0006E92E,0x0006E94E,0x0006E96E,0x0006E98E,
0x0006E9AE,0x0006E9CE,0x0006E9EE,0x0007668E,
0x000766AE,0x000766CE,0x000766EE,0x00077D0E,
0x00077D2E,0x00077D4E,0x00077D6E,0x00077D8E,
0x00077DAE,0x00077DCE,0x00077DEE,0x00077E0E,
0x00077E2E,0x00077E4E,0x00077E6E,0x00077E8E,
0x00077EAE,0x00077ECE,0x00077EEE,0x00077F0E,
0x00077F2E,0x00077F4E,0x00077F6E,0x00077F8E,
0x00077FAE,0x00077FCE,0x00077FEE,0x0004000F,
0x0004002F,0x0004004F,0x0004006F,0x0004008F,
0x000400AF,0x000400CF,0x000400EF,0x0004010F,
0x0004012F,0x0004014F,0x0004016F,0x0004018F,
0x000401AF,0x000405CF,0x000405EF,0x0004304F,
0x0004306F,0x0004368F,0x000436AF,0x000436CF,
0x000436EF,0x0004370F,0x0004372F,0x0004374F,
0x0004376F,0x0004378F,0x000437AF,0x000437CF,
0x000437EF,0x00048C0F,0x00048C2F,0x00048C4F,
0x00048C6F,0x00048C8F,0x00048CAF,0x00048CCF,
0x00048CEF,0x00048D0F,0x00048D2F,0x00048D4F,
0x00048D6F,0x00048D8F,0x00048DAF,0x00048DCF,
0x00048DEF,0x00048E0F,0x00048E2F,0x00048E4F,
0x00048E6F,0x0004D44F,0x0004D46F,0x00000164};
_CONST uint16_t mv1_data[1100] = {
0x0820,0x081f,0x07e0,0x07df,0x0821,0x0860,0x07e1,0x0861,
0x085f,0x0822,0x081e,0x07a0,0x08a0,0x07e2,0x0823,0x0760,
0x0862,0x07a1,0x081d,0x085e,0x07de,0x08e0,0x089f,0x079f,
0x08a1,0x07e3,0x0863,0x0761,0x075f,0x07dd,0x085d,0x08e1,
0x07a2,0x079e,0x08df,0x081c,0x0824,0x089e,0x08a2,0x0720,
0x0660,0x0825,0x0920,0x06e0,0x0819,0x081b,0x0827,0x0960,
0x09e0,0x00e0,0x0826,0x07a3,0x07e4,0x06a0,0x07e5,0x083d,
0x081a,0x09a0,0x0762,0x0763,0x0803,0x08a3,0x07db,0x07dc,
0x089d,0x08e2,0x085c,0x0865,0x071f,0x0864,0x0060,0x085b,
0x06df,0x075e,0x079d,0x07e7,0x0721,0x075d,0x0961,0x08e3,
0x07d9,0x0859,0x08dd,0x06e1,0x091f,0x095f,0x065f,0x0661,
0x0f60,0x08de,0x0120,0x0160,0x0829,0x0867,0x0921,0x07a4,
0x05e0,0x079c,0x0722,0x08a4,0x07e6,0x0818,0x083c,0x09df,
0x0817,0x089c,0x0560,0x09e1,0x083b,0x0ee0,0x0828,0x071e,
0x0805,0x0922,0x0f20,0x0866,0x0620,0x091e,0x082b,0x0804,
0x0a60,0x00a0,0x082a,0x099f,0x069f,0x05a0,0x085a,0x07a6,
0x07da,0x0816,0x0815,0x07a5,0x07fd,0x083f,0x0765,0x00df,
0x0a20,0x09a1,0x0802,0x0801,0x0857,0x06a1,0x07e9,0x089b,
0x0723,0x099e,0x08a6,0x07d7,0x00e1,0x07c3,0x08dc,0x09a2,
0x06e2,0x08db,0x0869,0x071d,0x0767,0x06e3,0x0764,0x06dd,
0x0ae0,0x075b,0x095e,0x0fe0,0x07d8,0x087d,0x08a5,0x079a,
0x07fb,0x0799,0x0963,0x079b,0x08e4,0x08e5,0x069e,0x0a5f,
0x0962,0x07e8,0x0843,0x071c,0x06a2,0x07a7,0x0aa0,0x061f,
0x01e0,0x06de,0x0858,0x075c,0x0923,0x0724,0x089a,0x0e60,
0x05df,0x0a61,0x091d,0x05e1,0x08e7,0x0899,0x065e,0x0798,
0x0663,0x087b,0x065d,0x0662,0x0759,0x061e,0x0855,0x09e3,
0x086b,0x0868,0x0020,0x095d,0x07c5,0x091c,0x055f,0x083e,
0x0f61,0x0621,0x08d9,0x0f5f,0x07d5,0x015f,0x07eb,0x0edf,
0x09e2,0x0561,0x0814,0x07a8,0x08a7,0x059f,0x0a1f,0x0839,
0x0766,0x0420,0x07ea,0x0161,0x0fa0,0x009f,0x0520,0x09dd,
0x09de,0x082c,0x0845,0x005f,0x07d6,0x0622,0x0924,0x0811,
0x0926,0x083a,0x0726,0x06a3,0x01a0,0x07fc,0x09a3,0x0898,
0x0ea0,0x08e6,0x0810,0x086d,0x086a,0x0460,0x0adf,0x069d,
0x07c4,0x0a1e,0x07d1,0x08a8,0x082e,0x0830,0x07ff,0x04e0,
0x07aa,0x0813,0x0769,0x0856,0x099c,0x09a4,0x082d,0x0ee1,
0x0a21,0x04a0,0x099d,0x0807,0x08e9,0x08aa,0x0812,0x0461,
0x0061,0x03e0,0x0796,0x0725,0x07c1,0x071a,0x0896,0x0757,
0x0831,0x06dc,0x08da,0x06db,0x0c60,0x05a1,0x095b,0x0897,
0x095c,0x06a4,0x080f,0x0806,0x05a2,0x071b,0x0b5f,0x075a,
0x0797,0x07c2,0x0ae1,0x0ba0,0x0a62,0x07a9,0x069c,0x0360,
0x08a9,0x0800,0x06e4,0x09a6,0x0aa2,0x0a9f,0x086f,0x0be0,
0x0851,0x0f1f,0x06e7,0x0aa1,0x0665,0x0833,0x059e,0x082f,
0x0c20,0x0832,0x0b60,0x0853,0x087f,0x0a5e,0x06d9,0x065b,
0x04e1,0x07fe,0x08d8,0x04df,0x091b,0x0a9e,0x06e5,0x045f,
0x07ed,0x0b20,0x0727,0x0854,0x086e,0x07ef,0x05e3,0x07d3,
0x0a22,0x0841,0x07f1,0x0895,0x0795,0x080e,0x0873,0x091a,
0x08d7,0x0bdf,0x0964,0x0a63,0x07fa,0x05dd,0x0a5d,0x0755,
0x0794,0x08ea,0x080d,0x065c,0x080c,0x0728,0x0e9f,0x00a1,
0x0967,0x087c,0x03a0,0x086c,0x0c61,0x051f,0x09dc,0x0925,
0x055d,0x0260,0x05de,0x0871,0x08eb,0x061c,0x09e7,0x0959,
0x02e0,0x0870,0x0782,0x07cf,0x07d4,0x0719,0x0cdf,0x0a1c,
0x08d5,0x0758,0x0659,0x084f,0x0b9f,0x08d1,0x0965,0x07ab,
0x0792,0x0220,0x0fe1,0x0718,0x03e1,0x0a24,0x084d,0x0b61,
0x0c5f,0x0667,0x080b,0x011f,0x0be1,0x0ce0,0x0927,0x09e5,
0x0d60,0x02a0,0x061d,0x0751,0x07ac,0x07ee,0x0664,0x0a23,
0x099a,0x09a5,0x087a,0x0e20,0x05e2,0x06e6,0x0808,0x0966,
0x06a6,0x0756,0x0add,0x0919,0x0850,0x0623,0x0de0,0x0ae3,
0x0261,0x076b,0x0892,0x08ae,0x0626,0x0872,0x04a1,0x0852,
0x0875,0x07bc,0x07cd,0x0ca0,0x0624,0x0f21,0x07b3,0x09e4,
0x08ab,0x07ad,0x09db,0x072a,0x059d,0x0998,0x009e,0x0699,
0x0fdf,0x0834,0x0e5f,0x0563,0x09e6,0x0849,0x0716,0x04a2,
0x0784,0x0891,0x059c,0x0877,0x076a,0x0a59,0x0791,0x0894,
0x08ef,0x0562,0x0361,0x0890,0x08e8,0x09d9,0x0790,0x0b9e,
0x0835,0x0a9d,0x080a,0x07cb,0x084e,0x069a,0x02e1,0x0844,
0x05a3,0x07ec,0x065a,0x07d0,0x0d5f,0x06da,0x0ae2,0x0666,
0x0a1d,0x0c9f,0x055e,0x0918,0x0996,0x07bd,0x0320,0x07c9,
0x08ad,0x0522,0x03df,0x0753,0x0809,0x0f9f,0x07ae,0x035f,
0x0463,0x0836,0x04dd,0x07f9,0x051e,0x07f2,0x0783,0x01df,
0x007f,0x0462,0x08af,0x0969,0x07f3,0x07d2,0x0b1f,0x088e,
0x06a5,0x0a26,0x041f,0x0958,0x0d20,0x0c1f,0x07b2,0x0521,
0x049f,0x0876,0x099b,0x0749,0x01e1,0x0657,0x0793,0x0da0,
0x0b5d,0x0bdd,0x0ba1,0x0a5c,0x076f,0x0771,0x041e,0x07af,
0x03a1,0x069b,0x0999,0x08b6,0x08ac,0x076d,0x08b2,0x07ba,
0x0773,0x07b0,0x0e61,0x07bb,0x0121,0x0ba2,0x0879,0x074d,
0x09da,0x0b21,0x078d,0x07f0,0x0c9e,0x084b,0x07c7,0x0838,
0x04e2,0x0837,0x0a1a,0x07c0,0x095a,0x0be3,0x0041,0x08f3,
0x0421,0x07f5,0x001f,0x08ed,0x084c,0x005d,0x045d,0x08b3,
0x025f,0x08b0,0x0842,0x07c6,0x0c62,0x0ade,0x0a9c,0x0ce1,
0x08bc,0x0768,0x05db,0x076e,0x039f,0x0789,0x0b63,0x0c5d,
0x02df,0x0627,0x07f7,0x072e,0x08d3,0x0a65,0x07be,0x0b22,
0x049e,0x0750,0x0893,0x08f1,0x0929,0x0669,0x06a7,0x0565,
0x07ce,0x0785,0x088d,0x04e3,0x08b7,0x0b1e,0x0928,0x09a8,
0x066a,0x07c8,0x0714,0x05d9,0x096d,0x00e3,0x0de1,0x0a64,
0x07b6,0x05a6,0x0a5b,0x0625,0x087e,0x06a8,0x08cf,0x08fb,
0x07b1,0x0ddf,0x0cdd,0x0be2,0x0c22,0x09a7,0x0618,0x03dd,
0x0559,0x0c9d,0x0655,0x0b9d,0x078a,0x077d,0x02a1,0x08b1,
0x0aa3,0x0b62,0x0743,0x0aa6,0x05a7,0x00dd,0x0847,0x06e9,
0x0881,0x0063,0x0884,0x0717,0x088f,0x0917,0x08cb,0x05e5,
0x05dc,0x0363,0x0e9e,0x00de,0x0698,0x0fc1,0x066b,0x07f8,
0x0888,0x0f62,0x09aa,0x09d8,0x066d,0x0f5e,0x0754,0x0957,
0x0788,0x0a66,0x0696,0x0c21,0x0711,0x0874,0x0ca2,0x08d6,
0x07b5,0x096b,0x076c,0x0741,0x0a1b,0x019f,0x09e9,0x072b,
0x0729,0x04de,0x021f,0x05a4,0x0b5e,0x0885,0x08f7,0x029f,
0x0ea1,0x045e,0x0968,0x09d7,0x078f,0x049d,0x0da2,0x03a2,
0x077b,0x0422,0x0ede,0x078b,0x08cd,0x05e6,0x08c5,0x0780,
0x0bde,0x092a,0x0745,0x0dde,0x051d,0x0322,0x07ca,0x08ec,
0x039e,0x077f,0x04a3,0x088c,0x0883,0x061a,0x074f,0x0691,
0x0599,0x00a2,0x06eb,0x05e7,0x0222,0x07b8,0x0ddd,0x0997,
0x0f1e,0x07cc,0x011e,0x088a,0x0c63,0x0889,0x06d8,0x08ba,
0x084a,0x078c,0x07f6,0x0da1,0x0aa5,0x08d4,0x09a9,0x0ba3,
0x0b1d,0x0692,0x06fd,0x025e,0x09e8,0x0658,0x0567,0x0775,
0x073e,0x0a9a,0x035d,0x0021,0x0162,0x08b5,0x0971,0x0715,
0x061b,0x074b,0x0fff,0x0694,0x059a,0x06d7,0x0747,0x064d,
0x0846,0x066f,0x0f5d,0x001e,0x08c9,0x0673,0x0916,0x03e2,
0x06d5,0x0a19,0x0d61,0x0878,0x00f9,0x029e,0x0426,0x0973,
0x09b3,0x04a6,0x07bf,0x0b9c,0x06e8,0x0263,0x01a1,0x0752,
0x0fa1,0x0221,0x0a98,0x073a,0x077a,0x00e2,0x0671,0x041d,
0x06ab,0x0744,0x08c1,0x0704,0x06ea,0x0ce3,0x0f63,0x0c1e,
0x0951,0x0245,0x08b8,0x01fd,0x0c59,0x0b65,0x0524,0x0777,
0x055c,0x0163,0x015d,0x0772,0x0730,0x08b4,0x0742,0x062a,
0x02a2,0x0628,0x08ee,0x092e,0x09ab,0x0de3,0x02dd,0x0930,
0x0994,0x0d5d,0x0d9f,0x06a9,0x0787,0x0c5e,0x0523,0x06d3,
0x078e,0x09d5,0x0848,0x0a67,0x0c67,0x05a8,0x09ae,0x09b7,
0x0122,0x0786,0x021e,0x0262,0x00e5,0x0619,0x05a5,0x0ca1,
0x0956,0x092c,0x07f4,0x06d1,0x00a3,0x025d,0x0aa4,0x0fe3,
0x0668,0x04e5,0x0b1c,0x005e,0x0732,0x070e,0x0c1c,0x07b7,
0x0886,0x0a57,0x0a53,0x098e,0x031e,0x06c3,0x03de,0x001c,
0x041c,0x08bd,0x08fd,0x09af,0x072d,0x0770,0x0a28,0x0aa8,
0x0ce2,0x0d22,0x0b59,0x0d9e,0x0edd,0x0ee3,0x0a84,0x0b1a,
0x0975,0x06b2,0x0b9a,0x0629,0x03db,0x09fb,0x059b,0x0ba6,
0x04e7,0x08c3,0x09b2,0x046b,0x096f,0x05d7,0x0d21,0x0df7,
0x0ca3,0x0955,0x0697,0x02e3,0x097d,0x0321,0x062e,0x07b4,
0x0423,0x0362,0x0598,0x035e,0x092b,0x08d0,0x0a25,0x0a55,
0x0882,0x0a58,0x06ad,0x0d62,0x0cde,0x0177,0x0577,0x0781,
0x009d,0x0fdd,0x0a5a,0x051c,0x0059,0x0e1f,0x0564,0x0616,
0x0651,0x015e,0x0734,0x08c2,0x06ac,0x072c,0x07b9,0x049a,
0x077e,0x05e9,0x0a27,0x08b9,0x051a,0x0aae,0x09f1,0x088b,
0x0710,0x0f53,0x0985,0x06fb,0x0fa6,0x0267,0x093a,0x0466,
0x0259,0x0c71,0x0632,0x0656,0x0d9c,0x08bb,0x09c9,0x097b,
0x00c7,0x005c,0x0677,0x0991,0x0984,0x0b23,0x08f2,0x0915,
0x031d,0x0f2c,0x092f,0x0992,0x0a18,0x0653,0x0ad9,0x09ea,
0x0d63,0x0703,0x09f3,0x0e63,0x0b90,0x02a3,0x0d1e,0x06ff,
0x08f9,0x0aa7,0x0b67,0x0ed9,0x03e3,0x0f26,0x0989,0x0610,
0x05e4,0x09ed,0x031f,0x077c,0x060e,0x0022,0x052a,0x0418,
0x0700,0x0ae5,0x08d2,0x073d,0x0079,0x0c65,0x011c,0x0575,
0x0a94,0x09ee,0x074e,0x00ef,0x0b26,0x0566,0x0d66,0x0dc9,
0x02e2,0x0167,0x00eb,0x09d1,0x0d67,0x073b,0x0645,0x04db,
0x0880,0x070c,0x055b,0x0ff0};

_CONST uint16_t rl0_code[133] = { // maxbit 13
0x0001,0x0006,0x000f,0x0016,0x0020,0x0018,0x0008,0x009a,
0x0056,0x013e,0x00f0,0x03a5,0x0077,0x01ef,0x009a,0x005d,
0x0001,0x0011,0x0002,0x000b,0x0012,0x01d6,0x027e,0x0191,
0x00ea,0x03dc,0x013b,0x0004,0x0014,0x009e,0x0009,0x01ac,
0x01e2,0x03ca,0x005f,0x0017,0x004e,0x005e,0x00f3,0x01ad,
0x00ec,0x05f0,0x000e,0x00e1,0x03a4,0x009c,0x013d,0x003b,
0x001c,0x0014,0x09be,0x0006,0x007a,0x0190,0x0137,0x001b,
0x0008,0x075c,0x0071,0x00d7,0x09bf,0x0007,0x00af,0x04cc,
0x0034,0x0265,0x009f,0x00e0,0x0016,0x0327,0x0015,0x017d,
0x0ebb,0x0014,0x00f6,0x01e4,0x00cb,0x099d,0x00ca,0x02fc,
0x017f,0x04cd,0x02fd,0x04fe,0x013a,0x000a,0x0042,0x01d3,
0x04dd,0x0012,0x00e8,0x004c,0x0136,0x0039,0x0264,0x0eba,
0x0000,0x00ae,0x099c,0x001f,0x04de,0x0043,0x04dc,0x0003,
0x03cb,0x0006,0x099e,0x002a,0x05f1,0x000f,0x09fe,0x0033,
0x09ff,0x0098,0x099f,0x00ea,0x013c,0x002e,0x0192,0x0136,
0x006a,0x0015,0x03af,0x01e3,0x0074,0x00eb,0x02f9,0x005c,
0x00ed,0x03dd,0x0326,0x005e,0x0016};
_CONST uint16_t rl0_data[133] = {
0x2001,0x3002,0x4003,0x5004,0x6005,0x7006,0x8007,0x8008,
0x9009,0x900a,0xa00b,0xa00c,0xb00d,0xb00e,0xc00f,0xd010,
0x4021,0x5022,0x7023,0x8024,0x9025,0x9026,0xa027,0xb028,
0xc029,0xc02a,0xd02b,0x5041,0x7042,0x8043,0xa044,0xb045,
0xb046,0xc047,0xd048,0x5061,0x7062,0x9063,0xa064,0xb065,
0xc066,0xd067,0x6081,0x8082,0xa083,0xc084,0xd085,0x60a1,
0x90a2,0xb0a3,0xc0a4,0x70c1,0x90c2,0xb0c3,0xd0c4,0x70e1,
0xa0e2,0xb0e3,0x7101,0xa102,0xc103,0x8121,0xa122,0xb123,
0x8141,0xa142,0xc143,0x8161,0xb162,0xc163,0x9181,0xb182,
0xc183,0x91a1,0xa1a2,0xb1a3,0xa1c1,0xc1c2,0xa1e1,0xc1e2,
0xb201,0xb221,0xc241,0xb261,0xd281,0x4801,0x7802,0x9803,
0xb804,0x5821,0x8822,0xb823,0xd824,0x6841,0xa842,0xc843,
0x7861,0xa862,0xc863,0x7881,0xb882,0x78a1,0xb8a2,0x88c1,
0xc8c2,0x88e1,0xc8e2,0x8901,0xd902,0x8921,0xc922,0x8941,
0xc942,0x8961,0xc962,0x8981,0xd982,0x89a1,0xb9a2,0x99c1,
0x99e1,0xba01,0xaa21,0xba41,0xba61,0xca81,0xcaa1,0xdac1,
0xcae1,0xcb01,0xcb21,0xdb41,0x7ff0};

_CONST uint16_t rl1_code[186] = { // maxbit 15
0x0001,0x0005,0x000d,0x0012,0x000e,0x0015,0x0013,0x003f,
0x004b,0x011f,0x00b8,0x03e3,0x0172,0x024d,0x03da,0x02dd,
0x1f55,0x05b9,0x3eae,0x0000,0x0010,0x0008,0x0020,0x0029,
0x01f4,0x0233,0x01e0,0x012a,0x03dd,0x050a,0x1f29,0x0a42,
0x1272,0x1737,0x0003,0x0011,0x00c4,0x004b,0x00b4,0x07d4,
0x0345,0x02d7,0x07bf,0x0938,0x0bbb,0x095e,0x0013,0x0078,
0x0069,0x0232,0x0461,0x03ec,0x0520,0x1f2a,0x3e50,0x3e51,
0x1486,0x000c,0x0024,0x0094,0x08c0,0x0f09,0x1ef0,0x003d,
0x0053,0x01a0,0x02d6,0x0f08,0x0013,0x007c,0x07c1,0x04ac,
0x001b,0x00a0,0x0344,0x0f79,0x0079,0x03e1,0x02d4,0x2306,
0x0021,0x023c,0x0fae,0x23de,0x0035,0x0175,0x07b3,0x00c5,
0x0174,0x0785,0x0048,0x01a3,0x049e,0x002c,0x00fa,0x07d6,
0x0092,0x05cc,0x1ef1,0x00a3,0x03ed,0x093e,0x01e2,0x1273,
0x07c4,0x1487,0x0291,0x0293,0x0f8a,0x0509,0x0508,0x078d,
0x07be,0x078c,0x04ae,0x0bba,0x2307,0x0b9a,0x1736,0x000e,
0x0045,0x01f3,0x047a,0x05dc,0x23df,0x0019,0x0028,0x0176,
0x049d,0x23dd,0x0030,0x00a2,0x02ef,0x05b8,0x003f,0x00a5,
0x03db,0x093f,0x0044,0x07cb,0x095f,0x0063,0x03c3,0x0015,
0x08f6,0x0017,0x0498,0x002c,0x07b2,0x002f,0x1f54,0x008d,
0x07bd,0x008e,0x1182,0x00fb,0x050b,0x002d,0x07c0,0x0079,
0x1f5f,0x007a,0x1f56,0x0231,0x03e4,0x01a1,0x0143,0x01f7,
0x016f,0x0292,0x02e7,0x016c,0x016d,0x03dc,0x0f8b,0x0499,
0x03d8,0x078e,0x02d5,0x1f5e,0x1f2b,0x078f,0x04ad,0x3eaf,
0x23dc,0x004a};
_CONST uint16_t rl1_data[186] = {
0x2001,0x3002,0x4003,0x5004,0x6005,0x7006,0x8007,0x8008,
0x9009,0x900a,0xa00b,0xa00c,0xb00d,0xc00e,0xc00f,0xd010,
0xd011,0xe012,0xe013,0x4021,0x5022,0x7023,0x8024,0x9025,
0x9026,0xa027,0xb028,0xc029,0xc02a,0xd02b,0xd02c,0xe02d,
0xf02e,0xf02f,0x5041,0x7042,0x8043,0xa044,0xb045,0xb046,
0xc047,0xd048,0xd049,0xe04a,0xe04b,0xf04c,0x5061,0x7062,
0x9063,0xa064,0xb065,0xc066,0xd067,0xd068,0xe069,0xe06a,
0xf06b,0x6081,0x9082,0xb083,0xc084,0xe085,0xf086,0x60a1,
0x90a2,0xb0a3,0xd0a4,0xe0a5,0x70c1,0x90c2,0xb0c3,0xe0c4,
0x70e1,0xa0e2,0xc0e3,0xe0e4,0x7101,0xa102,0xd103,0xe104,
0x8121,0xa122,0xc123,0xe124,0x8141,0xb142,0xd143,0x8161,
0xb162,0xd163,0x9181,0xb182,0xd183,0x91a1,0xa1a2,0xb1a3,
0xa1c1,0xd1c2,0xf1c3,0xa1e1,0xc1e2,0xe1e3,0xb201,0xf202,
0xb221,0xf222,0xc241,0xc261,0xc281,0xd2a1,0xd2c1,0xd2e1,
0xd301,0xd321,0xe341,0xe361,0xe381,0xe3a1,0xf3c1,0x4801,
0x7802,0x9803,0xb804,0xd805,0xe806,0x5821,0x9822,0xb823,
0xd824,0xe825,0x6841,0xa842,0xc843,0xe844,0x6861,0xa862,
0xc863,0xe864,0x7881,0xb882,0xf883,0x78a1,0xc8a2,0x88c1,
0xc8c2,0x88e1,0xd8e2,0x8901,0xd902,0x8921,0xd922,0x8941,
0xd942,0x8961,0xd962,0x8981,0xd982,0x89a1,0xb9a2,0x99c1,
0xd9c2,0x99e1,0xd9e2,0xaa01,0xaa21,0xba41,0xba61,0xba81,
0xcaa1,0xcac1,0xcae1,0xcb01,0xcb21,0xcb41,0xcb61,0xdb81,
0xcba1,0xdbc1,0xdbe1,0xdc01,0xdc21,0xdc41,0xec61,0xec81,
0xeca1,0x9ff0};

_CONST uint16_t rl2_code[103] = { // maxbit 12
0x0002,0x0006,0x000f,0x000d,0x000c,0x0015,0x0013,0x0012,
0x0017,0x001f,0x001e,0x001d,0x0025,0x0024,0x0023,0x0021,
0x0021,0x0020,0x000f,0x000e,0x0007,0x0006,0x0020,0x0021,
0x0050,0x0051,0x0052,0x000e,0x0014,0x0016,0x001c,0x0020,
0x001f,0x000d,0x0022,0x0053,0x0055,0x000b,0x0015,0x001e,
0x000c,0x0056,0x0011,0x001b,0x001d,0x000b,0x0010,0x0022,
0x000a,0x000d,0x001c,0x0008,0x0012,0x001b,0x0054,0x0014,
0x001a,0x0057,0x0019,0x0009,0x0018,0x0023,0x0017,0x0019,
0x0018,0x0007,0x0058,0x0007,0x000c,0x0016,0x0017,0x0006,
0x0005,0x0004,0x0059,0x000f,0x0016,0x0005,0x000e,0x0004,
0x0011,0x0024,0x0010,0x0025,0x0013,0x005a,0x0015,0x005b,
0x0014,0x0013,0x001a,0x0015,0x0014,0x0013,0x0012,0x0011,
0x0026,0x0027,0x005c,0x005d,0x005e,0x005f,0x0003};
_CONST uint16_t rl2_data[103] = {
0x2001,0x3002,0x4003,0x5004,0x5005,0x6006,0x6007,0x6008,
0x7009,0x800a,0x800b,0x800c,0x900d,0x900e,0x900f,0x9010,
0xa011,0xa012,0xa013,0xa014,0xb015,0xb016,0xb017,0xb018,
0xc019,0xc01a,0xc01b,0x4021,0x6022,0x7023,0x8024,0x9025,
0x9026,0xa027,0xb028,0xc029,0xc02a,0x5041,0x7042,0x9043,
0xa044,0xc045,0x6061,0x8062,0x9063,0xa064,0x6081,0x9082,
0xa083,0x60a1,0x90a2,0xa0a3,0x70c1,0x90c2,0xc0c3,0x70e1,
0x90e2,0xc0e3,0x8101,0xa102,0x8121,0xb122,0x8141,0x9161,
0x9181,0xa1a1,0xc1c1,0x4801,0x6802,0x8803,0x9804,0xa805,
0xb806,0xb807,0xc808,0x6821,0x9822,0xa823,0x6841,0xa842,
0x7861,0xb862,0x7881,0xb882,0x78a1,0xc8a2,0x88c1,0xc8c2,
0x88e1,0x8901,0x8921,0x9941,0x9961,0x9981,0x99a1,0x99c1,
0xb9e1,0xba01,0xca21,0xca41,0xca61,0xca81,0x7ff0};

_CONST uint16_t rl3_code[149] = { // maxbit 15
0x0004,0x0014,0x0017,0x007f,0x0154,0x01f2,0x00bf,0x0065,
0x0aaa,0x0630,0x1597,0x03b7,0x2b22,0x0be6,0x000b,0x0037,
0x0062,0x0007,0x0166,0x00ce,0x1590,0x05f6,0x0be7,0x0007,
0x006d,0x0003,0x031f,0x05f2,0x0002,0x0061,0x0055,0x01df,
0x001a,0x001e,0x0ac9,0x2b23,0x001e,0x001f,0x0ac3,0x2b2b,
0x0006,0x0004,0x02f8,0x0019,0x0006,0x063d,0x0057,0x0182,
0x2aa2,0x0004,0x0180,0x059c,0x007d,0x0164,0x076d,0x0002,
0x018d,0x1581,0x00ad,0x0060,0x0c67,0x001c,0x00ee,0x0003,
0x02cf,0x00d9,0x1580,0x0002,0x0183,0x0057,0x0061,0x0031,
0x0066,0x0631,0x0632,0x00ac,0x031d,0x0076,0x003a,0x0165,
0x0c66,0x0003,0x0054,0x02ab,0x0016,0x05f7,0x0005,0x00f8,
0x0aa9,0x005f,0x0004,0x001c,0x1550,0x0004,0x0077,0x076c,
0x000e,0x000a,0x000c,0x0562,0x0004,0x031c,0x0006,0x00c8,
0x000d,0x01da,0x0007,0x00c9,0x0001,0x002e,0x0014,0x1596,
0x000a,0x0ac2,0x0016,0x015b,0x0015,0x015a,0x000f,0x005e,
0x007e,0x00ab,0x002d,0x00d8,0x000b,0x0014,0x02b3,0x01f3,
0x003a,0x0000,0x0058,0x002e,0x005e,0x0563,0x00ec,0x0054,
0x0ac1,0x1556,0x02fa,0x0181,0x1557,0x059d,0x2aa3,0x2b2a,
0x01de,0x063c,0x00cf,0x1594,0x000d};
_CONST uint16_t rl3_data[149] = {
0x3001,0x5002,0x7003,0x8004,0x9005,0xa006,0xb007,0xc008,
0xc009,0xd00a,0xd00b,0xe00c,0xe00d,0xf00e,0x4021,0x7022,
0x9023,0xb024,0xc025,0xd026,0xd027,0xe028,0xf029,0x5041,
0x8042,0xb043,0xc044,0xe045,0x6061,0x9062,0xc063,0xe064,
0x6081,0xa082,0xc083,0xe084,0x60a1,0xa0a2,0xc0a3,0xe0a4,
0x70c1,0xb0c2,0xd0c3,0x70e1,0xb0e2,0xd0e3,0x7101,0xb102,
0xe103,0x8121,0xb122,0xe123,0x8141,0xc142,0xf143,0x9161,
0xb162,0xd163,0x8181,0xc182,0xe183,0x91a1,0xd1a2,0x91c1,
0xd1c2,0x91e1,0xd1e2,0xb201,0xb221,0xc241,0xc261,0xb281,
0xc2a1,0xd2c1,0xd2e1,0xd301,0xc321,0xc341,0xb361,0xc381,
0xe3a1,0x2801,0x7802,0xa803,0xd804,0xe805,0x4821,0x9822,
0xc823,0xf824,0x4841,0xa842,0xd843,0x5861,0xb862,0xf863,
0x5881,0xc882,0x58a1,0xb8a2,0x68c1,0xc8c2,0x68e1,0xd8e2,
0x6901,0xd902,0x6921,0xd922,0x7941,0xe942,0x7961,0xd962,
0x7981,0xc982,0x79a1,0xe9a2,0x79c1,0xe9c2,0x89e1,0xf9e2,
0x8a01,0x8a21,0x9a41,0x9a61,0x9a81,0xaaa1,0xaac1,0xaae1,
0xab01,0xab21,0xab41,0x9b61,0xab81,0xbba1,0xcbc1,0xcbe1,
0xcc01,0xdc21,0xdc41,0xbc61,0xdc81,0xeca1,0xecc1,0xece1,
0xed01,0xdd21,0xdd41,0xdd61,0x9ff0};

_CONST uint16_t rl4_code[169] = { // maxbit 15
0x0000,0x0003,0x000b,0x0014,0x003f,0x005d,0x00a2,0x00ac,
0x016e,0x020a,0x02e2,0x0432,0x05c9,0x0827,0x0b54,0x04e6,
0x105f,0x172a,0x20b2,0x2d4e,0x39f0,0x4175,0x5a9e,0x0004,
0x001e,0x0042,0x00b6,0x0173,0x0395,0x072e,0x0b94,0x16a4,
0x20b3,0x2e45,0x0005,0x0040,0x0049,0x028f,0x05cb,0x048a,
0x09dd,0x73e2,0x0018,0x0025,0x008a,0x051b,0x0e5f,0x09c9,
0x139c,0x0029,0x004f,0x0412,0x048d,0x2e41,0x0038,0x010e,
0x05a8,0x105c,0x39f2,0x0058,0x021f,0x0e7e,0x39ff,0x0023,
0x02e3,0x04e5,0x2e40,0x00a1,0x05be,0x09c8,0x0083,0x013a,
0x1721,0x0044,0x0276,0x39f6,0x008b,0x04ef,0x5a9b,0x0208,
0x1cfe,0x0399,0x1cb4,0x039e,0x39f3,0x05ab,0x73e3,0x0737,
0x5a9f,0x082d,0x0e69,0x0e68,0x0433,0x0b7b,0x2df8,0x2e56,
0x2e57,0x39f7,0x51a5,0x0003,0x002a,0x00e4,0x028e,0x0735,
0x1058,0x1cfa,0x2df9,0x4174,0x0009,0x0054,0x0398,0x048b,
0x139d,0x000d,0x00ad,0x0826,0x2d4c,0x0011,0x016b,0x0b7f,
0x51a4,0x0019,0x021b,0x16fd,0x001d,0x0394,0x28d3,0x002b,
0x05bc,0x5a9a,0x002f,0x0247,0x0010,0x0a35,0x003e,0x0b7a,
0x0059,0x105e,0x0026,0x09cf,0x0055,0x1cb5,0x0057,0x0e5b,
0x00a0,0x1468,0x0170,0x0090,0x01ce,0x021a,0x0218,0x0168,
0x021e,0x0244,0x0736,0x0138,0x0519,0x0e5e,0x072c,0x0b55,
0x09dc,0x20bb,0x048c,0x1723,0x2e44,0x16a5,0x0518,0x39fe,
0x0169};
_CONST uint16_t rl4_data[169] = {
0x3001,0x4002,0x5003,0x6004,0x6005,0x7006,0x8007,0x9008,
0x9009,0xa00a,0xa00b,0xb00c,0xb00d,0xc00e,0xc00f,0xd010,
0xd011,0xd012,0xe013,0xe014,0xe015,0xf016,0xf017,0x4021,
0x5022,0x7023,0x8024,0x9025,0xa026,0xb027,0xc028,0xd029,
0xe02a,0xe02b,0x5041,0x7042,0x9043,0xa044,0xb045,0xd046,
0xe047,0xf048,0x5061,0x8062,0xa063,0xb064,0xc065,0xe066,
0xf067,0x6081,0x9082,0xb083,0xd084,0xe085,0x60a1,0x90a2,
0xb0a3,0xd0a4,0xe0a5,0x70c1,0xa0c2,0xc0c3,0xe0c4,0x80e1,
0xa0e2,0xd0e3,0xe0e4,0x8101,0xb102,0xe103,0x8121,0xb122,
0xd123,0x9141,0xc142,0xe143,0xa161,0xd162,0xf163,0xa181,
0xd182,0xa1a1,0xd1a2,0xa1c1,0xe1c2,0xb1e1,0xf1e2,0xb201,
0xf202,0xc221,0xc241,0xc261,0xb281,0xc2a1,0xe2c1,0xe2e1,
0xe301,0xe321,0xf341,0x3801,0x6802,0x8803,0xa804,0xb805,
0xd806,0xd807,0xe808,0xf809,0x4821,0x8822,0xa823,0xd824,
0xf825,0x4841,0x9842,0xc843,0xe844,0x5861,0x9862,0xc863,
0xf864,0x5881,0xa882,0xd883,0x58a1,0xa8a2,0xe8a3,0x68c1,
0xb8c2,0xf8c3,0x68e1,0xc8e2,0x7901,0xc902,0x6921,0xc922,
0x7941,0xd942,0x8961,0xe962,0x8981,0xd982,0x89a1,0xc9a2,
0x89c1,0xd9c2,0x99e1,0xaa01,0x9a21,0xaa41,0xaa61,0x9a81,
0xaaa1,0xcac1,0xbae1,0xbb01,0xbb21,0xcb41,0xbb61,0xcb81,
0xeba1,0xebc1,0xdbe1,0xdc01,0xec21,0xdc41,0xbc61,0xec81,
0x9ff0};

_CONST uint16_t rl5_code[103] = { // maxbit 12
0x0002,0x000f,0x0015,0x0017,0x001f,0x0025,0x0024,0x0021,
0x0020,0x0007,0x0006,0x0020,0x0006,0x0014,0x001e,0x000f,
0x0021,0x0050,0x000e,0x001d,0x000e,0x0051,0x000d,0x0023,
0x000d,0x000c,0x0022,0x0052,0x000b,0x000c,0x0053,0x0013,
0x000b,0x0054,0x0012,0x000a,0x0011,0x0009,0x0010,0x0008,
0x0016,0x0055,0x0015,0x0014,0x001c,0x001b,0x0021,0x0020,
0x001f,0x001e,0x001d,0x001c,0x001b,0x001a,0x0022,0x0023,
0x0056,0x0057,0x0007,0x0019,0x0005,0x000f,0x0004,0x000e,
0x000d,0x000c,0x0013,0x0012,0x0011,0x0010,0x001a,0x0019,
0x0018,0x0017,0x0016,0x0015,0x0014,0x0013,0x0018,0x0017,
0x0016,0x0015,0x0014,0x0013,0x0012,0x0011,0x0007,0x0006,
0x0005,0x0004,0x0024,0x0025,0x0026,0x0027,0x0058,0x0059,
0x005a,0x005b,0x005c,0x005d,0x005e,0x005f,0x0003};
_CONST uint16_t rl5_data[103] = {
0x2001,0x4002,0x6003,0x7004,0x8005,0x9006,0x9007,0xa008,
0xa009,0xb00a,0xb00b,0xb00c,0x3021,0x6022,0x8023,0xa024,
0xb025,0xc026,0x4041,0x8042,0xa043,0xc044,0x5061,0x9062,
0xa063,0x5081,0x9082,0xc083,0x50a1,0xa0a2,0xc0a3,0x60c1,
0xa0c2,0xc0c3,0x60e1,0xa0e2,0x6101,0xa102,0x6121,0xa122,
0x7141,0xc142,0x7161,0x7181,0x81a1,0x81c1,0x91e1,0x9201,
0x9221,0x9241,0x9261,0x9281,0x92a1,0x92c1,0xb2e1,0xb301,
0xc321,0xc341,0x4801,0x9802,0xb803,0x6821,0xb822,0x6841,
0x6861,0x6881,0x78a1,0x78c1,0x78e1,0x7901,0x8921,0x8941,
0x8961,0x8981,0x89a1,0x89c1,0x89e1,0x8a01,0x9a21,0x9a41,
0x9a61,0x9a81,0x9aa1,0x9ac1,0x9ae1,0x9b01,0xab21,0xab41,
0xab61,0xab81,0xbba1,0xbbc1,0xbbe1,0xbc01,0xcc21,0xcc41,
0xcc61,0xcc81,0xcca1,0xccc1,0xcce1,0xcd01,0x7ff0};

_CONST uint32_t dc0_lum_code[120] = { // maxbit 24
0x00000021,0x00000022,0x00000024,0x00000025,
0x000000A5,0x000000E5,0x00000106,0x00000186,
0x00000007,0x00000047,0x00000247,0x00000347,
0x00000068,0x000000E8,0x000004E8,0x000006E8,
0x000000A9,0x00000989,0x00000D89,0x00000DA9,
0x0000010A,0x0000032A,0x0000136A,0x0000036A,
0x0000134A,0x0000026B,0x0000068B,0x000006AB,
0x00000C2C,0x0000090D,0x0000188D,0x0000094D,
0x000018CD,0x000018ED,0x0000124E,0x0000316E,
0x0000126E,0x0000306E,0x0000304E,0x000012CE,
0x000012EE,0x0000300E,0x0000628F,0x000062AF,
0x0000C0B0,0x0000C090,0x0000C0D0,0x000181D1,
0x006079B7,0x00607937,0x00607917,0x00607957,
0x00607977,0x00607997,0x006079D7,0x006079F7,
0x00607A17,0x00607A37,0x00607A57,0x00607A77,
0x00607A97,0x00607AB7,0x00607AD7,0x00607AF7,
0x00607B17,0x00607B37,0x00607B57,0x00607B77,
0x00607B97,0x00607BB7,0x00607BD7,0x00607BF7,
0x00607C17,0x00607C37,0x00607C57,0x00607C77,
0x00607C97,0x00607CB7,0x00607CD7,0x00607CF7,
0x00607D17,0x00607D37,0x00607D57,0x00607D77,
0x00607D97,0x00607DB7,0x00607DD7,0x00607DF7,
0x00607E17,0x00607E37,0x00607E57,0x00607E77,
0x00607E97,0x00607EB7,0x00607ED7,0x00607EF7,
0x00607F17,0x00607F37,0x00607F57,0x00607F77,
0x00607F97,0x00607FB7,0x00607FD7,0x00607FF7,
0x00C0F018,0x00C0F038,0x00C0F058,0x00C0F078,
0x00C0F098,0x00C0F0B8,0x00C0F0D8,0x00C0F0F8,
0x00C0F118,0x00C0F138,0x00C0F158,0x00C0F178,
0x00C0F198,0x00C0F1B8,0x00C0F1D8,0x00C0F1F8};

_CONST uint32_t dc1_lum_code[120] = { // maxbit 26
0x00000042,0x00000062,0x00000063,0x00000044,
0x000000A4,0x00000025,0x00000065,0x00000105,
0x00000006,0x000000A6,0x000001A6,0x000001E6,
0x00000266,0x00000107,0x00000307,0x00000387,
0x00000487,0x00000088,0x000000C8,0x00000248,
0x00000648,0x00000768,0x00000948,0x00000968,
0x00000169,0x000004C9,0x000004E9,0x00000CC9,
0x00000E89,0x00000EA9,0x0000028A,0x0000038A,
0x000003EA,0x000003AA,0x0000056B,0x000007AB,
0x000033AB,0x000033EB,0x00000A8C,0x0000672C,
0x0000670C,0x000067AC,0x0000156D,0x00001E2D,
0x0000CF0D,0x00001E4D,0x00003C0E,0x00003C2E,
0x00002A8E,0x00019E4E,0x0000798F,0x0000556F,
0x00033CEF,0x000079CF,0x00033CCF,0x0000AA90,
0x0000F3F0,0x0000AAB0,0x0001E7B1,0x0001E6F1,
0x0001E791,0x0001E6B1,0x0003CDB2,0x0003CD12,
0x00079B13,0x00079A73,0x00079B33,0x000F3494,
0x01E69759,0x01E69699,0x01E696B9,0x01E696D9,
0x01E696F9,0x01E69719,0x01E69739,0x01E69779,
0x01E69799,0x01E697B9,0x01E697D9,0x01E697F9,
0x03CD281A,0x03CD283A,0x03CD285A,0x03CD287A,
0x03CD289A,0x03CD28BA,0x03CD28DA,0x03CD28FA,
0x03CD291A,0x03CD293A,0x03CD295A,0x03CD297A,
0x03CD299A,0x03CD29BA,0x03CD29DA,0x03CD29FA,
0x03CD2A1A,0x03CD2A3A,0x03CD2A5A,0x03CD2A7A,
0x03CD2A9A,0x03CD2ABA,0x03CD2ADA,0x03CD2AFA,
0x03CD2B1A,0x03CD2B3A,0x03CD2B5A,0x03CD2B7A,
0x03CD2B9A,0x03CD2BBA,0x03CD2BDA,0x03CD2BFA,
0x03CD2C1A,0x03CD2C3A,0x03CD2C5A,0x03CD2C7A,
0x03CD2C9A,0x03CD2CBA,0x03CD2CDA,0x03CD2CFA};

_CONST uint32_t dc0_chr_code[120] = { // maxbit 23
0x00000002,0x00000022,0x000000A3,0x00000124,
0x000001A4,0x00000225,0x000003A5,0x000003E5,
0x00000426,0x00000626,0x00000706,0x00000666,
0x00000726,0x000007A6,0x00000C27,0x00000F27,
0x00001008,0x00001908,0x00001948,0x00001E08,
0x00001028,0x00001808,0x00001928,0x000020E9,
0x000020C9,0x000032C9,0x00003069,0x00003C69,
0x00003C49,0x0000414A,0x0000416A,0x0000C12B,
0x0000824B,0x0000826B,0x0000C16B,0x0000822B,
0x0000C14B,0x0000CBEB,0x0000820B,0x0000CBAB,
0x0000CBCB,0x0001970C,0x0001820C,0x0001972C,
0x0003046D,0x000608AE,0x000C112F,0x00182210,
0x06088916,0x06088936,0x06088956,0x06088976,
0x06088996,0x060889B6,0x060889D6,0x060889F6,
0x06088A16,0x06088A36,0x06088A56,0x06088A76,
0x06088A96,0x06088AB6,0x06088AD6,0x06088AF6,
0x06088B16,0x06088B36,0x06088B56,0x06088B76,
0x06088B96,0x06088BB6,0x06088BD6,0x06088BF6,
0x06088C16,0x06088C36,0x06088C56,0x06088C76,
0x06088C96,0x06088CB6,0x06088CD6,0x06088CF6,
0x06088D16,0x06088D36,0x06088D56,0x06088D76,
0x06088D96,0x06088DB6,0x06088DD6,0x06088DF6,
0x06088E16,0x06088E36,0x06088E56,0x06088E76,
0x06088E96,0x06088EB6,0x06088ED6,0x06088EF6,
0x06088F16,0x06088F36,0x06088F56,0x06088F76,
0x06088F96,0x06088FB6,0x06088FD6,0x06088FF6,
0x0C111017,0x0C111037,0x0C111057,0x0C111077,
0x0C111097,0x0C1110B7,0x0C1110D7,0x0C1110F7,
0x0C111117,0x0C111137,0x0C111157,0x0C111177,
0x0C111197,0x0C1111B7,0x0C1111D7,0x0C1111F7};

_CONST uint32_t dc1_chr_code[120] = { // maxbit 25
0x00000002,0x00000022,0x00000083,0x000000E3,
0x00000164,0x000001A4,0x000002A5,0x00000506,
0x00000606,0x00000646,0x00000A47,0x00000C47,
0x00000CC7,0x000014C8,0x000018C8,0x000019E8,
0x000029E9,0x000031C9,0x00003389,0x000053AA,
0x0000674A,0x0000A70B,0x0000C78B,0x0000C7CB,
0x0000C7EB,0x0000CECB,0x00014E6C,0x00018F4C,
0x00019DEC,0x00029CAD,0x00033BAD,0x0005390E,
0x0005392E,0x000C7BAF,0x0006770E,0x0006772E,
0x0018F6D0,0x000C7B0F,0x000C7BEF,0x0018F670,
0x0018F690,0x0018F6B0,0x000C7BCF,0x0018F6F0,
0x0018F710,0x0018F730,0x0031ECB1,0x0063D912,
0x18F64918,0x18F64938,0x18F64958,0x18F64978,
0x18F64998,0x18F649B8,0x18F649D8,0x18F649F8,
0x18F64A18,0x18F64A38,0x18F64A58,0x18F64A78,
0x18F64A98,0x18F64AB8,0x18F64AD8,0x18F64AF8,
0x18F64B18,0x18F64B38,0x18F64B58,0x18F64B78,
0x18F64B98,0x18F64BB8,0x18F64BD8,0x18F64BF8,
0x18F64C18,0x18F64C38,0x18F64C58,0x18F64C78,
0x18F64C98,0x18F64CB8,0x18F64CD8,0x18F64CF8,
0x18F64D18,0x18F64D38,0x18F64D58,0x18F64D78,
0x18F64D98,0x18F64DB8,0x18F64DD8,0x18F64DF8,
0x18F64E18,0x18F64E38,0x18F64E58,0x18F64E78,
0x18F64E98,0x18F64EB8,0x18F64ED8,0x18F64EF8,
0x18F64F18,0x18F64F38,0x18F64F58,0x18F64F78,
0x18F64F98,0x18F64FB8,0x18F64FD8,0x18F64FF8,
0x31EC9019,0x31EC9039,0x31EC9059,0x31EC9079,
0x31EC9099,0x31EC90B9,0x31EC90D9,0x31EC90F9,
0x31EC9119,0x31EC9139,0x31EC9159,0x31EC9179,
0x31EC9199,0x31EC91B9,0x31EC91D9,0x31EC91F9};

_CONST uint32_t mb_inter_code[128] = { // maxbit 21
0x00000807,0x0002792D,0x00013FAC,0x00003F8F,
0x00013F8C,0x00015072,0x0025A691,0x00107790,
0x0001074C,0x0000FF11,0x00007FB0,0x00007FF0,
0x00000F2D,0x00015052,0x0012D3B0,0x00005490,
0x00012F0C,0x0000A871,0x00083BEF,0x0000FF31,
0x00025E6D,0x004B4D72,0x004BDF32,0x00007F50,
0x00041DCE,0x012D3574,0x0012D390,0x004BDF12,
0x00025A4D,0x000150B2,0x0012D3D0,0x0009790F,
0x000007AC,0x0025EFF1,0x00005450,0x0012D3F0,
0x0004BDCE,0x025A6AB5,0x0025EFB1,0x0025EFD1,
0x00013CAC,0x00015032,0x00969A93,0x001077B0,
0x00000F0D,0x0012D370,0x00007FD0,0x000054B0,
0x00000FCD,0x00015012,0x00005470,0x00007F70,
0x00020ECD,0x00015092,0x00002A6F,0x0009792F,
0x00000AAD,0x025A6A95,0x00097BCF,0x0004BCAE,
0x00004B6A,0x0009698F,0x00012D6C,0x00012D4C,
0x00000022,0x00000007,0x000004C6,0x00002569,
0x000000E3,0x000041EA,0x00000089,0x0000050C,
0x000000C3,0x0000414A,0x00002509,0x0000056C,
0x00000225,0x0000036B,0x00002749,0x00009FEB,
0x00000064,0x00004EEA,0x000020C9,0x0001072C,
0x00000164,0x00004F6A,0x00002589,0x000097EB,
0x00000126,0x000006AC,0x00004FCA,0x0002790D,
0x00000026,0x0000954B,0x0000410A,0x0000052C,
0x00000024,0x00004A8A,0x000025C9,0x0001070C,
0x00000486,0x00009E6B,0x00004ECA,0x00025ECD,
0x00000025,0x00004F4A,0x000027C9,0x000007CC,
0x00000106,0x0000826B,0x0000018A,0x000097CB,
0x00000285,0x0000824B,0x00004A6A,0x00012F4C,
0x00000426,0x0000956B,0x0000416A,0x0000068C,
0x000002A5,0x00004F0A,0x00004A4A,0x00012D0C,
0x000000A5,0x0000016A,0x00001388,0x000001CA};

_CONST uint32_t mb_intra_code[64] = { // maxbit 13
0x00000021,0x000002E6,0x00000125,0x000000A5,
0x000000C5,0x000008E9,0x00000407,0x00000207,
0x00000045,0x00000F89,0x00000747,0x000003A7,
0x00000046,0x00001D89,0x00000EE8,0x00000008,
0x00000065,0x000016E9,0x00000587,0x00000267,
0x00000026,0x00002D0A,0x000008C8,0x000007E8,
0x000003C6,0x0000E24D,0x000016A9,0x00000848,
0x00000447,0x000038AB,0x000023CA,0x000010E9,
0x000000C4,0x00000069,0x000003C7,0x00000386,
0x00000247,0x0000710C,0x00000889,0x00000E09,
0x000003E6,0x000047CB,0x00000728,0x000011C9,
0x00000027,0x000038CB,0x000016C9,0x000008A9,
0x00000286,0x000047EB,0x00000FA9,0x00000309,
0x000000E7,0x000038EB,0x000010C9,0x00000329,
0x000002A6,0x00003B6A,0x00000049,0x000008C9,
0x000001A8,0x0000E26D,0x00003B4A,0x00002D2A};

static void initrl(uint8_t *p,const uint16_t* data,int size)
{
    int last, run, level, i;
	memset(p,0,128+64);
	for (i=0;i<size;++i,++data)
		if ((*data & 0xFFF) != ESCAPE)
		{
			last = (*data >> 11) & 1;
			run = (*data >> 5) & 63;
			level = *data & 31;
			if (level > p[run | (last << 6)])
				p[run | (last << 6)] = (uint8_t)level;
			if (run > p[128+((last << 5)|level)])
				p[128+((last << 5)|level)] = (uint8_t)run;
		}
}

static void msmpeg4_delete( mp4_decode* dec )
{
	free(dec->vlcdata);
	free(dec->rlmax);
	mp4_delete(dec);
}

static int msmpeg4_create( mp4_decode* dec )
{
	mp4_create(dec);

	dec->gethdr = gethdr_msmpeg;
	dec->IVOP = IVOP_msmpeg;
	dec->PVOP = PVOP_msmpeg;
	dec->BVOP = BVOP_msmpeg;

	dec->vlcdata = malloc(sizeof(uint16_t)*MAX_VLC);
	dec->rlmax = malloc(6*(128+64));
	if (!dec->vlcdata || !dec->rlmax)
		return ERR_OUT_OF_MEMORY;

	dec->vlctable = dec->vlcdata;
	dec->vlcpos = 0;

	initrl(dec->rlmax+0*192,rl0_data,133);
	dec->rl_table[0] = initvlc(dec,rl0_code,2,rl0_data,133);
	initrl(dec->rlmax+1*192,rl1_data,186);
	dec->rl_table[1] = initvlc(dec,rl1_code,2,rl1_data,186);
	initrl(dec->rlmax+2*192,rl2_data,103);
	dec->rl_table[2] = initvlc(dec,rl2_code,2,rl2_data,103);
	initrl(dec->rlmax+3*192,rl3_data,149);
	dec->rl_table[3] = initvlc(dec,rl3_code,2,rl3_data,149);
	initrl(dec->rlmax+4*192,rl4_data,169);
	dec->rl_table[4] = initvlc(dec,rl4_code,2,rl4_data,169);
	initrl(dec->rlmax+5*192,rl5_data,103);
	dec->rl_table[5] = initvlc(dec,rl5_code,2,rl5_data,103);

	dec->mv_table[0] = initvlc(dec,mv0_code,4,mv0_data,1100);
	dec->mv_table[1] = initvlc(dec,mv1_code,4,mv1_data,1100);

	dec->dc_lum_table[0] = initvlc(dec,dc0_lum_code,4,NULL,120);
	dec->dc_lum_table[1] = initvlc(dec,dc1_lum_code,4,NULL,120);
	dec->dc_chr_table[0] = initvlc(dec,dc0_chr_code,4,NULL,120);
	dec->dc_chr_table[1] = initvlc(dec,dc1_chr_code,4,NULL,120);

	dec->mb_intra_vlc = initvlc(dec,mb_intra_code,4,NULL,64);
	dec->mb_inter_vlc = initvlc(dec,mb_inter_code,4,NULL,128);
	return ERR_NONE;
}

static _CONST nodedef MSMPEG4Def =
{
	sizeof(mp4_decode),
	MSMPEG4_ID,
	CODECIDCT_CLASS,
	PRI_DEFAULT,
	(nodecreate)msmpeg4_create,
	(nodedelete)msmpeg4_delete,
};

void msmpeg4_init()
{
	NodeRegisterClass(&MSMPEG4Def);
}

void msmpeg4_done()
{
	NodeUnRegisterClass(MSMPEG4_ID);
}

#endif
