/*
 * Decompiled with CFR 0.152.
 */
package com.palm.novacom.internal;

class PacketHeader {
    static final int PACKET_HEADER_MAGIC = -557122643;
    static final int PACKET_HEADER_VERSION = 1;
    static final int PACKET_HEADER_TYPE_DATA = 0;
    static final int PACKET_HEADER_TYPE_ERR = 1;
    static final int PACKET_HEADER_TYPE_OOB = 2;
    static final int PACKET_HEADER_BYTES = 16;
    byte[] header = new byte[16];

    public byte[] getHeader() {
        return this.header;
    }

    public byte[] makeHeader(int size, int type) {
        this.stuffAnInt(-557122643, this.header, 0);
        this.stuffAnInt(1, this.header, 4);
        this.stuffAnInt(size, this.header, 8);
        this.stuffAnInt(type, this.header, 12);
        return this.header;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("PacketHeader[");
        buffer.append("magic 0x" + Integer.toHexString(this.getMagic()));
        buffer.append(", version 0x" + Integer.toHexString(this.getVersion()));
        buffer.append(", size 0x" + Integer.toHexString(this.getSize()));
        buffer.append(", type 0x" + Integer.toHexString(this.getType()));
        buffer.append("]");
        return buffer.toString();
    }

    int makeAnInt(int i1, int i2, int i3, int i4) {
        return (i1 &= 0xFF) << 0 | (i2 &= 0xFF) << 8 | (i3 &= 0xFF) << 16 | (i4 &= 0xFF) << 24;
    }

    void stuffAnInt(int val, byte[] array, int offset) {
        array[offset + 0] = (byte)(val >> 0 & 0xFF);
        array[offset + 1] = (byte)(val >> 8 & 0xFF);
        array[offset + 2] = (byte)(val >> 16 & 0xFF);
        array[offset + 3] = (byte)(val >> 24 & 0xFF);
    }

    public int getMagic() {
        return this.makeAnInt(this.header[0], this.header[1], this.header[2], this.header[3]);
    }

    public int getVersion() {
        return this.makeAnInt(this.header[4], this.header[5], this.header[6], this.header[7]);
    }

    public int getSize() {
        return this.makeAnInt(this.header[8], this.header[9], this.header[10], this.header[11]);
    }

    public int getType() {
        return this.makeAnInt(this.header[12], this.header[13], this.header[14], this.header[15]);
    }
}

