/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.core;

import com.palm.nova.installer.core.IFlasherLogger;
import com.palm.nova.installer.core.IStageProgressReporter;
import com.palm.nova.installer.core.InstallerModel;
import com.palm.nova.installer.core.ScreenPainter;
import com.palm.nova.installer.core.TarredInstallerModel;
import com.palm.nova.installer.core.TrenchcoatModel;
import com.palm.nova.installer.core.stages.AppFolderDeletionStage;
import com.palm.nova.installer.core.stages.BypassFirstUseStage;
import com.palm.nova.installer.core.stages.ChargeBatteryStage;
import com.palm.nova.installer.core.stages.CustomizationStage;
import com.palm.nova.installer.core.stages.EnableNovacomUsbByDefaultStage;
import com.palm.nova.installer.core.stages.GoIntoUpdateModeStage;
import com.palm.nova.installer.core.stages.ModemUpdateStage;
import com.palm.nova.installer.core.stages.RamdiskLoadingStage;
import com.palm.nova.installer.core.stages.SoftwareUpdateSiteStage;
import com.palm.nova.installer.core.stages.TouchPanelUpdateStage;
import com.palm.nova.installer.core.stages.TrenchcoatStage;
import com.palm.nova.installer.core.stages.VerifyRomStage;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.Novacom;
import com.palm.novacom.NovacomException;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class FlasherThread
implements Runnable,
IStageProgressReporter {
    InstallerModel baseModel = null;
    TarredInstallerModel customizationModel = null;
    String massStorageData = null;
    String softwareUpdateSite = null;
    String softwareUpdateUrl = null;
    String postFlashScript = null;
    INovacomDevice device;
    IFlasherLogger flasherLogger;
    String developerMode = null;
    boolean doVerifyRomImage = true;
    boolean doForceModemFwUpdate = false;
    private boolean doSaveMsm = false;
    int percentFlashedComplete = 0;
    private String screenPicture = "";
    private boolean doSkipBatteryCeck = false;
    private boolean doSkipFirstUse = false;
    private boolean doSkipModemFwUpdate = false;
    private boolean doSkipTouchpanelUpdate = false;
    private boolean doForceTouchpanelUpdate = false;
    private String carrierList = "";
    private String modelList = "";
    private String deviceType = "";
    private boolean doDeleteAppDirectory = true;
    static final int INIT = 1;
    static final int UPDATE_STAGE = 2;
    static final int RAMDISK_LOADING_STAGE = 7;
    static final int PAINT_IMAGE = 1;
    static final int BUILD_TRENCOAT_MODEL = 3;
    static final int TRENCHCOAT_STAGE = 40;
    static final int CUSTOMIZATION_STAGE = 10;
    static final int SOFTWARE_UPDATE_STAGE = 5;
    static final int VERIFY_ROM_STAGE = 5;
    static final int MODEM_STAGE = 20;
    static final int TOUCHPANEL_STAGE = 6;
    static final String CARRIER = "DMCARRIER";
    static final String MODEL = "DMMODEL";
    static final String PROD_ID = "PRODoID";
    static final int NUM_RETRIES = 2;

    public FlasherThread(InstallerModel baseModel, TarredInstallerModel customizationModel) {
        this.baseModel = baseModel;
        this.customizationModel = customizationModel;
    }

    @Override
    public void run() {
        int retries = 2;
        try {
            Novacom.DeviceState state = this.device.getState();
            while (retries > 0) {
                this.percentFlashedComplete = 0;
                ++this.percentFlashedComplete;
                this.flasherLogger.postFlashEvent(IFlasherLogger.FlashEvents.PERCENT_UPDATE, this.percentFlashedComplete);
                if (state == Novacom.DeviceState.OS) {
                    this.flasherLogger.logPrintln("device believed to be in the device OS, will try to force to bootie");
                    GoIntoUpdateModeStage intoUpdateMode = new GoIntoUpdateModeStage(this.device);
                    intoUpdateMode.setProgressHandler(this);
                    intoUpdateMode.run();
                    state = this.device.getState();
                }
                if (state == Novacom.DeviceState.BOOTLOADER) {
                    if (!this.doSkipBatteryCeck) {
                        ChargeBatteryStage chargeBatteryStage = new ChargeBatteryStage(this.device);
                        chargeBatteryStage.setProgressHandler(this);
                        chargeBatteryStage.run();
                    }
                    if (retries == 2) {
                        String macName = this.device.getDeviceInfo().getMachineName().toLowerCase();
                        if (this.deviceType.length() == 0) {
                            this.flasherLogger.logPrintln("WARNING - DeviceType returned is empty, unless not checking for DeviceType in the case of NDI");
                        } else if (this.deviceType.contains(macName)) {
                            this.flasherLogger.logPrintln("Found DeviceType match for : " + macName);
                        } else if (this.deviceType.length() > 0 && !this.deviceType.contains(macName)) {
                            this.flasherLogger.logPrintln("DeviceType on the webOS Dr is : " + this.deviceType + " and deviceType on the device is : " + macName);
                            this.resetDevice();
                            throw new NovacomException(-1, "TOKEN MISMATCH: Failed to find match for Device information. Prevent user from flashing");
                        }
                    }
                    this.flasherLogger.logPrintln("device believed to be in bootloader, will load ramdisk");
                    RamdiskLoadingStage ramdiskStage = new RamdiskLoadingStage(this.baseModel, this.device);
                    ramdiskStage.setProgressHandler(this);
                    ramdiskStage.run();
                    state = this.device.getState();
                }
                --retries;
                if (state != Novacom.DeviceState.INSTALLER) {
                    this.flasherLogger.logPrintln("device not in ramdisk, state is " + (Object)((Object)state));
                    if (retries == 0) {
                        this.flasherLogger.logPrintln("can't get into update state, retries exhausted");
                        throw new NovacomException(-1, "the device isn't running the ramdisk as expected");
                    }
                    this.flasherLogger.logPrintln("trying to get into update state again");
                    continue;
                }
                retries = 0;
                this.flasherLogger.logPrintln("device is in ramdisk as expected");
            }
            if (this.doDeleteAppDirectory) {
                AppFolderDeletionStage appFolderDeletionStage = new AppFolderDeletionStage(this.device);
                appFolderDeletionStage.setProgressHandler(this);
                appFolderDeletionStage.run();
            }
            if (this.carrierList.length() == 0) {
                this.flasherLogger.logPrintln("WARNING - carrier list returned is empty, unless not checking for carrier in the case of NDI");
            } else {
                String carrierToken = this.getToken(CARRIER).toLowerCase();
                if (this.carrierList.contains(carrierToken)) {
                    this.flasherLogger.logPrintln("Found device Carrier match for :" + carrierToken);
                } else if (this.carrierList.length() > 0 && !this.carrierList.contains(carrierToken)) {
                    this.flasherLogger.logPrintln("WARING: carrierList on the webOS Dr is : " + this.carrierList + " and carrierToken on the device is : " + carrierToken);
                    this.rebootDeviceWithBootie();
                    throw new NovacomException(-1, "TOKEN MISMATCH: Failed to find match for Carrier information. Prevent user from flashing");
                }
            }
            if (this.modelList.length() == 0) {
                this.flasherLogger.logPrintln("WARNING - model list returned is empty, unless not checking for model in the case of NDI");
            } else {
                String modelToken = this.getToken(MODEL).toLowerCase();
                String prodID = this.getToken(PROD_ID).toLowerCase();
                if (this.modelList.contains(modelToken)) {
                    this.flasherLogger.logPrintln("Found device Model match for : " + modelToken);
                } else if (!this.modelList.contains(modelToken) && this.modelList.contains(prodID)) {
                    this.flasherLogger.logPrintln("Found device PRODoID match  : " + modelToken);
                } else if (this.modelList.length() > 0 && !this.modelList.contains(modelToken) && !this.modelList.contains(prodID)) {
                    this.flasherLogger.logPrintln("WARNING: modelList on the webOS Dr is : " + this.modelList + " and modelToken on the device is : " + modelToken + " prodID token is : " + prodID);
                    this.rebootDeviceWithBootie();
                    throw new NovacomException(-1, "TOKEN MISMATCH: Failed to find match for Model information. Prevent user from flashing");
                }
            }
            ScreenPainter painter = new ScreenPainter(this.device);
            if (this.screenPicture == "") {
                painter.drawImageCentered(this.getClass().getResourceAsStream("/resources/flasher.png"));
            } else {
                painter.drawImageCentered(this.getClass().getResourceAsStream(this.screenPicture));
            }
            ++this.percentFlashedComplete;
            this.flasherLogger.postFlashEvent(IFlasherLogger.FlashEvents.PERCENT_UPDATE, this.percentFlashedComplete);
            TrenchcoatModel tcmodel = new TrenchcoatModel(this.baseModel, this.customizationModel);
            tcmodel.initDmSetsToken("NONE", "NONE");
            tcmodel.initBatteryCheckToken();
            this.percentFlashedComplete += 3;
            this.flasherLogger.postFlashEvent(IFlasherLogger.FlashEvents.PERCENT_UPDATE, this.percentFlashedComplete);
            if (null != this.massStorageData && 0 != this.massStorageData.length()) {
                tcmodel.addMassStorageData(this.massStorageData);
            } else {
                tcmodel.doPreserveMsmContents(this.doSaveMsm);
            }
            TrenchcoatStage trenchcoat = new TrenchcoatStage(tcmodel, this.device);
            trenchcoat.setProgressHandler(this);
            retries = 3;
            while (retries > 0) {
                try {
                    trenchcoat.run();
                    retries = 0;
                }
                catch (NovacomException e) {
                    this.flasherLogger.logPrintln(e.getErrorMessage());
                    if (0 == --retries) {
                        this.flasherLogger.logPrintln("trenchcoat retries exhausted");
                        throw new NovacomException(-1, "Trenchcoat failure, retries exhausted");
                    }
                    this.flasherLogger.logPrintln("retrying trenchcoat");
                }
            }
            if (!this.doSkipModemFwUpdate) {
                try {
                    ModemUpdateStage modemUpdater = new ModemUpdateStage(this.baseModel, this.device);
                    modemUpdater.setForceUpdate(this.doForceModemFwUpdate);
                    modemUpdater.setProgressHandler(this);
                    modemUpdater.run();
                }
                catch (FileNotFoundException e) {
                    this.flasherLogger.logPrintln("*** No modem firmware found in installer package, skipping modem update.");
                    this.endJob("Modem Updater");
                }
            } else {
                this.flasherLogger.logPrintln("*** modem fw, skipping update.");
            }
            if (this.customizationModel != null) {
                CustomizationStage customizer = null;
                customizer = new CustomizationStage(this.device, this.customizationModel);
                customizer.setProgressHandler(this);
                customizer.setSkipPriPrlSet(this.doSkipModemFwUpdate);
                customizer.run();
            } else {
                this.flasherLogger.logPrintln("no customization");
                this.endJob("Customization");
            }
            if (this.doVerifyRomImage) {
                VerifyRomStage verifyBaseRom = new VerifyRomStage(this.device);
                verifyBaseRom.setProgressHandler(this);
                verifyBaseRom.run();
            }
            if (null != this.softwareUpdateSite && 0 != this.softwareUpdateSite.length() && null != this.softwareUpdateUrl && 0 != this.softwareUpdateUrl.length()) {
                SoftwareUpdateSiteStage swupdateStage = new SoftwareUpdateSiteStage(this.device, this.softwareUpdateSite, this.softwareUpdateUrl);
                swupdateStage.setProgressHandler(this);
                swupdateStage.run();
            }
            if (this.doSkipFirstUse) {
                BypassFirstUseStage bypassFirstUse = new BypassFirstUseStage(this.device);
                bypassFirstUse.setProgressHandler(this);
                bypassFirstUse.run();
            }
            if (null != this.developerMode && 0 != this.developerMode.length()) {
                EnableNovacomUsbByDefaultStage novacomEnableState = new EnableNovacomUsbByDefaultStage(this.device, this.developerMode);
                novacomEnableState.setProgressHandler(this);
                novacomEnableState.run();
            }
            if (!this.doSkipTouchpanelUpdate) {
                try {
                    TouchPanelUpdateStage tpupdate = new TouchPanelUpdateStage(this.device);
                    tpupdate.setForceUpdate(this.doForceTouchpanelUpdate);
                    tpupdate.setProgressHandler(this);
                    tpupdate.run();
                }
                catch (FileNotFoundException e) {
                    this.flasherLogger.logPrintln("*** No touchpanel firmware found in installer package, skipping update.");
                    this.endJob("Touch Panel Updater");
                }
            } else {
                this.flasherLogger.logPrintln("*** touchpanel, skipping update.");
            }
            if (null != this.postFlashScript && 0 != this.postFlashScript.length()) {
                this.runPostFlashScript();
            }
            this.flasherLogger.postFlashEvent(IFlasherLogger.FlashEvents.COMPLETED, null);
            try {
                INovacomStream stream = this.device.runProgram("/sbin/tellbootie", new String[]{"reboot"});
                stream.close();
            }
            catch (IOException e) {
            }
            catch (NovacomException e) {}
        }
        catch (IOException e) {
            this.flasherLogger.postFlashEvent(IFlasherLogger.FlashEvents.FAILED, e);
            e.printStackTrace();
        }
        catch (NovacomException e) {
            this.flasherLogger.postFlashEvent(IFlasherLogger.FlashEvents.FAILED, e);
            e.printStackTrace();
        }
    }

    private void runPostFlashScript() throws NovacomException, IOException {
        this.flasherLogger.logPrintln("Running Post Flash Script");
        INovacomStream output = this.device.putFile("/tmp/postflashscript.sh");
        FileInputStream fis = new FileInputStream(this.postFlashScript);
        DataInputStream scriptFileStream = new DataInputStream(fis);
        output.write(scriptFileStream);
        output.closeInput();
        output.closeOutput();
        output.waitForReturnCode();
        output.close();
        output = this.device.runProgram("/bin/sh", new String[]{"-c", "/tmp/postflashscript.sh"});
        output.waitForReturnCode();
        output.close();
    }

    private void rebootDeviceWithBootie() {
        try {
            INovacomStream stream = this.device.runProgram("/sbin/tellbootie", new String[]{"reboot"});
            stream.waitForReturnCode();
            stream.close();
        }
        catch (IOException e) {
        }
        catch (NovacomException novacomException) {
            // empty catch block
        }
        this.flasherLogger.logPrintln("Reboot call complete");
    }

    private void resetDevice() {
        try {
            INovacomStream stream = this.device.runProgram("", null);
            String command = "reset";
            byte[] bytes = command.getBytes("US-ASCII");
            stream.write(bytes);
            stream.closeOutput();
            String reply = stream.readLine();
            stream.close();
        }
        catch (IOException e) {
        }
        catch (NovacomException novacomException) {
            // empty catch block
        }
        this.flasherLogger.logPrintln("Reset call complete");
    }

    private String getToken(String token) throws IOException, NovacomException {
        String retString = null;
        StringBuffer script = new StringBuffer("#!/bin/sh\n/sbin/tokens --list | /bin/grep ");
        script.append(token);
        INovacomStream output = this.device.putFile("/tmp/get_token.sh");
        output.write(script.toString().getBytes("US-ASCII"));
        output.closeInput();
        output.closeOutput();
        output.waitForReturnCode();
        output.close();
        output = this.device.runProgram("/bin/sh", new String[]{"-c /tmp/get_token.sh"});
        String carrierInfo = output.readLine();
        carrierInfo = carrierInfo.replaceAll("['\"]", "");
        String[] tokens = carrierInfo.split(" ");
        retString = tokens[3] == null || tokens[3].length() == 0 ? "NOT_FOUND" : tokens[3];
        this.flasherLogger.logPrintln("token returned by get_token() is : " + retString);
        return retString;
    }

    @Override
    public Object startJob(String title, int increments) {
        this.flasherLogger.logPrintln("Starting: " + title);
        return title;
    }

    @Override
    public void updateJob(Object id, int progress) {
        System.out.println("update " + id + progress);
        if (id.equals("Modem Updater")) {
            int extra = progress * 20 / 100;
            this.flasherLogger.postFlashEvent(IFlasherLogger.FlashEvents.PERCENT_UPDATE, this.percentFlashedComplete + extra);
        } else if (id.equals("Loading Ramdisk")) {
            int extra = progress * 7 / 100;
            this.flasherLogger.postFlashEvent(IFlasherLogger.FlashEvents.PERCENT_UPDATE, this.percentFlashedComplete + extra);
        }
    }

    @Override
    public void commentOnJob(Object id, String comment) {
        if (comment.lastIndexOf(10) != -1) {
            this.flasherLogger.logPrint(id.toString() + ": " + comment);
        } else {
            this.flasherLogger.logPrintln(id.toString() + ": " + comment);
        }
        if (id.equals("Trenchcoat") && comment.startsWith("<INFO> ") && comment.endsWith(" percent complete\n")) {
            int start = "<INFO> ".length();
            int end = comment.indexOf(" ", start);
            String strPercent = comment.substring(start, end);
            try {
                int percent = new Integer(strPercent);
                int extra = percent * 40 / 100;
                this.flasherLogger.postFlashEvent(IFlasherLogger.FlashEvents.PERCENT_UPDATE, this.percentFlashedComplete + extra);
            }
            catch (NumberFormatException e) {
                this.flasherLogger.logPrintln("not a number");
            }
        }
    }

    @Override
    public void endJob(Object id) {
        if (id != null) {
            this.flasherLogger.logPrintln("Finished: " + id.toString());
            if (id.equals("Customization")) {
                this.percentFlashedComplete += 10;
            } else if (id.equals("Getting Into Update Mode")) {
                this.percentFlashedComplete += 2;
            } else if (id.equals("Modem Updater")) {
                this.percentFlashedComplete += 20;
            } else if (id.equals("Loading Ramdisk")) {
                this.percentFlashedComplete += 7;
            } else if (id.equals("Software Update Site Stage")) {
                this.percentFlashedComplete += 5;
            } else if (id.equals("Touch Panel Updater")) {
                this.percentFlashedComplete += 6;
            } else if (id.equals("Trenchcoat")) {
                this.percentFlashedComplete += 40;
            } else if (id.equals("ROM Verifyer")) {
                this.percentFlashedComplete += 5;
            } else if (!(id.equals("Battery Charger Stage") || id.equals("Bypass FirstUse") || id.equals("Novacom Enabler") || id.equals("AppDeletion"))) {
                this.flasherLogger.logPrintln("Unexpected stage ended " + id);
                return;
            }
        } else {
            this.flasherLogger.logPrintln("null stage id on endJob");
        }
        this.flasherLogger.postFlashEvent(IFlasherLogger.FlashEvents.PERCENT_UPDATE, this.percentFlashedComplete);
    }

    public void setScreenPicture(String picture) {
        this.screenPicture = picture;
    }

    public void setMainWindow(IFlasherLogger mainWindow) {
        this.flasherLogger = mainWindow;
    }

    public void setDevice(INovacomDevice device) {
        this.device = device;
    }

    public void setDeveloperMode(String devMode) {
        if (null != devMode && 0 != devMode.trim().length()) {
            this.developerMode = devMode.trim();
        }
    }

    public void setSoftwareUpdateSite(String site, String url) {
        if (null != site && 0 != site.trim().length()) {
            this.softwareUpdateSite = site.trim();
        }
        if (null != url && 0 != url.trim().length()) {
            this.softwareUpdateUrl = url.trim();
        }
    }

    public void setMassStorageData(String data) {
        if (null != data && 0 != data.trim().length()) {
            this.massStorageData = data.trim();
        }
    }

    public void doVerifyRom(boolean doVerifyRom) {
        this.doVerifyRomImage = doVerifyRom;
    }

    public void doSkipBatteryCheck(boolean doSkipBatteryCeck) {
        this.doSkipBatteryCeck = doSkipBatteryCeck;
    }

    public void doSkipFirstUse(boolean doSkipFirstUseSetting) {
        this.doSkipFirstUse = doSkipFirstUseSetting;
    }

    public void doForceModemUpdate(boolean doForceModemUpdate) {
        this.doForceModemFwUpdate = doForceModemUpdate;
    }

    public void setPostFlashScript(String postFlashScript) {
        if (null != postFlashScript && 0 != postFlashScript.trim().length()) {
            this.postFlashScript = postFlashScript.trim();
        }
    }

    public void doSaveMsmPartition(boolean doTryToSaveMsm) {
        this.doSaveMsm = doTryToSaveMsm;
    }

    public void doSkipModemUpdate(boolean doSkipModemUpdate) {
        this.doSkipModemFwUpdate = doSkipModemUpdate;
    }

    public void doSkipTouchpanelUpdate(boolean doSkipTouchpanelUpdate) {
        this.doSkipTouchpanelUpdate = doSkipTouchpanelUpdate;
    }

    public void doForceTouchpanelUpdate(boolean doForceTouchpanelUpdate) {
        this.doForceTouchpanelUpdate = doForceTouchpanelUpdate;
    }

    public void setCarrierList(String carrierList) {
        this.carrierList = carrierList;
    }

    public void setModelList(String modelList) {
        this.modelList = modelList;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public void setDelAppDir(boolean delAppDir) {
        this.doDeleteAppDirectory = delAppDir;
    }
}

