/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.core;

import com.palm.nova.installer.core.LoggerUtils;
import com.palm.nova.installer.core.MountUtils;
import com.palm.nova.installer.core.StringUtilities;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.Novacom;
import com.palm.novacom.NovacomException;
import java.io.IOException;
import java.net.ConnectException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DeviceInfo {
    private final INovacomDevice device;
    private final HashMap<String, String> buildInfo;
    private final HashMap<String, String> customizationInfo;
    private final HashMap<String, String> modemInfo;
    private final HashMap<String, String> touchPanelInfo;
    private String deviceName;
    private String serverSoftwareUpdateFile;
    private MountUtils mountUtils;
    private static final String TMP_ROOTFS = "/tmp_rootfs";
    private static final Logger logger = LoggerUtils.getInstance().getLogger("FlashingProgressCard");

    private void gatherPalmBuildInfo() throws IOException, NovacomException {
        String[] pairs;
        INovacomStream output;
        Novacom.DeviceState deviceState = this.device.getState();
        String rootFsPrepend = "";
        try {
            if (deviceState == Novacom.DeviceState.INSTALLER) {
                System.out.println("verified installer mode");
                this.mountUtils = new MountUtils(this.device);
                this.mountUtils.mount(MountUtils.MountParts.ROOTFS, MountUtils.FsType.EXT3, TMP_ROOTFS);
                rootFsPrepend = TMP_ROOTFS;
            }
        }
        catch (NovacomException e) {
            System.out.println("failed to mount rootfs from ramdisk, device probably has no root image");
            logger.log(Level.WARNING, "failed to mount rootfs from ramdisk", e);
            return;
        }
        try {
            output = this.device.getFile(rootFsPrepend + "/etc/palm-build-info");
        }
        catch (NovacomException e) {
            if (deviceState == Novacom.DeviceState.INSTALLER) {
                System.out.println("mount not complete wait and try 1 more time");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
                try {
                    output = this.device.getFile(rootFsPrepend + "/etc/palm-build-info");
                }
                catch (NovacomException e2) {
                    this.mountUtils.umount(MountUtils.MountParts.ROOTFS);
                    logger.log(Level.WARNING, "", e);
                    return;
                }
            }
            throw e;
        }
        String line = output.readLine();
        System.out.println(line);
        while (line.length() > 0) {
            pairs = line.split("=");
            this.buildInfo.put(StringUtilities.trim(pairs[0]), StringUtilities.trim(pairs[1]));
            line = output.readLine();
            System.err.println(line);
        }
        output.close();
        try {
            output = this.device.getFile(rootFsPrepend + "/etc/palm/palm-customization-info");
            line = output.readLine();
            while (line.length() > 0) {
                pairs = line.split("=");
                System.err.println("\"" + StringUtilities.trim(pairs[0]) + "\",\"" + StringUtilities.trim(pairs[1]) + "\"");
                this.customizationInfo.put(StringUtilities.trim(pairs[0]), StringUtilities.trim(pairs[1]));
                line = output.readLine();
            }
            output.close();
        }
        catch (NovacomException e) {
            logger.log(Level.WARNING, "palm-customization-info file not found, not expected if in ramdisk");
        }
        catch (ConnectException e) {
            logger.log(Level.WARNING, "palm-customization-info file not found, not expected if in ramdisk");
        }
        if (deviceState == Novacom.DeviceState.INSTALLER) {
            this.mountUtils.umount(MountUtils.MountParts.ROOTFS);
        }
    }

    private void gatherServerSoftwareUpdateFile() throws IOException {
        try {
            String line;
            INovacomStream output = this.device.runProgram("/bin/ls", new String[]{"-1 /usr/share/omadm/"});
            while (null != (line = output.readLine()) && 0 != line.length() && null == this.serverSoftwareUpdateFile) {
                if ("internal".equals(line = line.trim())) {
                    this.serverSoftwareUpdateFile = line;
                    continue;
                }
                if ("beta".equals(line)) {
                    this.serverSoftwareUpdateFile = line;
                    continue;
                }
                if ("carrier".equals(line)) {
                    this.serverSoftwareUpdateFile = line;
                    continue;
                }
                if (!"production".equals(line)) continue;
                this.serverSoftwareUpdateFile = line;
            }
        }
        catch (NovacomException e) {
            logger.log(Level.WARNING, "file not found", e);
        }
        catch (ConnectException e) {
            logger.log(Level.WARNING, "file not found", e);
        }
    }

    private void gatherModemInfo() throws IOException, NovacomException {
        INovacomStream stream;
        this.modemInfo.put("FW VERSION", "unknown");
        this.modemInfo.put("MODEM MODEL", "unknown");
        this.modemInfo.put("MEID", "unknown");
        try {
            stream = this.device.getFile("/usr/bin/pmmodempower");
            INovacomStream power = this.device.runProgram("/usr/bin/pmmodempower", new String[]{"cycle"});
            power.close();
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {}
        }
        catch (NovacomException e) {
            logger.log(Level.WARNING, "could not invoke pmmodempower, ok if running rockhopper");
            return;
        }
        try {
            stream = this.device.getFile("/usr/bin/PmModemInfo");
            INovacomStream output = this.device.runProgram("/usr/bin/PmModemInfo", new String[]{"-e"});
            String line = output.readLine();
            while (line.length() > 0) {
                if (line.charAt(0) == '$') {
                    System.err.print(line);
                    String nodollar = line.substring(1);
                    String[] pairs = nodollar.split("=");
                    if (pairs.length == 2) {
                        this.modemInfo.put(StringUtilities.trim(pairs[0]), StringUtilities.trim(pairs[1]));
                    } else {
                        this.modemInfo.put(StringUtilities.trim(nodollar), "");
                    }
                }
                line = output.readLine();
            }
        }
        catch (NovacomException e) {
            logger.log(Level.WARNING, "could not invoke PmModemInfo, ok if running rockhopper");
            return;
        }
    }

    private void gatherTouchPanelInfo() throws IOException, NovacomException {
        INovacomStream updaterOut = this.device.runProgram("/usr/bin/PmTpUpdater", new String[]{"-g"});
        String line = updaterOut.readLine();
        updaterOut.close();
        if (line.startsWith("Can't open touch panel drive.")) {
            int lengthOfHeader = 74;
            INovacomStream lunaSendOut = this.device.runProgram("/usr/bin/luna-send", new String[]{"-n 1 palm://com.palm.hidd/HidTouchpanel/FirmwareVersion {\"mode\":\"get\"}"});
            line = lunaSendOut.readLine();
            if (line.length() > 81) {
                line = line.substring(lengthOfHeader, lengthOfHeader + 6);
            } else {
                line = "error";
                logger.log(Level.WARNING, "TouchPanel FW version couldn't be read:" + line);
            }
        } else if (line.startsWith("Touchpanel firmware version is ")) {
            int startIndex = "Touchpanel firmware version is ".length();
            line = "0x" + line.substring(startIndex, startIndex + 4).toUpperCase();
        } else {
            int startIndex = line.indexOf("0x");
            if (-1 != startIndex) {
                line = line.substring(startIndex);
            } else if (4 == line.trim().length()) {
                line = "0x" + line;
            } else {
                line = "error";
                logger.log(Level.WARNING, "TouchPanel FW version couldn't be read:" + line);
            }
        }
        this.touchPanelInfo.put("fwversion", line);
    }

    private void gatherDeviceName() throws NovacomException, IOException {
        try {
            StringBuffer script = new StringBuffer("#!/bin/sh\n/bin/cat /proc/cmdline | /usr/bin/awk ");
            script.append("'{for(i=1;i<=NF;i++){if($i ~ /boardtype/){print substr($i,11)}}}'");
            script.append("\nexit 0\n");
            INovacomStream output = this.device.putFile("/tmp/getboardtype.sh");
            output.write(script.toString().getBytes("US-ASCII"));
            output.closeInput();
            output.closeOutput();
            output.waitForReturnCode();
            output.close();
            output = this.device.runProgram("/bin/sh", new String[]{"-c /tmp/getboardtype.sh"});
            this.deviceName = StringUtilities.trim(output.readLine());
            output.close();
        }
        catch (NovacomException e) {
            logger.log(Level.WARNING, "novacom exception", e);
        }
        catch (ConnectException e) {
            logger.log(Level.WARNING, "connection exception", e);
        }
    }

    public DeviceInfo(INovacomDevice device) throws IOException, NovacomException {
        this.device = device;
        this.buildInfo = new HashMap();
        this.customizationInfo = new HashMap();
        this.modemInfo = new HashMap();
        this.touchPanelInfo = new HashMap();
        this.refreshValues();
    }

    public void refreshValues() throws IOException, NovacomException, ConnectException {
        if (this.device.isConnected()) {
            this.gatherPalmBuildInfo();
            this.gatherModemInfo();
            this.gatherTouchPanelInfo();
            this.gatherDeviceName();
            this.gatherServerSoftwareUpdateFile();
        }
    }

    public String getDeviceName() throws IOException, NovacomException {
        return this.deviceName;
    }

    public String getDeviceType() throws IOException, NovacomException {
        return this.deviceName;
    }

    public String getCarrierName() {
        return this.customizationInfo.get("CUSTOMIZATION");
    }

    public String getProductVersion() {
        return this.buildInfo.get("PRODUCT_VERSION_STRING");
    }

    public String getOSVersion() {
        return "0.9";
    }

    public String getBuildName() {
        return this.buildInfo.get("BUILDNAME");
    }

    public String getBuildVersion() {
        return this.buildInfo.get("BUILDNUMBER");
    }

    public String getCustomizationVariant() {
        return this.customizationInfo.get("CUSTOMIZATION");
    }

    public String getCustomizationVersion() {
        return this.customizationInfo.get("BUILDNUMBER");
    }

    public boolean hasAModem() {
        return true;
    }

    public String getTouchPanelFwVersion() {
        return this.touchPanelInfo.get("fwversion");
    }

    public String getModemFwVersion() {
        return this.modemInfo.get("FW VERSION");
    }

    public String getModemType() {
        return this.modemInfo.get("MODEM MODEL");
    }

    public String getSwUpdateServerFile() {
        return this.serverSoftwareUpdateFile;
    }

    public String getModemMeidOrImei() {
        String modemId = "Unknown";
        if ("CDMA".equals(this.getModemType())) {
            modemId = this.modemInfo.get("MEID");
        } else if ("UMTS".equals(this.getModemType())) {
            modemId = this.modemInfo.get("IMEI");
        }
        return modemId;
    }

    public int getBatteryPercentage() throws IOException, NovacomException {
        String strPercent;
        int percentage = -1;
        INovacomStream lunaSendOut = this.device.runProgram("/bin/cat", new String[]{"/sys/devices/w1_bus_master1/w1_master_slaves"});
        String id = lunaSendOut.readLine();
        System.out.println("id for battery check is : " + id);
        id = id.trim();
        if (id != null && id.length() > 0) {
            lunaSendOut = this.device.runProgram("/bin/cat", new String[]{"/sys/devices/w1_bus_master1/" + id + "/getpercent"});
            strPercent = lunaSendOut.readLine();
            System.out.println("string returned for percent is : " + strPercent);
            if (strPercent == null || strPercent.length() <= 0) {
                throw new NovacomException(-1, "invalid percent reurned");
            }
        } else {
            throw new NovacomException(-1, "could not read ID");
        }
        strPercent = strPercent.trim();
        percentage = new Integer(strPercent);
        return percentage;
    }

    public String getBuildNumber() {
        return this.buildInfo.get("BUILDNUMBER");
    }
}

