/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.core.stages;

import com.palm.nova.installer.core.DeviceInfo;
import com.palm.nova.installer.core.IInstallerStage;
import com.palm.nova.installer.core.IStageProgressReporter;
import com.palm.nova.installer.core.InstallerModel;
import com.palm.nova.installer.core.ModemUtilities;
import com.palm.nova.installer.core.stages.BaseStage;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.NovacomException;
import java.io.IOException;
import java.io.InputStream;

public class ModemUpdateStage
extends BaseStage
implements IInstallerStage {
    public static final String MODEM_UPDATER = "/usr/bin/PmModemUpdater";
    public static final String MODEM_POWER = "/usr/bin/pmmodempower";
    private final InstallerModel model;
    private final INovacomDevice device;
    private boolean forceUpdate = false;
    private ModemUtilities modemUtils;
    private static final int GATHER_DEVICE_DETAILS = 10;
    private static final int MODEM_UTILS = 5;
    private static final int GET_FIRMWARE = 5;
    private static final int START_MODEM_UPDATER = 10;
    private static final int PUSH_FIRMWARE_TO_DEVICE = 30;
    private int currentPercentage = 0;

    public ModemUpdateStage(InstallerModel model, INovacomDevice device) throws IOException, NovacomException {
        this.model = model;
        this.device = device;
    }

    public void setForceUpdate(boolean state) {
        this.forceUpdate = state;
    }

    public String toString() {
        return "Modem Updater";
    }

    private void updatePercentage(IStageProgressReporter progress, Object jobId, int add) {
        this.currentPercentage += add;
        progress.updateJob(jobId, this.currentPercentage);
    }

    public void run() throws IOException, NovacomException {
        IStageProgressReporter progress = this.getProgressHandler();
        Object jobId = progress.startJob("Modem Updater", 100);
        progress.commentOnJob(jobId, "Modem Update Started");
        progress.commentOnJob(jobId, "Gathering device details...");
        DeviceInfo devinfo = new DeviceInfo(this.device);
        if (!devinfo.hasAModem()) {
            progress.commentOnJob(jobId, "This device does not have a modem!");
            throw new NovacomException(-1, "No Modem For This Device");
        }
        this.updatePercentage(progress, jobId, 10);
        this.modemUtils = new ModemUtilities(this.device);
        this.updatePercentage(progress, jobId, 5);
        InputStream firmware = this.model.getModemUpdaterFileStream(this.modemUtils.getModemType());
        this.updatePercentage(progress, jobId, 5);
        if (firmware == null) {
            progress.commentOnJob(jobId, "ERROR: Unable to get firmware for modem type " + this.modemUtils.getModemType() + ", cannot flash modem.");
            return;
        }
        String[] args = new String[]{"-o"};
        if (this.forceUpdate) {
            progress.commentOnJob(jobId, "Forcing modem update, no matter the version.");
            args = new String[]{"-o", "-f"};
        }
        INovacomStream stream = this.device.runProgram(MODEM_UPDATER, args);
        this.updatePercentage(progress, jobId, 10);
        BaseStage.StreamReaderThread thread = new BaseStage.StreamReaderThread(this, stream, jobId, "$ Your device is ready for use");
        thread.start();
        progress.commentOnJob(jobId, "Modem Type: " + this.modemUtils.getModemType());
        progress.commentOnJob(jobId, "Pushing Firmware to Modem Updater");
        stream.write(firmware);
        stream.closeOutput();
        this.updatePercentage(progress, jobId, 30);
        try {
            progress.commentOnJob(jobId, "Waiting....");
            thread.join();
            progress.commentOnJob(jobId, "Finished!");
            if (!thread.didWeFindTheStringWeWereLookingFor()) {
                throw new NovacomException(-1, "Error Updating Modem Firmware!!!");
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Reader thread never completed.");
        }
        stream.close();
        progress.endJob(jobId);
    }
}

