/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.core.stages;

import com.palm.nova.installer.core.IInstallerStage;
import com.palm.nova.installer.core.IStageProgressReporter;
import com.palm.nova.installer.core.stages.BaseStage;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.NovacomException;
import java.io.IOException;

public class TouchPanelUpdateStage
extends BaseStage
implements IInstallerStage {
    private static final String UPDATE_CMD = "/usr/bin/PmTpUpdater";
    private static final String RUNNER_NAME = "Touch Panel Updater";
    private final INovacomDevice device;
    private Object jobId;
    private boolean forceUpdate;

    public TouchPanelUpdateStage(INovacomDevice device) {
        this.device = device;
    }

    public void setForceUpdate(boolean forceUpdate) {
        this.forceUpdate = forceUpdate;
    }

    public String toString() {
        return RUNNER_NAME;
    }

    public void run() throws IOException, NovacomException {
        IStageProgressReporter reporter = this.getProgressHandler();
        this.jobId = reporter.startJob(RUNNER_NAME, 100);
        reporter.commentOnJob(this.jobId, "Updating the touch panel firmware");
        INovacomStream stream = this.forceUpdate ? this.device.runProgram(UPDATE_CMD, new String[]{"-a -f"}) : this.device.runProgram(UPDATE_CMD, new String[]{"--auto-update"});
        stream.flush();
        String line = stream.readLine();
        while (line.compareTo("") != 0) {
            this.getProgressHandler().commentOnJob(this.jobId, line);
            line = stream.readLine();
        }
        stream.flush();
        stream.close();
        reporter.commentOnJob(this.jobId, "Done updating the touch panel firmware");
        reporter.endJob(this.jobId);
    }
}

