/*
 * Decompiled with CFR 0.152.
 */
package com.palm.novacom.internal;

import com.palm.novacom.INovacomController;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.NovaDeviceInfo;
import com.palm.novacom.Novacom;
import com.palm.novacom.NovacomException;
import com.palm.novacom.internal.NovacomSocketStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class NovacomDevice
implements INovacomDevice {
    private static final String ENCODING = "US-ASCII";
    private final String host;
    NovaDeviceInfo devInfo;

    NovacomDevice(String host, NovaDeviceInfo devInfo) {
        this.host = host;
        this.devInfo = devInfo;
    }

    public void close() {
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.devInfo.getPort();
    }

    public NovaDeviceInfo getDeviceInfo() {
        return this.devInfo;
    }

    private void handleReply(Socket socket) throws NovacomException, IOException {
        int length;
        InputStream input = socket.getInputStream();
        byte[] reply = new byte[1024];
        for (length = 0; length < reply.length; ++length) {
            int c = input.read();
            if (c == -1) {
                throw new NovacomException(-2, "No data to read from socket");
            }
            reply[length] = (byte)c;
            if (c != 10) continue;
        }
        if (reply[0] == 111 && reply[1] == 107) {
            return;
        }
        throw new NovacomException(-99, new String(reply, 0, length - 1, ENCODING));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    INovacomStream issueCommand(String verb, String scheme, String[] args) throws NovacomException, IOException {
        Socket socket;
        StringBuffer cmd;
        StringBuffer stringBuffer = cmd = new StringBuffer(verb);
        synchronized (stringBuffer) {
            cmd.append(" ");
            cmd.append(scheme);
            for (int i = 0; args != null && i < args.length; ++i) {
                cmd.append(" ");
                cmd.append(args[i]);
            }
            cmd.append("\n");
        }
        try {
            socket = new Socket(this.host, this.devInfo.getPort());
            OutputStream output = socket.getOutputStream();
            output.write(cmd.toString().getBytes(ENCODING));
        }
        catch (IOException e) {
            if (!this.isConnected()) {
                NovacomException e2 = new NovacomException(-107, "Device has been disconnected. Command: " + cmd.toString());
                e2.setStackTrace(e.getStackTrace());
                throw e2;
            }
            throw e;
        }
        try {
            this.handleReply(socket);
        }
        catch (NovacomException e) {
            NovacomException e2 = new NovacomException(-99, "Command: " + cmd.toString() + " Reply:" + e.getMessage());
            e2.setStackTrace(e.getStackTrace());
            throw e2;
        }
        return new NovacomSocketStream(socket, scheme);
    }

    public INovacomStream getFile(String path) throws NovacomException, IOException {
        return this.issueCommand("get", "file://" + path, null);
    }

    public INovacomStream putFile(String path) throws NovacomException, IOException {
        return this.issueCommand("put", "file://" + path, null);
    }

    public INovacomStream openTerminal(int tty) throws NovacomException, IOException {
        return this.issueCommand("open", "tty://" + tty, null);
    }

    public INovacomStream runProgram(String path, String[] args) throws NovacomException, IOException {
        return this.issueCommand("run", "file://" + path, args);
    }

    public INovacomStream putInMemory(long address, boolean boot) throws NovacomException, IOException {
        return this.putInMemory(Long.toString(address, 16), boot);
    }

    public INovacomStream putInMemory(String address, boolean boot) throws NovacomException, IOException {
        String cmd = "put";
        if (boot) {
            cmd = "boot";
        }
        return this.issueCommand(cmd, "mem://" + address, null);
    }

    public Novacom.DeviceState getState() throws IOException {
        try {
            INovacomStream stream = this.getFile("/proc/mounts");
            stream = this.getFile("/proc/cmdline");
            String cmdline = stream.readLine();
            if (cmdline.indexOf("ram0") > 0) {
                stream.close();
                return Novacom.DeviceState.INSTALLER;
            }
            stream.close();
            return Novacom.DeviceState.OS;
        }
        catch (NovacomException e) {
            return Novacom.DeviceState.BOOTLOADER;
        }
    }

    public void killConnection() throws IOException, NovacomException {
        Novacom.DeviceState deviceState = this.getState();
        if (deviceState == Novacom.DeviceState.OS || deviceState == Novacom.DeviceState.INSTALLER) {
            try {
                String[] args = new String[]{"-15", "novacomd"};
                this.runProgram("/usr/bin/killall", args);
            }
            catch (NovacomException e) {
                if (e.getErrorCode() != -2) {
                    throw e;
                }
                return;
            }
        } else {
            throw new NovacomException(-1, "Cannot kill connection in anything but OS mode.");
        }
    }

    public void waitForDeviceToAppear() throws IOException, NovacomException {
        this.waitForDeviceToAppear(180000L);
    }

    public void waitForDeviceToAppear(long timeout) throws IOException, NovacomException {
        INovacomDevice newdev = null;
        INovacomController controller = Novacom.getController(this.host, 6968);
        long timeToTimeoutOn = System.currentTimeMillis() + timeout;
        do {
            NovaDeviceInfo[] devices = controller.getDeviceList();
            for (int i = 0; i < devices.length; ++i) {
                if (devices[i].getUIDString().compareTo(this.devInfo.getUIDString()) != 0 || devices[i].getPort() == this.devInfo.getPort()) continue;
                newdev = controller.connectToDevice(devices[i]);
                break;
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (timeToTimeoutOn >= System.currentTimeMillis()) continue;
            throw new NovacomException(-1, "Timeout waiting for device to appear");
        } while (newdev == null);
        this.devInfo = newdev.getDeviceInfo();
    }

    public boolean isConnected() throws IOException, NovacomException {
        boolean devConnected = false;
        INovacomController controller = Novacom.getController(this.host, 6968);
        NovaDeviceInfo[] devices = controller.getDeviceList();
        for (int i = 0; i < devices.length; ++i) {
            if (devices[i].getUIDString().compareTo(this.devInfo.getUIDString()) != 0 || devices[i].getPort() != this.devInfo.getPort()) continue;
            devConnected = true;
            break;
        }
        return devConnected;
    }
}

