/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.recoverytool;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigFileMgr {
    private static final Logger logger = Logger.getLogger("com.palm.recoverytool");
    static Properties configProperties = new Properties();
    private String baseBuild = null;
    private String customizationBuild = null;
    private String prevBaseBuild = null;
    private String prevCustomizationBuild = null;
    private String softwareUpdateSite = null;
    private Boolean doForceModemUpdate = true;
    private String phoenixRecoveryToolBuildVersion = null;
    private String phoenixRecoveryToolBuildTime = null;
    private String phoenixROMBuildVersion = null;
    private String approvalReleaseHash = null;
    private String approvalCharlieHash = null;
    private String approvalMikeHash = null;
    private String deviceType = null;
    private String approvalBuildName = null;
    private Boolean checkCloudApi = false;
    private static final ConfigFileMgr instance = new ConfigFileMgr();

    public static ConfigFileMgr getInstance() {
        return instance;
    }

    private ConfigFileMgr() {
        try {
            this.loadConfiguration();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.log(Level.WARNING, "", e);
        }
    }

    public String getBaseBuildFilename() {
        return this.baseBuild;
    }

    public String getPrevBaseBuildFilename() {
        return this.prevBaseBuild;
    }

    public String getCustomizationFileName() {
        return this.customizationBuild;
    }

    public String getPrevCustomizationFileName() {
        return this.prevCustomizationBuild;
    }

    public String getSoftwareUpdateSite() {
        return this.softwareUpdateSite;
    }

    public String getPhoenixBuildVersion() {
        String buildVersion = this.phoenixRecoveryToolBuildVersion + "." + this.phoenixROMBuildVersion + " " + this.phoenixRecoveryToolBuildTime;
        if (null != this.customizationBuild && 0 != this.customizationBuild.length() && !this.customizationBuild.startsWith("wr")) {
            String carrier = this.customizationBuild.trim().split("\\.")[0];
            buildVersion = Character.toUpperCase(carrier.charAt(0)) + carrier.substring(1) + "." + buildVersion;
        }
        return buildVersion;
    }

    public String getApprovalReleaseHash() {
        return this.approvalReleaseHash;
    }

    public String getApprovalCharlieHash() {
        return this.approvalCharlieHash;
    }

    public String getApprovalMikeHash() {
        return this.approvalMikeHash;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public String getBuildNumber() {
        return this.phoenixROMBuildVersion;
    }

    public String getApprovalBuildName() {
        return this.approvalBuildName;
    }

    public Boolean doForceModemUpdate() {
        return this.doForceModemUpdate;
    }

    public Boolean doCloudCheck() {
        return this.checkCloudApi;
    }

    void loadConfiguration() throws FileNotFoundException, IOException {
        String configFileName = "/resources/recoverytool.config";
        InputStream inStream = ConfigFileMgr.class.getResourceAsStream(configFileName);
        if (inStream != null) {
            configProperties.load(inStream);
            inStream.close();
        } else {
            URL homeFolder = ConfigFileMgr.class.getProtectionDomain().getCodeSource().getLocation();
            File jarFile = new File(homeFolder.getFile());
            if (jarFile.isDirectory()) {
                logger.warning("not running from jar");
                throw new FileNotFoundException("Failed To Load Config File");
            }
            File configFile = new File(jarFile.getParent() + configFileName);
            FileInputStream fileInStream = new FileInputStream(configFile);
            configProperties.load(fileInStream);
            fileInStream.close();
        }
        this.baseBuild = configProperties.getProperty("BaseBuild");
        this.customizationBuild = configProperties.getProperty("CustomizationBuild");
        logger.info("baseBuild " + this.baseBuild);
        logger.info("customizationBuild " + this.customizationBuild);
        this.prevBaseBuild = configProperties.getProperty("PrevPayloadBaseBuild");
        this.prevCustomizationBuild = configProperties.getProperty("PrevPayloadCustomizationBuild");
        logger.info("prevBaseBuild " + this.prevBaseBuild);
        logger.info("prevCustomizationBuild " + this.prevCustomizationBuild);
        this.softwareUpdateSite = configProperties.getProperty("SoftwareUpdateSite");
        if (null == this.softwareUpdateSite || 0 == this.softwareUpdateSite.length()) {
            this.softwareUpdateSite = null;
        }
        this.approvalReleaseHash = configProperties.getProperty("ApprovalReleaseHash");
        if (null == this.approvalReleaseHash || 0 == this.approvalReleaseHash.length()) {
            this.approvalReleaseHash = null;
        }
        this.approvalCharlieHash = configProperties.getProperty("ApprovalCharlieHash");
        if (null == this.approvalCharlieHash || 0 == this.approvalCharlieHash.length()) {
            this.approvalCharlieHash = null;
        }
        this.approvalMikeHash = configProperties.getProperty("ApprovalMikeHash");
        if (null == this.approvalMikeHash || 0 == this.approvalMikeHash.length()) {
            this.approvalMikeHash = null;
        }
        this.deviceType = configProperties.getProperty("DeviceType");
        if (null == this.deviceType || 0 == this.deviceType.length()) {
            this.deviceType = null;
        }
        this.approvalBuildName = configProperties.getProperty("ApprovalBuildName");
        if (null == this.approvalBuildName || 0 == this.approvalBuildName.length()) {
            this.approvalBuildName = null;
        }
        if (null != configProperties.getProperty("ForceModemUpdate")) {
            this.doForceModemUpdate = Boolean.valueOf(configProperties.getProperty("ForceModemUpdate"));
        }
        if (null != configProperties.getProperty("ApprovalCC")) {
            this.checkCloudApi = Boolean.valueOf(configProperties.getProperty("ApprovalCC"));
        }
        this.phoenixRecoveryToolBuildVersion = configProperties.getProperty("RecoveryToolBuildNumber");
        if (null == this.phoenixRecoveryToolBuildVersion || 0 == this.phoenixRecoveryToolBuildVersion.length()) {
            this.phoenixRecoveryToolBuildVersion = "Custom";
        }
        this.phoenixROMBuildVersion = configProperties.getProperty("RomBuildNumber");
        if (null == this.phoenixROMBuildVersion || 0 == this.phoenixROMBuildVersion.length()) {
            this.phoenixROMBuildVersion = "Unknown";
        }
        this.phoenixRecoveryToolBuildTime = configProperties.getProperty("RecoveryToolBuildTime");
        if (null == this.phoenixRecoveryToolBuildTime || 0 == this.phoenixRecoveryToolBuildTime.length()) {
            this.phoenixRecoveryToolBuildTime = "Unknown";
        }
        Enumeration<?> e = configProperties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = configProperties.getProperty(key);
            logger.info(key + ": " + value);
        }
    }
}

