/*
 * Decompiled with CFR 0.152.
 */
package com.palm.novacom.tests;

import com.palm.novacom.INovacomController;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.NovaDeviceInfo;
import com.palm.novacom.Novacom;
import com.palm.novacom.NovacomException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class CommandCycle {
    private static final String localFileName = "/tmp/image.cmp";
    private static final String deviceFileName = "/tmp/image.dat";
    private static final String RMFILE = "/bin/rm";
    private String fileImage = "/tmp/image.dat";
    private int cycleCount = 1000;
    private int loopCount = 100;
    private INovacomDevice device;

    public static void main(String[] args) {
        System.err.println("Novacom Command Cycle Tests");
        CommandCycle cycle = new CommandCycle();
        cycle.CommandCycler();
    }

    public void CommandCycler() {
        try {
            INovacomController controller = Novacom.getController();
            NovaDeviceInfo[] devices = controller.getDeviceList();
            int i = 0;
            while (i < devices.length) {
                System.err.println(devices[i].toString());
                ++i;
            }
            if (devices.length <= 0) {
                System.err.println("No Devices, No Tests.");
                return;
            }
            this.device = controller.connectToDevice(devices[0]);
            if (this.device.getState() != Novacom.DeviceState.OS) {
                System.err.println("Requires OS mode");
                return;
            }
            i = 0;
            while (i < this.cycleCount) {
                System.out.println("-------------------------------------------");
                System.out.println("sequence " + (i + 1));
                System.out.println("-------------------------------------------");
                this.CommandSequence();
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NovacomException e) {
            e.printStackTrace();
        }
    }

    private void CommandSequence() throws IOException, NovacomException {
        File localFile = new File(localFileName);
        System.out.println("Put file test");
        int i = 0;
        while (i < this.loopCount) {
            this.runProgram(RMFILE, new String[]{deviceFileName});
            this.putFile(this.fileImage, deviceFileName);
            System.out.print(".");
            ++i;
        }
        System.out.println("");
        System.out.println("Get file test");
        i = 0;
        while (i < this.loopCount) {
            this.getFile(localFileName, deviceFileName);
            localFile.delete();
            System.out.print(".");
            ++i;
        }
        System.out.println("");
        System.out.println("Run test");
        i = 0;
        while (i < this.loopCount) {
            INovacomStream output = this.device.runProgram("/bin/ls", new String[]{"-l /bin"});
            String line = null;
            while ((line = output.readLine()) != null && line.length() != 0) {
            }
            output.close();
            System.out.print(".");
            ++i;
        }
        System.out.println("");
        System.out.println("Put/Get/Compare test");
        i = 0;
        while (i < this.loopCount) {
            this.runProgram(RMFILE, new String[]{deviceFileName});
            this.putFile(this.fileImage, deviceFileName);
            this.getFile(localFileName, deviceFileName);
            this.compareFiles(this.fileImage, localFileName);
            localFile.delete();
            System.out.print(".");
            ++i;
        }
        System.out.println("");
    }

    private boolean compareFiles(String inFile1, String inFile2) throws IOException {
        int b2;
        int b1;
        File file1 = new File(inFile1);
        File file2 = new File(inFile2);
        if (file1.length() != file2.length()) {
            return false;
        }
        FileInputStream fileInputStream1 = new FileInputStream(file1);
        FileInputStream fileInputStream2 = new FileInputStream(file2);
        BufferedInputStream fileBuffStream1 = new BufferedInputStream(fileInputStream1);
        BufferedInputStream fileBuffStream2 = new BufferedInputStream(fileInputStream2);
        while ((b1 = fileBuffStream1.read()) == (b2 = fileBuffStream2.read()) && b1 != -1 && b2 != -1) {
        }
        fileBuffStream1.close();
        fileBuffStream2.close();
        fileInputStream1.close();
        fileInputStream2.close();
        return b1 == -1 && b2 == -1;
    }

    private void putFile(String fileName, String filePathOnDevice) throws IOException, NovacomException {
        FileInputStream fileStream = new FileInputStream(fileName);
        INovacomStream deviceStream = this.device.putFile(filePathOnDevice);
        deviceStream.write(fileStream);
        deviceStream.closeOutput();
        deviceStream.waitForReturnCode();
        deviceStream.close();
        fileStream.close();
    }

    private void getFile(String fileName, String filePathOnDevice) throws IOException, NovacomException {
        int count;
        FileOutputStream fileStream = new FileOutputStream(fileName);
        INovacomStream deviceStream = this.device.getFile(filePathOnDevice);
        byte[] buffer = new byte[0x100000];
        long total = 0L;
        while ((count = deviceStream.read(buffer)) != -1) {
            fileStream.write(buffer, 0, count);
            total += (long)count;
            if (count >= buffer.length) continue;
        }
        fileStream.close();
        deviceStream.close();
    }

    private void runProgram(String path, String[] args) throws IOException, NovacomException {
        INovacomStream deviceStream = this.device.runProgram(path, args);
        deviceStream.waitForReturnCode();
    }
}

