/*
 * Decompiled with CFR 0.152.
 */
package com.palm.webos.devicetool;

import com.palm.novacom.INovacomController;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.NovaDeviceInfo;
import com.palm.novacom.Novacom;
import com.palm.novacom.NovacomException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;

public class DeviceTool {
    private static final int COPY_BUFFER_SIZE = 65536;
    private static final int BOOT_TIMEOUT = 240000;
    private static final String LVM_STATIC = "/usr/sbin/lvm.static";
    private static final String MKDIR = "/bin/mkdir";
    private static final String MOUNT = "/bin/mount";
    private static final String UMOUNT = "/bin/umount";
    private static final String TOUCH = "/bin/touch";
    private static final String SYNC = "/bin/sync";
    private static final String SLEEP = "/bin/sleep";
    private static final String RM = "/bin/rm";
    private static final String TELLBOOTIE = "/sbin/tellbootie";

    public static void main(String[] args) {
        DeviceTool app = new DeviceTool();
        app.run();
    }

    public void run() {
        boolean novacomEnabled = true;
        boolean firstUseRan = true;
        boolean loadRamDisk = true;
        try {
            INovacomController controller = Novacom.getController();
            NovaDeviceInfo[] infos = controller.getDeviceListOnUsb();
            if (infos.length == 0) {
                this.error("No devices found.");
                this.message("");
                this.showInstructions();
                return;
            }
            NovaDeviceInfo foundInfo = null;
            NovaDeviceInfo[] novaDeviceInfoArray = infos;
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                NovaDeviceInfo info = novaDeviceInfoArray[n2];
                String name = info.getName();
                if (name.endsWith("-bootie")) {
                    this.message("Found device: " + name);
                    foundInfo = info;
                    break;
                }
                ++n2;
            }
            if (foundInfo == null) {
                foundInfo = infos[0];
            }
            INovacomDevice device = controller.connectToDevice(foundInfo);
            if (loadRamDisk) {
                if (device.getState() != Novacom.DeviceState.BOOTLOADER) {
                    this.error("Device must be in recovery mode.");
                    this.message("");
                    this.showInstructions();
                    return;
                }
                InputStream imageInput = this.getRamDiskImage(device);
                try {
                    this.bootRamDisk(device, imageInput);
                }
                finally {
                    if (imageInput != null) {
                        try {
                            imageInput.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                device.waitForDeviceToAppear(240000L);
            }
            this.message("Configuring device...");
            try {
                this.mountVar(device);
                this.setNovacomEnabled(device, novacomEnabled);
                this.setRanFirstUse(device, firstUseRan);
            }
            finally {
                this.unmountVar(device);
            }
            this.rebootDevice(device);
            device.waitForDeviceToAppear(240000L);
            this.message("Device is ready.");
        }
        catch (IOException e) {
            this.error("Error: " + e.getMessage());
        }
        catch (NovacomException e) {
            this.error("Error: " + e.getMessage());
        }
    }

    private void showInstructions() {
        this.message("To enter recovery mode:");
        this.message("1. Remove the battery and disconnect the USB cable from the device.");
        this.message("2. While holding the 'volume up' button, attach the USB cable to the device.");
        this.message("3. Continue to hold the 'volume up' button and insert the battery.");
        this.message("4. You should see a USB symbol on the screen. If not, repeat steps 1-3.");
    }

    private void message(String message) {
        System.out.println(message);
    }

    private void error(String message) {
        System.err.println(message);
    }

    private void bootRamDisk(INovacomDevice device, InputStream input) throws IOException, NovacomException {
        byte[] buffer = new byte[65536];
        INovacomStream stream = device.putInMemory("", true);
        System.out.print("Copying ram disk...");
        try {
            int count = 0;
            int totalSize = 0;
            int dots = 0;
            while ((count = input.read(buffer)) != -1) {
                stream.write(buffer, 0, count);
                int chunks = (totalSize += count) / 1024000;
                while (chunks > dots) {
                    System.out.print(".");
                    ++dots;
                }
            }
            System.out.println();
            stream.closeOutput();
            this.message("Rebooting device...");
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void mountVar(INovacomDevice device) throws IOException, NovacomException {
        this.runCommand(device, LVM_STATIC, "vgscan");
        this.runCommand(device, LVM_STATIC, "vgchange", "-ay");
        this.runCommand(device, MKDIR, "-p", "/tmp/var");
        this.runCommand(device, MOUNT, "/dev/store/var", "/tmp/var");
    }

    private void setNovacomEnabled(INovacomDevice device, boolean enabled) throws IOException, NovacomException {
        if (enabled) {
            this.runCommand(device, MKDIR, "-p", "/tmp/var/gadget");
            this.runCommand(device, TOUCH, "/tmp/var/gadget/novacom_enabled");
        } else {
            this.runCommand(device, RM, "-f", "/tmp/var/gadget/novacom_enabled");
        }
    }

    private void setRanFirstUse(INovacomDevice device, boolean ran) throws IOException, NovacomException {
        if (ran) {
            this.runCommand(device, MKDIR, "-p", "/tmp/var/luna/preferences");
            this.runCommand(device, TOUCH, "/tmp/var/luna/preferences/ran-first-use");
        } else {
            this.runCommand(device, RM, "-f", "/tmp/var/luna/preferences/ran-first-use");
        }
    }

    private void unmountVar(INovacomDevice device) throws IOException, NovacomException {
        this.runCommand(device, SYNC);
        this.runCommand(device, SYNC);
        this.runCommand(device, SYNC);
        this.runCommand(device, UMOUNT, "/tmp/var");
        this.runCommand(device, LVM_STATIC, "vgchange", "-an");
        this.runCommand(device, SLEEP, "2");
    }

    private void rebootDevice(INovacomDevice device) throws IOException, NovacomException {
        block17: {
            this.message("Rebooting device...");
            INovacomStream stream = null;
            try {
                try {
                    stream = device.runProgram(TELLBOOTIE, new String[]{"reboot"});
                    while (stream.read() > 0) {
                        this.message("waiting to reboot...");
                    }
                }
                catch (IOException iOException) {
                    if (stream == null) break block17;
                    try {
                        stream.close();
                    }
                    catch (IOException iOException2) {
                    }
                }
                catch (NovacomException novacomException) {
                    if (stream == null) break block17;
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void runCommand(INovacomDevice device, String ... commandArgs) throws IOException, NovacomException {
        INovacomStream stream = null;
        try {
            int ch;
            ArrayList<String> args = new ArrayList<String>(Arrays.asList(commandArgs));
            String command = args.get(0);
            args.remove(0);
            stream = device.runProgram(command, args.toArray(new String[args.size()]));
            stream.flush();
            StringBuilder buf = new StringBuilder();
            while ((ch = stream.read()) != -1) {
                if (ch == 10) {
                    if (buf.length() <= 0) continue;
                    this.message(buf.toString());
                    buf.setLength(0);
                    continue;
                }
                buf.append((char)ch);
            }
            if (buf.length() > 0) {
                this.message(buf.toString());
            }
            stream.flush();
            int rc = stream.waitForReturnCode();
            if (rc != 0) {
                throw new IOException("command failed with error " + rc);
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private InputStream getRamDiskImage(INovacomDevice device) throws IOException {
        return this.getResourceAsStream("images/nova-installer-image-" + this.getNamePrefix(device) + ".uImage");
    }

    private String getNamePrefix(INovacomDevice device) throws IOException {
        String name = device.getDeviceInfo().getName();
        if (name.endsWith("-bootie")) {
            name = name.substring(0, name.length() - 7);
        } else if (name.endsWith("-linux")) {
            name = name.substring(0, name.length() - 6);
        }
        return name;
    }

    private InputStream getResourceAsStream(String resource) throws IOException {
        InputStream input = this.getClass().getResourceAsStream(this.getResourcePath(this.getClass(), resource));
        if (input == null) {
            throw new FileNotFoundException("missing resource " + resource);
        }
        return input;
    }

    private String getResourcePath(Class<?> clazz, String resource) {
        String path = clazz.getCanonicalName().replace('.', '/');
        int sep = path.lastIndexOf(47);
        if (sep != -1) {
            path = path.substring(0, sep);
        }
        return "/" + path + "/" + resource;
    }
}

