/*
 * Decompiled with CFR 0.152.
 */
package com.palm.novacom.internal;

import com.palm.novacom.INovacomController;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.NovaDeviceInfo;
import com.palm.novacom.Novacom;
import com.palm.novacom.NovacomException;
import com.palm.novacom.internal.NovacomSocketStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class NovacomDevice
implements INovacomDevice {
    private static final String ENCODING = "US-ASCII";
    private final String host;
    NovaDeviceInfo devInfo;

    NovacomDevice(String host, NovaDeviceInfo devInfo) {
        this.host = host;
        this.devInfo = devInfo;
    }

    @Override
    public void close() {
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.devInfo.getPort();
    }

    @Override
    public NovaDeviceInfo getDeviceInfo() {
        return this.devInfo;
    }

    private void handleReply(Socket socket) throws NovacomException, IOException {
        InputStream input = socket.getInputStream();
        byte[] reply = new byte[1024];
        int length = 0;
        while (length < reply.length) {
            int c = input.read();
            if (c == -1) {
                throw new NovacomException(-2, "No data to read from socket");
            }
            reply[length] = (byte)c;
            ++length;
            if (c == 10) break;
        }
        if (reply[0] == 111 && reply[1] == 107) {
            return;
        }
        throw new NovacomException(-99, new String(reply, 0, length - 1, ENCODING));
    }

    INovacomStream issueCommand(String verb, String scheme, String[] args) throws NovacomException, IOException {
        StringBuilder cmd = new StringBuilder(verb);
        cmd.append(" ");
        cmd.append(scheme);
        int i = 0;
        while (args != null && i < args.length) {
            cmd.append(" ");
            cmd.append(args[i]);
            ++i;
        }
        cmd.append("\n");
        Socket socket = null;
        try {
            socket = new Socket(this.host, this.devInfo.getPort());
            OutputStream output = socket.getOutputStream();
            output.write(cmd.toString().getBytes(ENCODING));
        }
        catch (IOException e) {
            if (socket != null) {
                socket.close();
            }
            if (!this.isConnected()) {
                NovacomException e2 = new NovacomException(-107, "Device has been disconnected. Command: " + new String(cmd.toString().replaceAll("\n", "")));
                e2.setStackTrace(e.getStackTrace());
                throw e2;
            }
            throw e;
        }
        try {
            this.handleReply(socket);
        }
        catch (NovacomException e) {
            socket.close();
            NovacomException e2 = new NovacomException(-99, "Command: " + cmd.toString() + " Reply:" + e.getMessage());
            e2.setStackTrace(e.getStackTrace());
            throw e2;
        }
        return new NovacomSocketStream(socket, scheme);
    }

    @Override
    public INovacomStream getFile(String path) throws NovacomException, IOException {
        return this.issueCommand("get", "file://" + path, null);
    }

    @Override
    public INovacomStream putFile(String path) throws NovacomException, IOException {
        return this.issueCommand("put", "file://" + path, null);
    }

    @Override
    public INovacomStream openTerminal(int tty) throws NovacomException, IOException {
        return this.issueCommand("open", "tty://" + tty, null);
    }

    @Override
    public INovacomStream runProgram(String path, String[] args) throws NovacomException, IOException {
        return this.issueCommand("run", "file://" + path, args);
    }

    @Override
    public INovacomStream putInMemory(long address, boolean boot) throws NovacomException, IOException {
        return this.putInMemory(Long.toString(address, 16), boot);
    }

    @Override
    public INovacomStream putInMemory(String address, boolean boot) throws NovacomException, IOException {
        String cmd = "put";
        if (boot) {
            cmd = "boot";
        }
        return this.issueCommand(cmd, "mem://" + address, null);
    }

    @Override
    public INovacomStream connectDevicePort(int port) throws NovacomException, IOException {
        return this.issueCommand("connect", "tcp-port://" + port, null);
    }

    @Override
    public Novacom.DeviceState getState() throws IOException {
        try {
            INovacomStream stream = this.getFile("/proc/mounts");
            stream = this.getFile("/proc/cmdline");
            String cmdline = stream.readLine();
            if (cmdline.indexOf("ram0") > 0) {
                stream.close();
                return Novacom.DeviceState.INSTALLER;
            }
            stream.close();
            return Novacom.DeviceState.OS;
        }
        catch (NovacomException e) {
            return Novacom.DeviceState.BOOTLOADER;
        }
    }

    @Override
    public void killConnection() throws IOException, NovacomException {
        Novacom.DeviceState deviceState = this.getState();
        if (deviceState == Novacom.DeviceState.OS || deviceState == Novacom.DeviceState.INSTALLER) {
            try {
                String[] args = new String[]{"-15", "novacomd"};
                this.runProgram("/usr/bin/killall", args);
            }
            catch (NovacomException e) {
                if (e.getErrorCode() != -2) {
                    throw e;
                }
                return;
            }
        } else {
            throw new NovacomException(-1, "Cannot kill connection in anything but OS mode.");
        }
    }

    @Override
    public void waitForDeviceToAppear() throws IOException, NovacomException {
        this.waitForDeviceToAppear(180000L);
    }

    @Override
    public void waitForDeviceToAppear(long timeout) throws IOException, NovacomException {
        INovacomDevice newdev = null;
        INovacomController controller = Novacom.getController(this.host, 6968);
        long timeToTimeoutOn = System.currentTimeMillis() + timeout;
        do {
            NovaDeviceInfo[] devices = controller.getDeviceList();
            int i = 0;
            while (i < devices.length) {
                if (devices[i].getUIDString().compareTo(this.devInfo.getUIDString()) == 0 && devices[i].getPort() != this.devInfo.getPort()) {
                    newdev = controller.connectToDevice(devices[i]);
                    break;
                }
                ++i;
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (timeToTimeoutOn >= System.currentTimeMillis()) continue;
            throw new NovacomException(-1, "Timeout waiting for device to appear");
        } while (newdev == null);
        this.devInfo = newdev.getDeviceInfo();
    }

    @Override
    public boolean isConnected() throws IOException, NovacomException {
        boolean devConnected = false;
        INovacomController controller = Novacom.getController(this.host, 6968);
        NovaDeviceInfo[] devices = controller.getDeviceList();
        int i = 0;
        while (i < devices.length) {
            if (devices[i].getUIDString().compareTo(this.devInfo.getUIDString()) == 0 && devices[i].getPort() == this.devInfo.getPort()) {
                devConnected = true;
                break;
            }
            ++i;
        }
        return devConnected;
    }
}

