/*
 * Decompiled with CFR 0.152.
 */
package com.palm.novacom.tests;

import com.palm.novacom.INovacomController;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.Novacom;
import com.palm.novacom.NovacomException;
import java.io.IOException;

public class CheckStartupTime {
    public static void main(String[] args) throws IOException, NovacomException {
        INovacomController controller = Novacom.getController();
        INovacomDevice device = controller.connectDefaultDevice();
        System.out.println("Check reboot time: reports how fast connection is established after reboot");
        if (device.getState() != Novacom.DeviceState.BOOTLOADER) {
            System.out.println("---   device connected: " + device.isConnected());
            System.out.println("--- rebooting device");
            INovacomStream stream = device.runProgram("/sbin/tellbootie", new String[]{"reboot"});
            while (stream.read() > 0) {
            }
            stream.close();
            System.out.println("---   device connected: " + device.isConnected());
            long DeviceTime1 = System.currentTimeMillis();
            device.waitForDeviceToAppear();
            long DeviceTime2 = System.currentTimeMillis();
            System.out.println("--- device started, novacomd online");
            System.out.println("---   device connected: " + device.isConnected());
            System.out.println(" connection established after " + (DeviceTime2 - DeviceTime1) + " millisec; (" + (DeviceTime2 - DeviceTime1) / 1000L + "sec)");
        } else {
            System.out.println("Device must be booted in normal mode");
        }
    }
}

