/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.core;

import com.palm.nova.installer.core.MountUtils;
import com.palm.novacom.INovacomController;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.NovaDeviceInfo;
import com.palm.novacom.Novacom;
import com.palm.novacom.NovacomException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;

public class RdxUtils {
    private INovacomDevice device = null;
    private MountUtils mountUtils;
    private static final String MKDIR = "/bin/mkdir";
    private static final String TMP_VARFS = "/tmp_varfs";
    private static final String RDX_FOLDER = "/misc/";

    public RdxUtils() throws IOException, NovacomException {
    }

    public RdxUtils(INovacomDevice device) {
        this.device = device;
    }

    private INovacomDevice getDevice(int index) throws NovacomException, IOException {
        INovacomController controller = Novacom.getController();
        NovaDeviceInfo[] devices = controller.getDeviceList();
        if (devices.length <= index) {
            return null;
        }
        return controller.connectToDevice(devices[index]);
    }

    public void putFileInRdxFolder(String file) throws IOException, NovacomException {
        Novacom.DeviceState deviceState;
        if (this.device == null) {
            this.device = this.getDevice(0);
        }
        if ((deviceState = this.device.getState()) == Novacom.DeviceState.INSTALLER) {
            System.out.println("verified installer mode");
            this.mountUtils = new MountUtils(this.device);
            this.mountUtils.mount(MountUtils.MountParts.VARFS, MountUtils.FsType.EXT3, TMP_VARFS);
            if (file != null) {
                this.runCommand(MKDIR, new String[]{"-p", "/tmp_varfs/misc/"});
                File outfile = new File(file);
                String deviceFullPathAndName = "/tmp_varfs/misc/" + outfile.getName();
                INovacomStream stream = this.device.putFile(deviceFullPathAndName);
                stream.write(new FileInputStream(file));
                stream.closeOutput();
                stream.close();
            }
            this.mountUtils.umount(MountUtils.MountParts.VARFS);
        }
    }

    public void putFilesInRdxFolder(File[] files) throws IOException, NovacomException {
        Novacom.DeviceState deviceState;
        if (this.device == null) {
            this.device = this.getDevice(0);
        }
        if ((deviceState = this.device.getState()) == Novacom.DeviceState.INSTALLER) {
            this.mountUtils = new MountUtils(this.device);
            this.mountUtils.mount(MountUtils.MountParts.VARFS, MountUtils.FsType.EXT3, TMP_VARFS);
            if (files.length > 0) {
                this.runCommand(MKDIR, new String[]{"-p", "/tmp_varfs/misc/"});
                for (int i = 0; i < files.length; ++i) {
                    String deviceFullPathAndName = "/tmp_varfs/misc/" + files[i].getName();
                    INovacomStream stream = this.device.putFile(deviceFullPathAndName);
                    stream.write(new FileInputStream(files[i]));
                    stream.closeOutput();
                    stream.close();
                }
            }
            this.mountUtils.umount(MountUtils.MountParts.VARFS);
        }
    }

    private void runCommand(String command, String[] args) throws IOException, NovacomException {
        if (args == null) {
            args = new String[]{};
        }
        INovacomStream stream = this.device.runProgram(command, args);
        stream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveLogs(final String logTitle) {
        File fileDir;
        File[] files;
        String tempDir = System.getProperty("java.io.tmpdir");
        if (!tempDir.endsWith("/") && !tempDir.endsWith("\\")) {
            tempDir = tempDir + System.getProperty("file.separator");
        }
        if ((files = (fileDir = new File(tempDir)).listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.toLowerCase().startsWith(logTitle.toLowerCase());
            }
        })).length > 0) {
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File file1, File file2) {
                    return (int)(file1.lastModified() - file2.lastModified());
                }
            });
            for (int i = 0; i < files.length && i < 2; ++i) {
                System.out.println("from " + files[i].getAbsoluteFile());
                String destfullPathAndName = tempDir + "palmInstallerError" + i + ".log";
                System.out.println("to " + destfullPathAndName);
                FileInputStream from = null;
                FileOutputStream to = null;
                try {
                    int bytesRead;
                    from = new FileInputStream(files[i].getAbsoluteFile());
                    to = new FileOutputStream(destfullPathAndName);
                    byte[] buffer = new byte[4096];
                    while ((bytesRead = from.read(buffer)) != -1) {
                        to.write(buffer, 0, bytesRead);
                    }
                    continue;
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
                finally {
                    if (from != null) {
                        try {
                            from.close();
                        }
                        catch (IOException e) {}
                    }
                    if (to != null) {
                        try {
                            to.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        }
    }
}

