/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.core.stages;

import com.palm.nova.installer.core.IInstallerStage;
import com.palm.nova.installer.core.IStageProgressReporter;
import com.palm.nova.installer.core.TrenchcoatModel;
import com.palm.nova.installer.core.stages.BaseStage;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.NovacomException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.transform.TransformerException;

public class TrenchcoatStage
extends BaseStage
implements IInstallerStage {
    public static final String TRENCHCOAT_PATH = "/sbin/trenchcoat";
    public static final String TRENCHCOAT_POSTFLASH_PATH = "/sbin/tcpostflash.sh";
    public static final String DATE_PATH = "/bin/date";
    private final TrenchcoatModel model;
    private final INovacomDevice device;

    public TrenchcoatStage(TrenchcoatModel model, INovacomDevice device) {
        this.model = model;
        this.device = device;
    }

    public String toString() {
        return "Trenchcoat";
    }

    public void run() throws IOException, NovacomException {
        IStageProgressReporter progress = this.getProgressHandler();
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMddHHmmyyyy");
        Date date = new Date();
        INovacomStream stream = this.device.runProgram(DATE_PATH, new String[]{dateFormat.format(date)});
        stream.waitForReturnCode();
        stream.close();
        Object jobId = progress.startJob("Trenchcoat", 100);
        progress.commentOnJob(jobId, "Starting /sbin/trenchcoat");
        stream = this.device.runProgram(TRENCHCOAT_PATH, null);
        BaseStage.StreamReaderThread thread = new BaseStage.StreamReaderThread(this, stream, jobId);
        thread.start();
        thread.setPriority(10);
        progress.commentOnJob(jobId, "Starting Stream Reader");
        try {
            StringBuffer buffer = new StringBuffer(this.model.toXMLString());
            buffer.append("\n");
            System.out.println(buffer.toString());
            stream.write(buffer.toString().getBytes("US-ASCII"));
            stream.flush();
            progress.commentOnJob(jobId, "Wrote XML Configuration Data");
        }
        catch (TransformerException e) {
            IOException e2 = new IOException("Unable to transform model back to XML: " + e.getMessage());
            e2.setStackTrace(e.getStackTrace());
            throw e2;
        }
        String[] filenames = this.model.getFilesInOrder();
        for (int i = 0; i < filenames.length; ++i) {
            progress.commentOnJob(jobId, "Sending File: " + filenames[i]);
            long count = stream.write(this.model.getInstallerModel().getInputStream(filenames[i]));
            progress.commentOnJob(jobId, "Sent " + count + " bytes");
        }
        try {
            progress.commentOnJob(jobId, "Waiting....");
            thread.join();
            progress.commentOnJob(jobId, "Finished!");
        }
        catch (InterruptedException e) {
            throw new IOException("Reader thread never completed.");
        }
        int trenchcoatReturn = stream.waitForReturnCode();
        stream.close();
        StringBuffer script = new StringBuffer("#!/bin/sh\n/bin/cat /proc/mounts | /bin/grep tcmnt | /usr/bin/awk '{print $2}' > /tmp/mtpts.txt\n");
        script.append("nummounts=`/usr/bin/wc -l /tmp/mtpts.txt | /usr/bin/awk '{print $1}`\n");
        script.append("if [ $nummounts -gt 0 ]\n");
        script.append("then\n");
        script.append("for mtpt in `/bin/cat /tmp/mtpts.txt`\n");
        script.append("do\n");
        script.append("/usr/bin/fuser -k $mtpt\n");
        script.append("/bin/umount $mtpt\n");
        script.append("done\n");
        script.append("/usr/sbin/lvm.static vgchange -an\n");
        script.append("exit 1\n");
        script.append("else\n");
        script.append("exit 0\n");
        script.append("fi\n");
        stream = this.device.putFile("/tmp/ckmounts.sh");
        stream.write(script.toString().getBytes("US-ASCII"));
        stream.closeInput();
        stream.closeOutput();
        stream.waitForReturnCode();
        stream.close();
        stream = this.device.runProgram("/bin/sh", new String[]{"-c /tmp/ckmounts.sh"});
        int mountReturn = stream.waitForReturnCode();
        stream.close();
        progress.endJob(jobId);
        if (trenchcoatReturn != 0) {
            throw new NovacomException(-1, "Trenchcoat returned failure error code " + trenchcoatReturn);
        }
        if (mountReturn != 0) {
            throw new NovacomException(-1, "Trenchcoat failed to unmount all partitions, error code " + mountReturn);
        }
    }
}

