/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.recoverytool;

import com.palm.nova.installer.core.IStageProgressReporter;
import com.palm.nova.installer.core.stages.ChargeBatteryStage;
import com.palm.nova.installer.recoverytool.CardController;
import com.palm.novacom.INovacomDevice;
import java.util.logging.Logger;

public class BatteryCharger
implements Runnable,
IStageProgressReporter {
    Logger logger = Logger.getLogger("com.palm.recoverytool");
    ChargeBatteryStage batteryStage;
    CardController ccntrlr;

    public BatteryCharger(CardController ccntrlr) {
        this.ccntrlr = ccntrlr;
    }

    public void setDevice(INovacomDevice device) {
        this.batteryStage = new ChargeBatteryStage(device);
        this.batteryStage.setProgressHandler(this);
    }

    public void commentOnJob(Object id, String comment) {
        this.logger.info("Battery:" + comment);
    }

    public void endJob(Object id) {
        this.ccntrlr.batteryChargingFinished(null);
        this.logger.info("Battery Charging Done");
    }

    public Object startJob(String title, int increments) {
        this.logger.info("Started:" + title);
        return null;
    }

    public void updateJob(Object id, int progress) {
        this.logger.info("Battery Charging Progress: " + progress);
        this.ccntrlr.batteryChargingUpdate(progress);
    }

    public void run() {
        try {
            this.batteryStage.run();
        }
        catch (Exception e) {
            this.ccntrlr.batteryChargingFinished(e);
        }
    }
}

