/*
 * Decompiled with CFR 0.152.
 */
package com.palm.nova.installer.core;

import com.palm.nova.installer.core.LoggerUtils;
import com.palm.novacom.INovacomDevice;
import com.palm.novacom.INovacomStream;
import com.palm.novacom.Novacom;
import com.palm.novacom.NovacomException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MountUtils {
    private static final String MKDIR = "/bin/mkdir";
    private static final String LVMCMD = "/usr/sbin/lvm.static";
    private static final String MOUNT = "/bin/mount";
    private static final String UMOUNT = "/bin/umount";
    private static final String MMCPART_ROOTFS = "/dev/mmcblk0p2";
    private static final String MMCPART_VAR = "/dev/mmcblk0p3";
    private static String lvmRootFsPath;
    private static String lvmVarFsPath;
    private static String lvmLogFsPath;
    private static String lvmMediaFsPath;
    private static String bootPartition;
    private boolean isLvm = false;
    private final INovacomDevice device;
    Logger logger;

    public MountUtils(INovacomDevice device) {
        this.device = device;
        this.logger = LoggerUtils.getInstance().getLogger("MountUtils");
        try {
            this.readCurrentLvmValues();
            this.getBootPartition();
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "", e);
            this.isLvm = false;
        }
    }

    private void setLvmValues(String lvmGroupName, String lvmRootFsVolumeName, String lvmVarFsVolumeName) {
        this.isLvm = true;
        lvmRootFsPath = "/dev/mapper/" + lvmGroupName + "-" + lvmRootFsVolumeName;
        lvmVarFsPath = "/dev/mapper/" + lvmGroupName + "-" + lvmVarFsVolumeName;
        System.err.println("LVM Root Path: " + lvmRootFsPath);
        System.err.println("LVM Var Path: " + lvmVarFsPath);
    }

    private void setLvmAllValues(String lvmGroupName, String lvmRootFsVolumeName, String lvmVarFsVolumeName, String lvmLogFsVolumeName, String lvmMediaFsVolumeName) {
        this.isLvm = true;
        this.setLvmValues(lvmGroupName, lvmRootFsVolumeName, lvmVarFsVolumeName);
        lvmLogFsPath = "/dev/mapper/" + lvmGroupName + "-" + lvmLogFsVolumeName;
        lvmMediaFsPath = "/dev/mapper/" + lvmGroupName + "-" + lvmMediaFsVolumeName;
        System.err.println("LVM Log Path: " + lvmLogFsPath);
        System.err.println("LVM Media Path: " + lvmMediaFsPath);
    }

    private void getBootPartition() {
        String results = "unknown";
        int returnCode = -1;
        StringBuffer script = new StringBuffer("#!/bin/sh\n");
        script.append("for dev in /dev/mmcblk*p* /dev/[sh]d*; do\n");
        script.append("  if lbl=`e2label $dev 2>/dev/null`; then\n");
        script.append("    if [ \"$lbl\" = '/boot' ]; then\n");
        script.append("       echo $dev\n");
        script.append("       return 0\n");
        script.append("    fi\n");
        script.append("  fi\n");
        script.append("done\n");
        script.append("echo unknown\n");
        script.append("return -1\n");
        try {
            INovacomStream output = this.device.putFile("/tmp/find_boot.sh");
            output.write(script.toString().getBytes("US-ASCII"));
            output.closeInput();
            output.closeOutput();
            output.waitForReturnCode();
            output.close();
            output = this.device.runProgram("/bin/sh", new String[]{"-c", "/tmp/find_boot.sh"});
            results = output.readLine();
            returnCode = output.waitForReturnCode();
            output.close();
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "IO exception when obtaining boot partition", e);
        }
        catch (NovacomException e) {
            this.logger.log(Level.WARNING, "novacom exception when obtaining boot partition", e);
        }
        if (0 != returnCode) {
            bootPartition = "unknown";
            this.logger.log(Level.WARNING, "unable to obtain boot partition with /tmp/find_boot.sh script");
        } else {
            bootPartition = results;
        }
    }

    public void readCurrentLvmValues() throws IOException {
        if (this.device.getState() == Novacom.DeviceState.INSTALLER) {
            System.out.println("looking for LVM while in installer mode");
            try {
                INovacomStream lvmStatic = this.device.getFile(LVMCMD);
                if (lvmStatic == null) {
                    System.out.println("no lvmstatic, not lvm");
                    this.isLvm = false;
                    return;
                }
                System.out.println("got lvm static, running vgscan");
                this.runCommand(LVMCMD, new String[]{"vgscan --ignorelockingfailure"});
                System.out.println("vgscan ran, running vgchange");
                INovacomStream stream = this.device.runProgram(LVMCMD, new String[]{"vgchange -ay --ignorelockingfailure"});
                System.out.println("returned from vgchange");
                stream.flush();
                String line = stream.readLine();
                String lvmGroupName = null;
                Integer numberOfVolumes = 0;
                while (line.compareTo("") != 0) {
                    System.err.println("MountUtils:" + line);
                    if (line.contains(" logical volume(s) in volume group ")) {
                        String strNumber = (line = line.trim()).substring(0, line.indexOf(" "));
                        numberOfVolumes = new Integer(strNumber);
                        if (numberOfVolumes == 0) break;
                        int afterFirstQuote = line.indexOf("\"") + 1;
                        int secondQuote = line.indexOf("\"", afterFirstQuote);
                        lvmGroupName = line.substring(afterFirstQuote, secondQuote);
                        System.out.println("lvmGroupName set to " + lvmGroupName);
                    }
                    line = stream.readLine();
                }
                stream.flush();
                stream.close();
                if (numberOfVolumes == 0 || lvmGroupName == null) {
                    this.isLvm = false;
                    return;
                }
                this.setLvmAllValues(lvmGroupName, "root", "var", "log", "media");
            }
            catch (NovacomException e) {
                System.out.println("no LVVM");
                this.logger.log(Level.WARNING, "no LVVM", e);
                this.isLvm = false;
                return;
            }
        }
    }

    private String runCommand(String command, String[] args) throws IOException, NovacomException {
        if (args == null) {
            args = new String[]{};
        }
        System.out.println("+++++runCommand " + command);
        INovacomStream stream = this.device.runProgram(command, args);
        stream.flush();
        String line = stream.readLine();
        StringBuffer returnVal = new StringBuffer();
        while (line.compareTo("") != 0) {
            System.out.println("MountUtils:" + line);
            returnVal.append(line);
            line = stream.readLine();
        }
        System.out.println("flushing and closing");
        stream.flush();
        stream.close();
        System.out.println("-----runCommand");
        return returnVal.toString();
    }

    public void mount(MountParts partition, FsType fsTypeToMount, String mountPoint) throws NovacomException, IOException {
        this.mount(partition, fsTypeToMount, mountPoint, false);
    }

    public void mount(MountParts partition, FsType fsTypeToMount, String mountPoint, boolean openReadOnly) throws NovacomException, IOException {
        String fsType = "";
        if (fsTypeToMount == FsType.EXT3) {
            fsType = "ext3";
        } else if (fsTypeToMount == FsType.VFAT) {
            fsType = "vfat";
        } else if (null == fsTypeToMount) {
            throw new NovacomException(-1, "Error Mounting: we don't support null partitions");
        }
        if (null != partition.getPartition(this.isLvm)) {
            System.err.println("Mounting " + partition.getPartition(this.isLvm) + " to: " + mountPoint);
            this.runCommand(LVMCMD, new String[]{"vgchange", "-ay"});
            this.runCommand(MKDIR, new String[]{"-p", mountPoint});
            String returnValFromMount = openReadOnly ? this.runCommand(MOUNT, new String[]{"-r", "-t", fsType.toString(), partition.getPartition(this.isLvm), mountPoint}) : this.runCommand(MOUNT, new String[]{"-t", fsType.toString(), partition.getPartition(this.isLvm), mountPoint});
            if (returnValFromMount.contains("No such file or directory")) {
                System.out.println("failed to mount, returning exception");
                throw new NovacomException(-1, "unable to mount");
            }
        } else {
            System.err.println("Warning: Couldn't Mount: " + partition.toString());
        }
    }

    public void umount(MountParts partition) throws NovacomException, IOException {
        System.err.println("Unmounting " + partition.getPartition(this.isLvm));
        if (null != partition.getPartition(this.isLvm)) {
            String returnVal = this.runCommand(UMOUNT, new String[]{partition.getPartition(this.isLvm)});
            if (returnVal != null && returnVal.contains("cannot umount")) {
                System.err.println("MountUtils: unmount failed, retrying in 1 second");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    this.logger.log(Level.WARNING, "", e);
                    e.printStackTrace();
                }
                returnVal = this.runCommand(UMOUNT, new String[]{partition.getPartition(this.isLvm)});
                if (returnVal != null && returnVal.contains("cannot umount")) {
                    System.err.println("MountUtils:unmount failed");
                    throw new NovacomException(-1, "unmount failed");
                }
                System.err.println("MountUtils:unmount successful");
            } else {
                System.err.println("MountUtils:unmount successful");
            }
        } else {
            System.err.println("Warning: Couldn't Unmount: " + partition.toString());
        }
        this.runCommand(LVMCMD, new String[]{"vgchange", "-an"});
    }

    public static enum FsType {
        EXT3,
        VFAT;

    }

    public static enum MountParts {
        ROOTFS,
        VARFS,
        BOOTFS,
        LOGFS,
        MEDIAFS;


        String getPartition(boolean isLvm) throws NovacomException {
            switch (this) {
                case ROOTFS: {
                    return isLvm ? lvmRootFsPath : MountUtils.MMCPART_ROOTFS;
                }
                case VARFS: {
                    return isLvm ? lvmVarFsPath : MountUtils.MMCPART_VAR;
                }
                case BOOTFS: {
                    return bootPartition;
                }
                case LOGFS: {
                    return isLvm ? lvmLogFsPath : null;
                }
                case MEDIAFS: {
                    return isLvm ? lvmMediaFsPath : null;
                }
            }
            throw new NovacomException(-1, "Invalid Enum");
        }
    }
}

