/* Copyright 2010 Palm, Inc.  All rights reserved. */

/*jslint laxbreak: true */
/*global Class, Hash
	, $L, AccountsMojoService, AccountsUI, AppManagerMojoService, Calendar
	, CalendarEvent, CalendarPrefsManager, CalendarsManager, DatabaseManager
	, Defaults, EventManager, Formatter, Foundations, Mojo, PalmCall
	, PalmSystem, RecurrenceRules, ReminderManager, RRuleManager
	, SystemMojoService, Template
*/

//TODO: Clean all this up via index.js
	/*global DB:true, EventManager:true, MojoLoader, ObjectUtils:true, PalmCall:true */
	var GLOBAL = this;
	var PalmCall = Foundations.Comms.PalmCall;
//TODO: END

// ** APP ASSISTANT
var AppAssistant = Class.create (

{	initialize: function (appController) {

		Mojo.Log.info ("AppAssistant initialize");

		this.appController		= appController;
		this.openReminderAlert	= null;

		// COOKIES
		this.cookie = new Mojo.Model.Cookie ("com.palm.app.calendar");

		// Set firstUse to true if the cookie doesn't exist or if we're in MojoHost:
		if (!this.cookie.get() || Mojo.Host.current === Mojo.Host.mojoHost) {
			this.cookie.put ({firstUse: true});
		}

		// CURRENT DATE & TIME - Keeps track of the current day/month/time in view
		this.currentDateTime			= new Date();
		this.currentDateTimeObservers	= new Hash();

		// DAY CHANGE - Observers interested in the system time changing from one day to another
		this.dayChangeObservers = new Hash();

		// TIME FORMAT
		// We keep track of the views that want to be notified when the system time format
		// changes so that we don't have to make a system service call in each view that is 
		// interested in the time format.
		this.timeFormat				= "HH12";
		this.timeFormatObservers	= new Hash();
		this.timeChangeObservers	= new Hash();

		this.loadLibraries ();

		// MANAGERS - Keeps track of information used across views
		// NOTE: The order of these instantiations is important due to dependencies: 
		this.calendarsManager	= new CalendarsManager		(this);
		this.prefsManager		= new CalendarPrefsManager	(this);
		this.reminderManager	= new ReminderManager();
		this.eventManager		= new Calendar.EventManager();
		this.systemService		= new SystemMojoService();
		this.appManagerService	= new AppManagerMojoService();
		this.formatterService	= new Formatter();
		this.db					= new DatabaseManager();
		this.recurrenceRule		= new RecurrenceRules();
		this.handleLaunchCount	= 0;
		this.dayChangeActivityName = "com.palm.app.calendar.dayChange";
	},

	setup: function() {
		Mojo.Log.info("AppAssistant setup");

		PalmCall.call("palm://com.palm.service.calendar.reminders/", "onInit", {});

		this.calendarsManager.setup();

		// Retrieve and subscribe to the timeFormat as saved in the system prefs
		this.timeFormatRequest = this.systemService.getTimeFormat (this.getTimeFormatCallback.bind(this));
		//retrieve the time change if it  happens
		this.timeChangeRequest = this.systemService.getSystemTime (this.getSystemTimeCallback.bind(this));

		this.updateCalendarAppIcon();
		this.setupDayChangeTimer();

		this.eventManager.getEvents();
	}

,	handleLaunch: function(param) {
		Mojo.Log.info("**********in handle launch");
		
		// TEMP Ignore the first time we get called which is at boot time. We need this until framework
		// gives us a flag to let us now if this being called at boot.
		this.handleLaunchCount++;

		if (this.handleLaunchCount <= 1) {
			return;
		}

		//if this failed during initialization, try again
		if (!this.calendarsManager.accounts) {
			this.calendarsManager.getAccounts();
		}

		//if this failed during initialization, try again
		if(!this.prefsManager.prefs){
			this.prefsManager.loadFromDB();
		}

		var launchParams = {};
		if (PalmSystem.launchParams) {
			launchParams = PalmSystem.launchParams.evalJSON(true);
		} else {
			Mojo.Log.info ("Calendar App: No Launch Params");
		}        

		if (launchParams.alarm) {
			Mojo.Log.info("========= AA: adding reminders "+JSON.stringify(launchParams.alarm));
			this.reminderManager.addReminders(launchParams.alarm);
		}		 
		else if (launchParams.alarmClose){
			Mojo.Log.info("========= AA: closing reminders "+JSON.stringify(launchParams.alarmClose));			
			this.reminderManager.closeReminders(launchParams.alarmClose);
		}
		else if (launchParams.alarmDeleted){
			Mojo.Log.info("========= AA: closing by event ids "+JSON.stringify(launchParams.alarmDeleted));
			this.reminderManager.closeRemindersByEventId(launchParams.alarmDeleted);
		} 
		else if (launchParams.alarmUpdated){
			Mojo.Log.info("========= AA: updating reminders "+JSON.stringify(launchParams.alarmUpdated));
			this.reminderManager.updateReminders(launchParams.alarmUpdated.update, launchParams.alarmUpdated.close);
		} 
		else if (launchParams.dayChange){
			this.dayChange();
		}
		else if(launchParams.makeABunchOfEvents){
			Mojo.Log.error("========= MAKE A BUNCH OF EVENTS "+JSON.stringify(launchParams.makeABunchOfEvents));
			this.db.makeABunchOfEvents(launchParams.makeABunchOfEvents);
		}
		else if (launchParams.launchType == "passwordInvalid") {
			this.showPasswordNotification(launchParams);
		}
		else {
			//we always want to launch today rather than the last viewed day
			//per bug NOV-29174
			this.goToToday();
			var calendarStageController = Mojo.Controller.getAppController().getStageController("calendar");
			if (!calendarStageController) {
				var stageCreateCallback = function(stageController){
					this.handleLaunchTypes(stageController, launchParams, false);
					// during fresh app launch no need to call stageController.activate() - fix NOV-877334 
					//this.focusCalendarStage();
				}.bind(this);
				var imageName;
				if (launchParams) {
					if (launchParams.details) {
						imageName = "images/splash-calendar-edit.png";
					}
				}
				this.openCalendarStage(stageCreateCallback, imageName);
			} else {
				this.handleLaunchTypes(calendarStageController, launchParams, true);
				this.focusCalendarStage();
			}
		}
	},

	launchDayView: function(stageController, date, appExists) {
		Mojo.Log.info("********handle launch day view");

		var sceneExists = false;
		if (appExists) {
			// If the top scene is not the Day View, try to pop to it.
			// If the top scene is already the Day View, there's no point
			// in popping the scene
			if (stageController.topScene().sceneName != "day") {
				stageController.popScenesTo("day");
			}

			// Check to see if the day scene is already up
			if (stageController.topScene().sceneName == "day") {
				sceneExists = true;
			}

			if (date) {
				// Check to see if we need to update the date that's being shown.
				// If it's the same no need to set it again which causes a redraw
				var curDateTime = this.getCurrentDateTime().clearTime();
				var dateWithNoTime = new Date(date).clearTime();
				if (!curDateTime.equals(dateWithNoTime)) {
					// The current date being shown is not the same as the one
					// we want so we set it.
					this.setCurrentDateTime(date);
				}
			}
		} else if (date) {
				this.setCurrentDateTime(date);
		}

		// Only push the Day View if it's not already visible
		if (!sceneExists) {
			stageController.pushScene({name: "day", transition: Mojo.Transition.crossFade, disableSceneScroller: true});
		}
	},

	handleLaunchTypes: function(stageController, launchParams, appExists){

		if (launchParams && launchParams.date) {
			this.launchDayView (stageController, new Date (parseInt (launchParams.date, 10)), appExists);
			return;
		}

		if (launchParams && launchParams.reminders) {
			if (!appExists) {
				stageController.pushScene({name: "day", disableSceneScroller: true});
			}
			stageController.pushScene("reminder-list");
			return;
		}

		if (launchParams && launchParams.details) {
			if (!appExists) {
				stageController.pushScene({name: "day", disableSceneScroller: true});
			}
			// TODO need to pass event occurence date instead of today's date
			//TODO: What is being passed in for the id here? Does it have times or just a db-id?
			stageController.pushScene('edit', launchParams.details, new Date(), false);
			return;
		}

		if (launchParams && (launchParams.newEvent || launchParams.quickLaunchText)) {
			
			var sceneStack = stageController.getScenes();
			var sceneStackLength = sceneStack && sceneStack.length;
			var validUnderScene;
			var i = 0;
			while(i < sceneStackLength && !validUnderScene){
				var scene = sceneStack[i];
				switch (scene.sceneName){
					case "day":
					case "month":
					case "week":
						validUnderScene = scene.sceneName;
						break;
					default:
						break;
				}
			}
			
			//if we couldn't find a valid underscene or the app doesn't exist, push dayview.
			if(!validUnderScene || !appExists){
				stageController.pushScene({name: "day", disableSceneScroller: true});
			}
			else {
				stageController.popScenesTo(validUnderScene);
			}
			
			if(launchParams.quickLaunchText){
				//for quick launch text, we don't save first, we just launch straight into edit view with the given subject
				var start = new Date();
				if(start.minutes > 30){
					start.set({minutes: 30, seconds: 0, milliseconds: 0});
				}
				else{
					start.set({minutes: 0, seconds: 0, milliseconds: 0});
				}
				stageController.pushScene('edit', 0, start, false, 0, launchParams.quickLaunchText, true);
			}
			else{
				//for newEvent, we populate with all the data given, save it, then launch edit view
				this.createNewEventAndShowDetails(stageController, launchParams.newEvent);	
			}			
			return;
		}

		if (!appExists) {
			this.launchCalendarScene(stageController, this.isFirstUse());

		} else if (!this.isFirstUse) {
			// Only launch day view if this.isFirstUse
			this.launchDayView (stageController, new Date(), appExists);
		}

		if(launchParams && launchParams.launchType == "editPassword"){
			this.controller.closeStage("PasswordChangedNotification");
			stageController.pushScene ("prefs");
			stageController.pushScene ("accountlogin", launchParams.accountId, launchParams.login, null, null, "", null);
		}
	}

,	loadLibraries: function() {
		// Loads libraries required by the Calendar application:
		var libsInfo =
		[	{	name	: "foundations"
			,	ourName	: "Foundations"
			,	version	: "1.0"
			}
		,	{	name	: "accounts.ui"
			,	ourName	: "AccountsUI"
			,	version	: "1.0"
			}
		,	{	name	: "calendar"
			,	ourName	: "Calendar"
			,	version	: "1.0"
			}
		,	{	name	: "unittest"
			,	ourName	: "UnitTest"
			,	version	: "1.0"
			}
		,	{	name	: "underscore"
			,	ourName	: "_"
			,	version	: "1.0"			
			}
//		,	{	name	: "network.alerts"		// Replaces ConnectionWidget which wasn't used.
//			,	ourName	: "NetworkAlerts"		// Will need for send by bluetooth and before
//			,	version	: "1.0"					// launching account login view.
//			}
		];
	
		var results = { pass: [], fail: [] };
	
		// Attempt to load as many libraries as possible even if failures occur:
		libsInfo.forEach (function (info) {
			try {
				var lib = MojoLoader.require (info);
	
				if (info.ourName) {
					if ("UnitTest" === info.ourName) {
						GLOBAL [info.ourName] = Mojo.Test = lib [info.name].UnitTest;
	
					} else if ("_" === info.ourName) {
						GLOBAL [info.ourName] = lib [info.name]._;
	
					}  else {
						GLOBAL [info.ourName] = lib [info.name];
					}
				}
				results.pass.push (info.ourName ? info.ourName : info.name);
			} catch (e) {
				results.fail.push (info.ourName ? info.ourName : info.name);
				Mojo.Log.error (e.stack);
			}
		});
	
		if (results.pass.length) {
			Mojo.Log.info	("\n\n\tSuccessfully loaded libraries: %s.\n\n", results.pass);
		}
	
		if (results.fail.length) {
			Mojo.Log.error	("\n\n\tFailed to load libraries: %s\n\n", results.fail);
		}
	
		switch (!0) {												// JSLint bypass for switch (true); !0 = true
			case !!GLOBAL.AccountsUI:
				AccountsUI.enableExtensions();
				break;
	
			case !!GLOBAL.Calendar:
				EventManager = Calendar.EventManager;
				break;
	
			case !!GLOBAL.Foundations:
				DB			= Foundations.Data.DB;
				ObjectUtils	= Foundations.ObjectUtils;
				PalmCall	= Foundations.Comms.PalmCall;
				break;
		}
	}//END:loadLibraries()

,	showPasswordNotification: function(launchParams){
        var messageTemplate	= new Template($L("Incorrect password for #{login}"));
		var newLaunchParams	= Object.extend({}, launchParams);

		newLaunchParams.launchType = "editPassword";
        this.controller.showBanner (messageTemplate.evaluate(launchParams), newLaunchParams, '');
        var passwordStageController = this.controller.getStageController("PasswordChangedNotification");

		var f = function(iconClass, accountId, login, domain,stageController){
            stageController.pushScene ("passwordchanged", {
				iconClass: iconClass,
				accountId: accountId,
				login:login,
				domain:domain
			});
        }.bind(this, launchParams.iconClass, launchParams.accountId, launchParams.login, launchParams.domain);

		if (passwordStageController) {
			f(passwordStageController);
		}
		else {
			var stageparams = {
				name: "PasswordChangedNotification",
				lightweight: true
			};
			this.controller.createStageWithCallback(stageparams, f, 'dashboard');
		}
	},

	savedNewEvent: function(date, response) {
		//Mojo.Log.info("savedNewEvent " + Object.toJSON(response));
		// The save succeeded so let's just launch the Event Details
		var calendarStageController = Mojo.Controller.getAppController().getStageController("calendar");
		var targetDate = (date) ? new Date(date) : new Date();
		
		if(response.results && response.results.length > 0){
			var item = response.results[0];
			calendarStageController.pushScene('edit', item.id, targetDate, false);	
		}
		
	},

	saveFailedNewEvent: function(response) {
		// If the new event failed, then put an empty new event scene
		//Mojo.Log.info("saveFailedNewEvent " + Object.toJSON(response));
		var calendarStageController = Mojo.Controller.getAppController().getStageController("calendar");
		calendarStageController.pushScene('edit', 0, 0, false);
	},

	populateEvent: function(event, params){
		for (var property in params) {
			if(event.hasOwnProperty(property)){
				event[property] = params[property];	
			}
		}
		var start = event.dtstart;
		if(start && typeof(start) == "string"){
			event.dtstart = parseInt(start, 10);
		}
		var end = event.dtend;
		if(end && typeof(end) == "string"){
			event.dtend = parseInt(end, 10);
		}
		
		if(event.rrule && event.rrule.until){
			var until = event.rrule.until;
			 if(typeof(event.rrule.until) == "string"){
				event.rrule.until = parseInt(until, 10);
			 }
		}
		event.calendarId = this.prefsManager.getDefaultCalendar();
	},
	
	createNewEventAndShowDetails: function(stageController, eventParams) {
		//Mojo.Log.info("createNewEventAndShowDetails");
		// Create the event, and only launch the Edit scene if the event was successfully created
		var newEvent = new CalendarEvent();
		if(eventParams){
			this.populateEvent(newEvent, eventParams);
		}
		newEvent.useDefaultsOnParseFailures = true;
		//Mojo.Log.info("createNewEventAndShowDetails " + Object.toJSON(newEvent));
		this.db.createEvent (newEvent, this.savedNewEvent.bind(this, newEvent.dtstart), this.savedNewEvent.bind(this, newEvent.dtstart));
	},



	openCalendarStage: function (f, imageName) {
		Mojo.Controller.getAppController().createStageWithCallback({name: "calendar", lightweight: Mojo.Controller.appInfo.lwStages, splashBackgroundName: imageName}, f);
	},

	focusCalendarStage: function() {
		var stageController = Mojo.Controller.appController.getStageController("calendar");
		if (stageController) {
			stageController.activate();
		}
	},

	 // *** FIRST USE ***
	isFirstUse: function() {
		if (this.cookie) {
			var cookie = this.cookie.get();
			return (!cookie || cookie.firstUse);
		}
	},

	launchCalendarScene: function(stageController, showFirstUse) {
		// Clear the view stack (just in case the starting scene is up)
		stageController.popScenesTo();
		if (showFirstUse && Mojo.Host.current !== Mojo.Host.mojoHost) {
			// If this is the first use of Calendar, show the first use scene
			AccountsUI.FirstLaunch.pushFirstLaunch(stageController, {
				filterBy: {
					capability: "CALENDAR"
				},
				displayText: $L("Your Calendar Accounts"),
				done: function() {
// TODO: Only set first use to false if at least one account exists, i.e. Palm Profile:  
					this.setFirstUseToFalse();
					stageController.pushScene ({name: "month", transition: Mojo.Transition.crossFade, disableSceneScroller: true});
				}.bind(this)
			});
		} else {
			// Otherwise show the Day View
			stageController.pushScene({name: "month", transition: Mojo.Transition.crossFade, disableSceneScroller: true});
		}
	},

	// *** TIME FORMAT ***
	getTimeFormatCallback: function(response) {
		//Mojo.Log.info("app-assistant: getTimeFormatCallback");
		if (response && response.timeFormat) {
			this.timeFormat = response.timeFormat;
			this.notifyTimeFormatObservers();
		}
	},

	getSystemTimeCallback: function(response){
		this.timezone = response.timezone;
		this.notifyTimeChangeObservers();
	},

	// *** DAY CHANGE ***

	iconSuccessCallback: function(response){
		//let the handle go
		if(this.updateIconRequest){
			this.updateIconRequest.cancel();	
		}		
		this.updateIconRequest = undefined;
		Mojo.Log.info("icon change succeeded: %j", response);
	},

	iconFailureCallback: function(response){
		//let the handle go
		if(this.updateIconRequest){
			this.updateIconRequest.cancel();	
		}
		this.updateIconRequest = undefined;
		Mojo.Log.error("icon change failed:  %j", response);
	},

	updateCalendarAppIcon: function() {
		//Mojo.Log.info("******** app-assistant: updateCalendarAppIcon")
		// Get today's date
		var today	= new Date();
		var iconUrl	= Mojo.appPath + "images/launcher/icon-" + today.getDate() + ".png";
		//Mojo.Log.info("TRYING TO SET CALENDAR ICON TO " + iconUrl);
		Mojo.Log.info("updating icon to "+iconUrl);

		if(Mojo.Host.current === Mojo.Host.mojoHost) {
			return;
		}

		this.updateIconRequest = new Mojo.Service.Request ("palm://com.palm.applicationManager",
		{	method		: "updateLaunchPointIcon"
		,	onFailure	: this.iconFailureCallback
		,	onSuccess	: this.iconSuccessCallback
		,	parameters	: { icon: iconUrl, launchPointId: "com.palm.app.calendar_default"}
		});
	},

	getUTCDateString: function(date){
		
		//UTC time format	  
		var year = date.getUTCFullYear();
		var month = date.getUTCMonth()+1;
		var day = date.getUTCDate();
		var hour= date.getUTCHours();
		var minute=date.getUTCMinutes();
		var second =date.getUTCSeconds();
			
		month	= (month > 9)	? month		: "0"+month;
		day		= (day > 9)		? day		: "0"+day;
		hour	= (hour > 9)	? hour		: "0"+hour;
		minute	= (minute > 9)	? minute	: "0"+minute;
		second	= (second > 9)	? second	: "0"+second;
		
		//YYYY-MM-DD HH:MM:SSZ
		return (""+year+"-"+month+"-"+day+" "+hour+":"+minute+":"+second+"Z");  
	},
	
	setupDayChangeTimer: function() {
		if(Mojo.Host.current === Mojo.Host.mojoHost) {
			return;
		}
				
		var date = new Date().addDays(1).clearTime();
		
		var dateString = this.getUTCDateString(date);
		var activityName = this.dayChangeActivityName;
		
		var result;		
		var needToCreate = false;
		
		//Query activity manager, and see if our activity already exists. If the activity doesn't exist yet, we create.
		var getDetailsArgs = {"activityName" : activityName};
		var activityFuture = PalmCall.call("palm://com.palm.activitymanager/", "getDetails", getDetailsArgs);
		activityFuture.then(function(future){
			if(future.exception){
				needToCreate = true;
			}			
			else if(future.result.returnValue === false){
				needToCreate = true;
			}
			future.result = {returnValue: true};
		});
		
		activityFuture.then(function(future){
			result = future.result;
			if(!needToCreate){
				var adoptArgs = {
					"activityName" : activityName,
					"wait" : true,
					"subscribe" : "true"
				};
				future.nest(PalmCall.call("palm://com.palm.activitymanager/", "adopt", adoptArgs));
			}
			else{
				future.result = result;
			}			
		});
		
		activityFuture.then(function(future){
			result = future.result;
			
			var activityMethod;
	        var activityArgs;
			var schedule = { "start" : dateString };
			var callback = 
			{
				"method": "palm://com.palm.applicationManager/launch",
				"params": 
				{
					"id": 'com.palm.app.calendar',
					"params": {"dayChange": true}
				}
			};
			
			//We could have created a local:true scheduled event, and let activity manager
			//react to time changes, but that doesn't help in the case where the date shifts backwards,
			//and we have to register for time change notification anyway, so it seemed more sensible to
			//keep one kind of activity and one code path, and just use a UTC-time based activity.
			if(needToCreate){
				activityMethod = "create";
	            activityArgs = {
	                "start": true,
					"replace": true,		
	                "activity": {
	                    "name": activityName,
	                    "description": "Calendar app activity that fires when midnight is reached",
	                    "type": {
	                        "persist": true,
	                        "foreground": true
	                    },
	                    "schedule" : schedule,
	                    "callback": callback
	                }
	            };
			}
			else{
				activityMethod = "complete";
	            activityArgs = {
	                "activityName": activityName,
	                "restart": true,
	                "schedule": schedule,
	                "callback": callback
	            };
			}
			
			future.nest(PalmCall.call("palm://com.palm.activitymanager", activityMethod, activityArgs));
		});
		
		activityFuture.then(function(future){
			PalmCall.cancel(activityFuture);
		});
		
	},

	dayChange: function() {	
		// Update the calendar launch icon
		this.updateCalendarAppIcon();

		// Notify any observers
		this.notifyDayChangeObservers();

		this.setupDayChangeTimer();
	},

	cleanup: function() {
		//Mojo.Log.info("AppAssistant cleanup");
		this.prefsManager.cleanup();
		this.calendarsManager.cleanup();

		this.reminderManager.cleanup();

		if (this.timeFormatRequest) {
			this.timeFormatRequest.cancel();
		}

		if (this.timeChangeRequest) {
			this.timeChangeRequest.cancel();
		}
	},

	getRecurrenceRule: function (){
		return this.recurrenceRule;
	},
	goToToday: function () {
		//Mojo.Log.info("goToToday");
		this.setCurrentDate(new Date());
	},


	// ** CURRENT DATE & TIME
	getCurrentDateTime: function () {
		var dateTimeStr = this.currentDateTime;
		//var date = Mojo.Format.formatDate(dateTimeStr, "MMMM dd, yyyy hh:mm");
		//Mojo.Log.info("getCurrentDateTime: %s" , date);
		return new Date(dateTimeStr);
	},
	setCurrentDateTime: function (dateTime, dontNotify, scrollToDefault) {
		//Mojo.Log.info("setCurrentDateTime: %s", Mojo.Format.formatDate(dateTime, "MMMM dd, yyyy hh:mm"));
	
		// Only set the current date and time if we know that the dateTime parameter
		// is of the Date class
		if (dateTime instanceof Date) {
			if (dateTime.getTime() != this.currentDateTime.getTime()) {
				this.currentDateTime = new Date(dateTime);
				// Notify all subscribers of the current date and time that the date/time has changed
				if (!dontNotify) {
					this.notifyCurrentDateTimeObservers(scrollToDefault);
				}
			}
	  }
	},
	observeCurrentDateTime: function (sceneName, controller) {
		this.currentDateTimeObservers.set(sceneName, controller);
	},
	notifyCurrentDateTimeObservers: function (scrollToDefault) {
		this.currentDateTimeObservers.each (function(scenePair) {
			scenePair.value.currentDateTimeUpdated(scrollToDefault);
		});
	},
	stopObservingCurrentDateTime: function (sceneName) {
		this.currentDateTimeObservers.unset(sceneName);
	},
	setCurrentDate: function (newDate) {
		// Sets the current date to the specified newDate... leaves the current time along

		//Mojo.Log.info("setCurrentDate: %s", Mojo.Format.formatDate(newDate, "MMMM dd, yyyy hh:mm"));
		if (!(newDate instanceof Date)) { return; }

		// Only update the date if its different... that way we don't notify observers when the date
		// really hasn't changed
		var currentDate	= this.currentDateTime;

		if (	currentDate.getFullYear()	== newDate.getFullYear()
			&&	currentDate.getMonth()		== newDate.getMonth()
			&&	currentDate.getDate()		== newDate.getDate()){
				return;
		}

		// Fix for JIRA NOV-81364 & NOV-81065
		// old code set the new date components separately via setFullYear + setDate + setMonth	(see bug for more details)
		this.currentDateTime = new Date ( newDate.getFullYear()
										, newDate.getMonth()
										, newDate.getDate()
										, currentDate.getHours()
										, currentDate.getMinutes()
										, currentDate.getSeconds()
										);

		this.notifyCurrentDateTimeObservers();
	},
	
	getEventFromServiceId: function (eventid){
		/**
		 *	Extracts event properties from the supplied event service id.
		 */

		var targetModel =
		{	end		: 0
		,	id		: eventid	// Default to original event id string
		,	start	: 0
		};

		// The eventid string should be formatted as "id-start-end".
		// If '-' isn't found in the eventid string, assume we only got an id# and no times.
		// Therefore return the default event id model.
		if (eventid.indexOf ('-') === -1) {
			return targetModel;
		}

		// Potential formats for id string:
		// xxxx-yyyy-zzzz   -> start > 0 and end > 0 (starts and ends after midnight 1/1/1970 UTC)
		// xxxx--yyyy-zzzz  -> start < 0 and end > 0 (starts before midnight 1/1/1970 and ends after midnight 1/1/1970 UTC)
		// xxxx--yyyy--zzzz -> start < 0 and end < 0 (starts and ends before midnight 1/1/1970 UTC)
		var regexp = new RegExp	(/^(.*)-(-?\d+)-(-?\d+)$/);
		var tokens = regexp.exec (eventid);

		// We should have four tokens: whole string match, id, start, and end.
		// If we don't have four tokens, the string is somehow malformed.
		// Therefore return the default event id model.
		if (tokens && tokens.length !== 4) {
			return targetModel;
		}

		targetModel.id		= tokens [1];
		targetModel.start	= parseInt (tokens [2], 10);
		targetModel.end		= parseInt (tokens [3], 10);

		return targetModel;
	},

	// ** FIRST USE
	setFirstUseToFalse: function () {
		this.cookie = this.cookie || new Mojo.Model.Cookie("com.palm.app.calendar");
		this.cookie.put({firstUse: false});
	},

	// ** Day Change
	notifyDayChangeObservers: function () {
		this.dayChangeObservers.each (function(scenePair) {
			scenePair.value.dayChanged();
		});
	},
	observeDayChange: function (sceneName, controller) {
		this.dayChangeObservers.set(sceneName, controller);
	},
	stopObservingDayChange: function (sceneName) {
		this.dayChangeObservers.unset(sceneName);
	},


	// **System  Time Change
	notifyTimeChangeObservers: function (){
		//Mojo.Log.info("notify time change observers");

		// Update the calendar icon and day change timer since the system time has changed
		this.updateCalendarAppIcon();
		this.setupDayChangeTimer();

		// Notify observers that system has changed
		this.timeChangeObservers.each (function(scenePair) {
			scenePair.value.timeChangeUpdated();
		});
	},
	observeTimeChange: function (sceneName, controller){
		this.timeChangeObservers.set (sceneName,controller);
	},
	stopObservingTimeChange: function (sceneName) {
		this.timeChangeObservers.unset (sceneName);
	},


	// ** TIME FORMAT
	getTimezoneName: function(){
		return this.timezone;
	},
	getTimeFormat: function () {
		return this.timeFormat;
	},
	notifyTimeFormatObservers: function () {
		this.timeFormatObservers.each (function(scenePair) {
			scenePair.value.timeFormatUpdated();
		});
	},
	observeTimeFormat: function (sceneName, controller) {
		this.timeFormatObservers.set(sceneName, controller);
	},
	stopObservingTimeFormat: function (sceneName) {
		this.timeFormatObservers.unset(sceneName);
	},


	// ** SERVICES
	getAppManagerService: function () {
		return this.appManagerService;
	},
	getFormatterService: function (){
		Mojo.Log.info("***********************in getFormatterService");
		return this.formatterService;
	},
	getSystemService: function () {
		return this.systemService;
	},

	// ** MANAGERS
	getCalendarsManager: function () {
		return this.calendarsManager;
	},
	getPrefsManager: function () {
		return this.prefsManager;
	},
	getReminderManager: function () {
		return this.reminderManager;
	}
});

// ** STAGE ASSISTANT
function StageAssistant(stageController) {
}

function getAppAssistant() {
	return Mojo.Controller.getAppController().assistant;
}

AppAssistant.long_max_value = "Long.MAX_VALUE"; // This is the end validity for forever recurring events
