var DayDetailDialogAssistant = Class.create({
	
	initialize: function(sceneAssistant,day) {
		this.sceneAssistant = sceneAssistant;
		this.date = day;
	},
	
	setup : function(widget) {
		this.widget = widget;
		var detail = iCan_LunarDetail(this.date.getFullYear(),this.date.getMonth(), this.date.getDate(), true);
		this.sceneAssistant.controller.get('dateE').update(detail.year+"年"+(detail.month+1)+"月"+detail.day+"日 星期"+detail.week);
		this.sceneAssistant.controller.get('dateC').update("农历 "+detail.animal+"年 "+detail.cMonth+detail.cDay);
		this.sceneAssistant.controller.get('dateCC').update(detail.ccDate);
		var term = detail.solarTerm?detail.solarTerm:"";
		this.sceneAssistant.controller.get('dateSolarTerm').update(term);
		var ftv="";
		if(detail.ftv&&detail.ftv.length>0){
			ftv=detail.ftv[0].txt;
			for(var i=1;i<detail.ftv.length;i++)
				ftv=ftv+" "+detail.ftv[i].txt;
		}
		this.sceneAssistant.controller.get('dateFtv').update(ftv);
	},
	
	activate: function() {
		this.okTapHandler = this.handleOK.bindAsEventListener(this);
		this.sceneAssistant.controller.get('btnOK').addEventListener(Mojo.Event.tap, this.okTapHandler);
	},
	
	deactivate: function() {
		this.sceneAssistant.controller.get('btnOK').removeEventListener(Mojo.Event.tap, this.okTapHandler);
	},
	
	handleOK:function(event){
		this.widget.mojo.close();
	}
});