/**
 * @author iCan(xiaogang)
 */
var iCan_lunarInfo = new Array(
0x4bd8,0x4ae0,0xa570,0x54d5,0xd260,0xd950,0x5554,0x56af,0x9ad0,0x55d2,
0x4ae0,0xa5b6,0xa4d0,0xd250,0xd255,0xb54f,0xd6a0,0xada2,0x95b0,0x4977,
0x497f,0xa4b0,0xb4b5,0x6a50,0x6d40,0xab54,0x2b6f,0x9570,0x52f2,0x4970,
0x6566,0xd4a0,0xea50,0x6a95,0x5adf,0x2b60,0x86e3,0x92ef,0xc8d7,0xc95f,
0xd4a0,0xd8a6,0xb55f,0x56a0,0xa5b4,0x25df,0x92d0,0xd2b2,0xa950,0xb557,
0x6ca0,0xb550,0x5355,0x4daf,0xa5b0,0x4573,0x52bf,0xa9a8,0xe950,0x6aa0,
0xaea6,0xab50,0x4b60,0xaae4,0xa570,0x5260,0xf263,0xd950,0x5b57,0x56a0,
0x96d0,0x4dd5,0x4ad0,0xa4d0,0xd4d4,0xd250,0xd558,0xb540,0xb6a0,0x95a6,
0x95bf,0x49b0,0xa974,0xa4b0,0xb27a,0x6a50,0x6d40,0xaf46,0xab60,0x9570,
0x4af5,0x4970,0x64b0,0x74a3,0xea50,0x6b58,0x5ac0,0xab60,0x96d5,0x92e0,
0xc960,0xd954,0xd4a0,0xda50,0x7552,0x56a0,0xabb7,0x25d0,0x92d0,0xcab5,
0xa950,0xb4a0,0xbaa4,0xad50,0x55d9,0x4ba0,0xa5b0,0x5176,0x52bf,0xa930,
0x7954,0x6aa0,0xad50,0x5b52,0x4b60,0xa6e6,0xa4e0,0xd260,0xea65,0xd530,
0x5aa0,0x76a3,0x96d0,0x4afb,0x4ad0,0xa4d0,0xd0b6,0xd25f,0xd520,0xdd45,
0xb5a0,0x56d0,0x55b2,0x49b0,0xa577,0xa4b0,0xaa50,0xb255,0x6d2f,0xada0,
0x4b63,0x937f,0x49f8,0x4970,0x64b0,0x68a6,0xea5f,0x6b20,0xa6c4,0xaaef,
0x92e0,0xd2e3,0xc960,0xd557,0xd4a0,0xda50,0x5d55,0x56a0,0xa6d0,0x55d4,
0x52d0,0xa9b8,0xa950,0xb4a0,0xb6a6,0xad50,0x55a0,0xaba4,0xa5b0,0x52b0,
0xb273,0x6930,0x7337,0x6aa0,0xad50,0x4b55,0x4b6f,0xa570,0x54e4,0xd260,
0xe968,0xd520,0xdaa0,0x6aa6,0x56df,0x4ae0,0xa9d4,0xa4d0,0xd150,0xf252,
0xd520);
var iCan_Gan=new Array("甲","乙","丙","丁","戊","己","庚","辛","壬","癸");
var iCan_Zhi=new Array("子","丑","寅","卯","辰","巳","午","未","申","酉","戌","亥");
var iCan_Animals=new Array("鼠","牛","虎","兔","龙","蛇","马","羊","猴","鸡","狗","猪");
var iCan_nStr1 = new Array('日','一','二','三','四','五','六','七','八','九','十');
var iCan_nStr2 = new Array('初','十','廿','卅','□');
var iCan_sTermInfo = new Array(0,21208,42467,63836,85337,107014,128867,150921,173149,195551,218072,240693,263343,285989,308563,331033,353350,375494,397447,419210,440795,462224,483532,504758);
var iCan_solarTerms = new Array("小寒","大寒","立春","雨水","惊蛰","春分","清明","谷雨","立夏","小满","芒种","夏至","小暑","大暑","立秋","处暑","白露","秋分","寒露","霜降","立冬","小雪","大雪","冬至");
var iCan_monthName = new Array("一月","二月","三月","四月","五月","六月","七月","八月","九月","十月","十一月","十二月");
var iCan_sFtv = new Array(
"0101*元旦节",
"0202 世界湿地日",
"0210 国际气象节",
"0214 情人节",
"0301 国际海豹日",
"0303 全国爱耳日",
"0305 学雷锋纪念日",
"0308 妇女节",
"0312 植树节 孙中山逝世纪念日",
"0314 国际警察日",
"0315 消费者权益日",
"0317 中国国医节 国际航海日",
"0321 世界森林日 消除种族歧视国际日 世界儿歌日",
"0322 世界水日",
"0323 世界气象日",
"0324 世界防治结核病日",
"0325 全国中小学生安全教育日",
"0330 巴勒斯坦国土日",
"0401 愚人节 全国爱国卫生运动月(四月) 税收宣传月(四月)",
"0407 世界卫生日",
"0422 世界地球日",
"0423 世界图书和版权日",
"0424 亚非新闻工作者日",
"0501*劳动节",
"0504 青年节",
"0505 碘缺乏病防治日",
"0508 世界红十字日",
"0512 国际护士节",
"0515 国际家庭日",
"0517 国际电信日",
"0518 国际博物馆日",
"0520 全国学生营养日",
"0523 国际牛奶日",
"0531 世界无烟日", 
"0601 国际儿童节",
"0605 世界环境保护日",
"0606 全国爱眼日",
"0617 防治荒漠化和干旱日",
"0623 国际奥林匹克日",
"0625 全国土地日",
"0626 国际禁毒日",
"0701 香港回归纪念日 中共诞辰 世界建筑日",
"0702 国际体育记者日",
"0707 抗日战争纪念日",
"0711 世界人口日",
"0730 非洲妇女日",
"0801 建军节",
"0808 中国男子节(爸爸节)",
"0815 抗日战争胜利纪念",
"0908 国际扫盲日 国际新闻工作者日",
"0909 毛泽东逝世纪念",
"0910 中国教师节", 
"0914 世界清洁地球日",
"0916 国际臭氧层保护日",
"0918 九·一八事变纪念日",
"0920 国际爱牙日",
"0927 世界旅游日",
"0928 孔子诞辰",
"1001*国庆节 世界音乐日 国际老人节",
"1002*国庆节假日 国际和平与民主自由斗争日",
"1003*国庆节假日",
"1004 世界动物日",
"1006 老人节",
"1008 全国高血压日 世界视觉日",
"1009 世界邮政日 万国邮联日",
"1010 辛亥革命纪念日 世界精神卫生日",
"1013 世界保健日 国际教师节",
"1014 世界标准日",
"1015 国际盲人节(白手杖节)",
"1016 世界粮食日",
"1017 世界消除贫困日",
"1022 世界传统医药日",
"1024 联合国日",
"1031 世界勤俭日",
"1107 十月社会主义革命纪念日",
"1108 中国记者日",
"1109 全国消防安全宣传教育日",
"1110 世界青年节",
"1111 国际科学与和平周(本日所属的一周)",
"1112 孙中山诞辰纪念日",
"1114 世界糖尿病日",
"1117 国际大学生节 世界学生节",
"1120*彝族年",
"1121*彝族年 世界问候日 世界电视日",
"1122*彝族年",
"1129 国际声援巴勒斯坦人民国际日",
"1201 世界艾滋病日",
"1203 世界残疾人日",
"1205 国际经济和社会发展志愿人员日",
"1208 国际儿童电视日",
"1209 世界足球日",
"1210 世界人权日",
"1212 西安事变纪念日",
"1213 南京大屠杀(1937年)纪念日！谨记血泪史！",
"1220 澳门回归纪念",
"1221 国际篮球日",
"1224 平安夜",
"1225 圣诞节",
"1226 毛泽东诞辰纪念");
var iCan_lFtv = new Array(
"0101*春节",
"0102*初二",
"0115 元宵节",
"0505*端午节",
"0707 七夕情人节",
"0715 中元节",
"0815*中秋节",
"0909 重阳节",
"1208 腊八节",
"1223 小年",
"0100*除夕");
var iCan_wFtv = new Array(
"0150 世界麻风日",
"0520 国际母亲节",
"0530 全国助残日",
"0630 父亲节",
"0730 被奴役国家周",
"0932 国际和平日",
"0940 国际聋人节 世界儿童日",
"0950 世界海事日",
"1011 国际住房日",
"1013 国际减轻自然灾害日(减灾日)",
"1144 感恩节");

var iCan_lYearDays=function(y) {
	var i, sum = 348;
	for(i=0x8000; i>0x8; i>>=1)
		sum += (iCan_lunarInfo[y-1900] & i)? 1: 0;
	return(sum+iCan_leapDays(y));
}
var iCan_leapDays=function(y) {
	if(iCan_leapMonth(y))
		return( (iCan_lunarInfo[y-1899]&0xf)==0xf? 30: 29);
	else
		return(0);
}
var iCan_leapMonth=function(y) {
	var lm = iCan_lunarInfo[y-1900] & 0xf;
	return(lm==0xf?0:lm);
}
var iCan_monthDays=function(y,m) {
	return((iCan_lunarInfo[y-1900] & (0x10000>>m))? 30: 29 );
}
var iCan_LatestDate,iCan_LatestLunarDate;
var iCan_Lunar=function(objDate){
	if(objDate.getFullYear()<1900||objDate.getFullYear()>2099)
		return null;
	if(iCan_LatestDate){
		var ddd=(objDate.getTime()-iCan_LatestDate.getTime())/86400000;
		iCan_LatestLunarDate.day+=ddd;
		if(iCan_LatestLunarDate.day>=1&&iCan_LatestLunarDate.day<=29){
			iCan_LatestDate = objDate;
			return iCan_LatestLunarDate;
		}
	}
	iCan_LatestDate = objDate;
	var i, leap=0, temp=0;
	var offset = (Date.UTC(objDate.getFullYear(),objDate.getMonth(),objDate.getDate()) - Date.UTC(1900,0,31))/86400000;
	
	for(i=1900; i<2099 && offset>0; i++){
		temp=iCan_lYearDays(i);
		offset-=temp;
	}
	 
	if(offset<0) {
		offset+=temp;
		i--;
	}
	var year = i;
	 
	leap = iCan_leapMonth(i); //闰哪个月
	var isLeap = false;

	for(i=1; i<13 && offset>0; i++) {
		//闰月
		if(leap>0 && i==(leap+1) && isLeap==false){
			--i;
			isLeap = true;
			temp = iCan_leapDays(year);
		}else{
			temp = iCan_monthDays(year, i);
		}
	 
		//解除闰月
		if(isLeap==true && i==(leap+1))
			isLeap = false;
		offset -= temp;
	}
	if(offset==0 && leap>0 && i==leap+1){
		if(isLeap){
			isLeap = false;
		}else{
			isLeap = true;
			--i;
		}
	}

	if(offset<0){
		offset += temp;
		--i;
	}

	var month = i;
	var day = offset + 1;
	iCan_LatestLunarDate = {year:year,month:month,day:day,isLeap:isLeap}
	return iCan_LatestLunarDate;
}
var iCan_cyclical=function(num) {
return(iCan_Gan[num%10]+iCan_Zhi[num%12]);
}
var iCan_sTerm=function(y,n) {
	if(y==2009 && n==2){
		iCan_sTermInfo[n]=43467;
	}
	var offDate = new Date(( 31556925974.7*(y-1900) + iCan_sTermInfo[n]*60000 ) + Date.UTC(1900,0,6,2,5) );
	return(offDate.getUTCDate());
}
var iCan_cDay=function(d){
	var s;
	switch(d){
		case 10:
			s = '初十'; break;
		case 20:
			s = '二十'; break;
		case 30:
			s = '三十'; break;
		default :
			s = iCan_nStr2[Math.floor(d/10)];
			s += iCan_nStr1[d%10];
			break;
	}
	return(s);
}
Number.prototype.__toString=Number.prototype.toString;
Number.prototype.toString = function(len){
	var s = this.__toString();
	if (!isNaN(len)) {
		while (s.length < len) 
			s = "0" + s;
	}
	return s;
}
var iCan_LunarDetail=function(y,m,d,f){
	var date=new Date(y,m,d);
	var luna=iCan_Lunar(date);
	if(luna==null)
		return null;
	var year,month,day,solarTerm=null,ftv=[],ccDate;
	year=luna.year;
	month=iCan_monthName[luna.month-1];
	day=iCan_cDay(luna.day);
	var tmp1=iCan_sTerm(date.getFullYear(),date.getMonth()*2  )-1;
	var tmp2=iCan_sTerm(date.getFullYear(),date.getMonth()*2+1)-1;
	if(tmp1==date.getDate()-1)
		solarTerm=iCan_solarTerms[date.getMonth()*2];
	if(tmp2==date.getDate()-1)
		solarTerm=iCan_solarTerms[date.getMonth()*2+1];
	if(f){
		//公历节日
		var mdStr=(date.getMonth()+1).toString(2)+date.getDate().toString(2);
		for(var i=0;i<iCan_sFtv.length;i++)
			if(iCan_sFtv[i].substr(0,4)==mdStr)
				ftv.push({txt:iCan_sFtv[i].substr(5),type:iCan_sFtv[i][4]=="*"?1:2});
		//农历节日
		var cmdStr=luna.month.toString(2)+luna.day.toString(2);
		for(var i=0;i<iCan_lFtv.length;i++)
			if(iCan_lFtv[i].substr(0,4)==cmdStr)
				ftv.push({txt:iCan_lFtv[i].substr(5),type:iCan_lFtv[i][4]=="*"?3:4});
		//世界节日
		for(var i=0;i<iCan_wFtv.length;i++)
			if(iCan_wFtv[i].substr(0,4)==mdStr)
				ftv.push({txt:iCan_wFtv[i].substr(5),type:iCan_wFtv[i][4]=="*"?5:6});
		var cYear,cMonth,cDay;
		//年柱 1900年立春后为庚子年(60进制36)
		if(m<2) cYear=iCan_cyclical(y-1900+36-1);
		else cYear=iCan_cyclical(y-1900+36);
		if(d==tmp1+1) cMonth = iCan_cyclical((y-1900)*12+m+14);
		else cMonth = iCan_cyclical((y-1900)*12+m+13);
		var dayCyclical = Date.UTC(y,m,1,0,0,0,0)/86400000+25567+10;
		cDay = iCan_cyclical(dayCyclical+d-1);
		ccDate = cYear+"年 "+cMonth+"月 "+cDay+"日";
	}
	return {year:y,month:m,day:d,week:iCan_nStr1[date.getDay()],isLeap:luna.isLeap,cYear:year,cMonth:month,cDay:day,solarTerm:solarTerm,ftv:ftv,ccDate:ccDate,animal:iCan_Animals[(y-4)%12]};
}