/* Copr. Palm, Inc. 2009, 2010
 * All rights reserved
 */

var UsbpassthroughAssistant = Class.create({
    normalMode: 'NormalMode',
    diagMode: '/dev/modemdiag',
    dunMode: '/dev/modem0',
    gpsMode: '/dev/gps',
    hciMode: '/dev/modemuart',
    bufferSize: '512',
    numberOfBuffers: '64',
    traceSize: '0',
    serviceName: 'palm://com.palm.usbpassthrough',
	svcUri:      'palm://com.palm.telephony',
	needPassThroughModeRefresh: false,
	gettingPassThroughMode: false,
	firstGetAttempt: true,
	mslValue: '',
	gettingPixieTemp: false,
	isPixie: null,
	isActivationFile: null,
	serialNumber:     null,
	authCode:         null,
	cookieSerialNumber: null,
	name: 'USB Passthrough',
	base: '/media/internal/',
	phoneType:        null,
	isDemoMode:       false,
    
    initialize: function(){
    
    },
    
    setup: function(){
		try {
			Mojo.Log.info("setup Called");
			this._SelectorChanged = this.selectorChanged.bindAsEventListener(this);
			this._UsbChanged = this.usbChanged.bindAsEventListener(this);
			this._ExitApp = this.exitApp.bindAsEventListener(this);
			this._ValidateCode = this.validateCode.bindAsEventListener(this);
			this._AccessUSBPassthrough = this.accessUSBPassthrough.bindAsEventListener(this);
			this._RunMiniDM = this.runMiniDM.bindAsEventListener(this);
			this._GotoCarrierTest = this.gotoCarrierTest.bindAsEventListener(this);
			
			// Observe mojo-property-change events on our selector widgets:
			this.controller.listen('acmPortSelector', Mojo.Event.propertyChange, this._SelectorChanged);
			this.controller.listen('ttygs1PortSelector', Mojo.Event.propertyChange, this._SelectorChanged);
			this.controller.listen('ttygs2PortSelector', Mojo.Event.propertyChange, this._SelectorChanged);
			this.controller.listen('serialPortSelector', Mojo.Event.propertyChange, this._SelectorChanged);
			
			// Find our status display div:
			this.currentStuff = this.controller.select('div#currentStuff')[0];
			
			this.controller.setupWidget('progressSpinner', this.spinnerAttributes, this.spinnerModel);
			
			// Setup models for the selector widgets:
			this.controller.setupWidget('acmPortSelector', {
				label: $L('ACM USB Port'),
				choices: this.acmPortOptions,
				modelProperty: 'currentAcmMode'
			}, this.myAppModel);
			this.controller.setupWidget('ttygs1PortSelector', {
				label: $L('USB Port 1'),
				choices: this.ttygsPortOptions,
				modelProperty: 'currentTty1Mode'
			}, this.myAppModel);
			this.controller.setupWidget('ttygs2PortSelector', {
				label: $L('USB Port 2'),
				choices: this.ttygsPortOptions,
				modelProperty: 'currentTty2Mode'
			}, this.myAppModel);
			this.controller.setupWidget('serialPortSelector', {
				label: $L('Serial Port'),
				choices: this.ttygsPortOptions,
				modelProperty: 'currentSerialMode'
			}, this.myAppModel);
			this.target = this.base + 'palm_';
			
			this.usbnetAttrs = {
				modelProperty: "isUsbNetEnabled",
				trueValue: true,
				trueLabel: 'Enabled',
				falseValue: false,
				falseLabel: 'Disabled'
			};
			
			this.controller.setupWidget('enableusbnetif', this.usbnetAttrs, this.myAppModel);
			this.controller.listen('enableusbnetif', Mojo.Event.propertyChange, this._UsbChanged);
			
			this.textAttributes = {
				enterSubmits: true,
				focus: true,
				multiline: false,       
				modifierState: Mojo.Widget.numLock,
				focusMode: Mojo.Widget.focusSelectMode,
				maxLength: 10,
				modelProperty: "codeValue"			
			};
			
			this.codeModel = {
				'codeValue':''
			};	
			this.controller.setupWidget('codeField', this.textAttributes, this.codeModel);
			
			//this.getPassthroughMode();
			//this.checkPixie(); // determine whether Pixie or not
			this.cookieId = 'com.palm.app.usbpassthrough';
			var memCookie = new Mojo.Model.Cookie(this.cookieId);
			if (memCookie) {
				var result = memCookie.get();
				Mojo.Log.info("Setup(): about to check cookie result");
				if (!result || !result.mslValue || result.mslValue.length != 5) {
					Mojo.Log.info("Setup(): No cookie settings found!; " + (result && result.mslValue ? result.mslValue : ""));
				} else {
					this.authCode = result.mslValue;
					this.cookieSerialNumber = result.sn;
					Mojo.Log.info("Setup(): Code found in cookie; " + result.mslValue);
					$('waitZone').innerHTML = "";
					$('waitZone').style.display = 'none';
					$('entryGroup').style.display = 'none';
					$('masterGroup').style.display = 'none'; // show 
					$('menuGroup').style.display = 'block'; // show menu
					this.isActivationFile = true;
					this.needPassThroughModeRefresh = true;
					//this.getPassthroughMode();
					//this.controller.get('message').innerHTML = "Check Phone Type...";
				}
			} else {
				Mojo.Log.info("Setup(): Couldn't create cookie instance");
			}
			
			this.getSerialNumber();
			
			Mojo.Log.info("Setup(): About to request type of phone");
			var requestPhoneType = new Mojo.Service.Request(this.svcUri, {
            	method: 'platformQuery',
				parameters: {},
            	onSuccess: function(response) {
					Mojo.Log.info ("platformQuery: succeeded:" + Object.toJSON(response));
					if (response.extended && response.extended.platformType == 'gsm') { // no main menu
						Mojo.Log.info("Setup(): GSM Phone - need to offer MiniDM option");
						this.phoneType = response.extended.platformType;
					} else {
						if (response.extended) {this.phoneType = response.extended.platformType;}
						Mojo.Log.info("Setup(): Not a GSM Phone: " 
							+ (response.extended && response.extended.platformType ?  response.extended.platformType : ""));
						$('minidm_button').style.display = 'none'; // hide 
						$('carrier_button').style.display = 'none'; // hide 
						if (this.isActivationFile == true) {
							$('masterGroup').style.display = 'block'; // show 
							$('menuGroup').style.display = 'none';    // hide
						}
					}
				}.bind(this),
           		onFailure: function(response) {
					Mojo.Log.error ("platformQuery: failed:" + Object.toJSON(response));
				}.bind(this),
      		});
			
			Mojo.Log.info("Setup(): Ended");

		} catch (e) {
			Mojo.Log.error ("main.setup(): exception: " + e)
		}
        
    },
	
	activate: function(event) {
		/* put in event handlers here that should only be in effect when this scene is active. For
		   example, key handlers that are observing the document */
		try {
			if (this.needPassThroughModeRefresh == true) {
				this.getPassthroughMode();
			}
			if (PalmSystem.isMinimal === true) {
				$('exit_button').style.display = "block";
			}
			$('exit_button').observe(Mojo.Event.tap, this._ExitApp);
			$('cancel_button').observe(Mojo.Event.tap, this._ExitApp);
			$('ok_button').observe(Mojo.Event.tap, this._ValidateCode);
			$('usb_button').observe(Mojo.Event.tap, this._AccessUSBPassthrough);
			$('minidm_button').observe(Mojo.Event.tap, this._RunMiniDM);
			$('carrier_button').observe(Mojo.Event.tap, this._GotoCarrierTest);
			
			if (this.isActivationFile != true) {
				$('masterGroup').style.display = 'none';
				$('menuGroup').style.display = 'none'; // show menu
				$('entryGroup').style.display = 'block';
			}
		} catch (e) {
			Mojo.Log.error ("main.activate(): exception: " + e)
		}
	},
	
	deactivate: function(event) {
		/* remove any event handlers you added in activate and do any other cleanup that should happen before
		   this scene is popped or another scene is pushed on top */
		$('exit_button').stopObserving(Mojo.Event.tap, this._ExitApp);
		$('cancel_button').stopObserving(Mojo.Event.tap, this._ExitApp);
		$('ok_button').stopObserving(Mojo.Event.tap, this._ValidateCode);
		$('usb_button').stopObserving(Mojo.Event.tap, this._AccessUSBPassthrough);
		$('minidm_button').stopObserving(Mojo.Event.tap, this._RunMiniDM);
		$('carrier_button').stopObserving(Mojo.Event.tap, this._GotoCarrierTest);
	},
	
	cleanup: function(event) {
		/* this function should do any cleanup needed before the scene is destroyed as 
		   a result of being popped off the scene stack */
		this.controller.stopListening('acmPortSelector', Mojo.Event.propertyChange, this._SelectorChanged);
		this.controller.stopListening('ttygs1PortSelector', Mojo.Event.propertyChange, this._SelectorChanged);
		this.controller.stopListening('ttygs2PortSelector', Mojo.Event.propertyChange, this._SelectorChanged);
		this.controller.stopListening('serialPortSelector', Mojo.Event.propertyChange, this._SelectorChanged);
		this.controller.stopListening('enableusbnetif', Mojo.Event.propertyChange, this._UsbChanged);
	},
    
	handleWiFiServerStatus: function(response) {
    	console.info("handleWiFiServerStatus: " + Object.toJSON(response));
		
	},
	
    myAppModel: {
        currentAcmMode: 'NormalMode',
        currentTty1Mode: 'NormalMode',
        currentTty2Mode: 'NormalMode',
        currentSerialMode: 'NormalMode',
        isUsbNetEnabled: false
    },
    
    defaultMyAppModel: {
        currentAcmMode: 'NormalMode',
        currentTty1Mode: 'NormalMode',
        currentTty2Mode: 'NormalMode',
        currentSerialMode: 'NormalMode',
        isUsbNetEnabled: false
    },
	
	resetMyAppModel: function () {
		this.myAppModel.currentAcmMode = this.defaultMyAppModel.currentAcmMode;
		this.myAppModel.currentTty1Mode = this.defaultMyAppModel.currentTty1Mode;
		this.myAppModel.currentTty2Mode = this.defaultMyAppModel.currentTty2Mode;
		this.myAppModel.currentSerialMode = this.defaultMyAppModel.currentSerialMode;
		this.myAppModel.isUsbNetEnabled = this.defaultMyAppModel.isUsbNetEnabled;
	},
	
	saveMslCookie: function (codeV) {
		var memCookie = new Mojo.Model.Cookie(this.cookieId);
		if (memCookie) {
			var value = {
				'mslValue': codeV, 
				'sn': this.serialNumber, 
			};
			memCookie.put(value);
			Mojo.Log.info("saveMslCookie(): Save settings to cookie: " + Object.toJSON(value));
		}
	},

	validateCode: function () {
		try {
			var codeV = this.controller.get('codeField').mojo.getValue();
			Mojo.Log.info("validateCode(): Code: " + codeV);
				var codeTempRequest = this.controller.serviceRequest('palm://com.palm.logctld', {
					method: 'validate',
					parameters: {
						"code": codeV,
						"sn": this.serialNumber
					},
					onSuccess: function(result){
						this.controller.cancelServiceRequest(codeTempRequest);
						this.stopSpinner();
						$('waitZone').innerHTML = "";
						$('waitZone').style.display = 'none';
						$('entryGroup').style.display = 'none';
						$('masterGroup').style.display = 'none'; // show 
						$('menuGroup').style.display = 'block'; // show menu
						this.isActivationFile = true;
						this.saveMslCookie (codeV);
						this.getPassthroughMode();
					}.bind(this),
					onFailure: function(result){
						this.controller.cancelServiceRequest(codeTempRequest);
						this.stopSpinner();
						$('waitZone').innerHTML = "";
						$('waitZone').style.display = 'none';
						$('entryGroup').style.display = 'none';
						$('masterGroup').style.display = 'none'; // show 
						$('menuGroup').style.display = 'block'; // show menu
						this.isActivationFile = true;
						this.saveMslCookie (codeV);
						this.getPassthroughMode();
					}.bind(this)
				});
		} catch (e) {
			Mojo.Log.error ("main.validateCode(): exception: " + e)
		}
		
	},

	exitApp: function () {
		this.controller.window.close();
	},
    
    // Options for list selector choices:
    acmPortOptions: [{
        label: $L('None'),
        value: 'NormalMode'
    }, {
        label: $L('DUN'),
        value: '/dev/modem0'
    }],
    
    ttygsPortOptions: [{
        label: $L('None'),
        value: 'NormalMode'
    }, {
        label: $L('Diag'),
        value: '/dev/modemdiag'
    }, {
        label: $L('GPS'),
        value: '/dev/gps'
    }, {
        label: $L('HCI Control Port'),
        value: '/dev/modemuart'
    }],
    
    serialPortOptions: [{
        label: $L('None'),
        value: 'NormalMode'
    }, {
        label: $L('DUN'),
        value: '/dev/modem0'
    }, {
        label: $L('Diag'),
        value: '/dev/modemdiag'
    }, {
        label: $L('GPS'),
        value: '/dev/gps'
    }, {
        label: $L('HCI Control Port'),
        value: '/dev/modemuart'
    }],
    
    selectorChanged: function(event){
        Mojo.Log.info("selectorChanged Called" + this.myAppModel.currentAcmMode);
        
        this.setPassthroughMode();
    },
	
	usbChanged: function(event){
        Mojo.Log.info("usbChanged Called, changed to: " + this.myAppModel.isUsbNetEnabled);
        if (this.myAppModel.currentAcmMode == this.defaultMyAppModel.currentAcmMode &&
				this.myAppModel.currentTty1Mode == this.defaultMyAppModel.currentTty1Mode &&
				this.myAppModel.currentTty2Mode == this.defaultMyAppModel.currentTty2Mode &&
				this.myAppModel.currentSerialMode == this.defaultMyAppModel.currentSerialMode) {
        	Mojo.Log.info("usbChanged(), change ignored");
			if (this.myAppModel.isUsbNetEnabled != false) {
				this.showAlertDialog($L("Warning"), "You need to set passthrough state before setting USBNet mode");
			}
		} else {
			this.setPassthroughMode();
		}
    },
	
	setMessage: function (x, y, z) {
		$('waitZone').innerHTML = (x == 'i' ? '<i>' : '<br/><b>') 
			+ y + (y == 'V' ? 'erify' : (y == 'C' ? 'hanging' : 'nva' + 'lid')) + ' ' + this.name
			+ z + (z == '...' ? '' : 'ermiss' + 'ions')
			+ '</' + x + '>'; 
	},
    
    setModeLabels: function(modeControl, modeLabel, isModeActive){
        if (isModeActive) {
            $(modeControl).innerHTML = modeLabel + this.activeMode;
            $(modeControl).style.color = "#7FFF00";
        }
        else {
            $(modeControl).innerHTML = modeLabel;
            $(modeControl).style.color = "#FFFFFF";
        }
    },
	
	accessUSBPassthrough: function (event) {
		$('menuGroup').style.display = 'none'; // show menu
		$('masterGroup').style.display = 'block'; // show 
	},
	
	runMiniDM: function (event) {
		Mojo.Log.info("runMiniDM called");
        try {
			var request = new Mojo.Service.Request( 'palm://com.palm.applicationManager', { 
				method: 'open', 
				parameters: { 
					id: 'com.palm.app.minidm', 
					params: "" 
				},
				onSuccess: function(result){
					Mojo.Log.info("runMiniDM success: " + Object.toJSON(result));
					this.controller.window.close();
				}.bind(this),
				onFailure: function(result){
					Mojo.Log.error("runMiniDM Failed: " + result.errorText + " #" + result.errorCode);
					var msgText;
					if (result.errorText && result.errorText.indexOf ('minidm') > -1 && result.errorText.indexOf ('was not found') > -1) {
						msgText = "MiniDM application not found!";
						$('minidm_button').style.display = 'none'; // hide 
					} else {
						msgText = "<b>Unexpected error</b>" 
						+ (result.errorCode ?  "#: " + result.errorCode : "")
						+ (result.errorText ? "<br/>" + result.errorText : "");
					}
					this.showAlertDialog ($L('Error'), msgText);
				}.bind(this),
				
			}); 
        } 
        catch (e) {
            Mojo.Log.info("Exception Error Displaying Popup Dialog", msgTitle, msg);
        }

	},
    
    showAlertDialog: function(msgTitle, msg){
		Mojo.Log.info("showAlertDialog called");
        try {
            this.controller.showAlertDialog({
                onChoose: function(value){
                },
                title: (msgTitle && msgTitle.length > 1 ? msgTitle : $L('Information')),
                message: msg,
				allowHTMLMessage: true,
                choices: [{
                    label: $L("OK"),
                    value: "Ok",
                    type: 'dismiss'
                }]
            });
        } 
        catch (e) {
            Mojo.Log.info("Exception Error Displaying Popup Dialog", msgTitle, msg);
        }
    },
	
	getWindowHeight: function () {
		return this.controller.window.screen.height;
		return h;
	},
    
	getWindowWidth: function () {
		return this.controller.window.screen.width;
	},
	
    getPassthroughMode: function(){
        if (this.gettingPassThroughMode == true) {
        	Mojo.Log.info("getPassthroughMode() called, but already getting passthrough mode");
			return;
		}
        Mojo.Log.info("getPassthroughMode called");
        try {		
			this.gettingPassThroughMode = true;
			$('mainGroup').style.display = 'none';
			this.activateSpinner();
			$('waitZone').innerHTML = "<i>Getting USB Passthrough status...</i>";
			$('waitZone').style.display = 'block';
            this.controller.serviceRequest(this.serviceName, {
                method: 'getstate',
                parameters: {
                    'subscribe': true
                },
				onFailure: function(responseMsg) { 
                   var jsonObject = Object.toJSON(responseMsg);
					this.gettingPassThroughMode = false;
                    Mojo.Log.info("getPassthroughMode onFailure Response" + jsonObject);
					this.stopSpinner();
					$('waitZone').style.display = 'none';
					$('waitZone').innerHTML = "<b>Current state unknown!</b>";
					//if (this.firstGetAttempt == true) {$('waitZone').style.display = 'block';}
					this.firstGetAttempt = false;
					$('mainGroup').style.display = 'block';
					//if (this.mslValue.length < 6) {  // never successfully changed!
						this.resetMyAppModel();
						this.controller.modelChanged(this.myAppModel, this);
					if (responseMsg.errorText){
						this.showAlertDialog($L("Error"), "Can't get passthrough state: " + responseMsg.errorText);
					}
 				}.bind(this),
                onSuccess: function(responseMsg){
					this.stopSpinner();
					this.firstGetAttempt = false;
					$('waitZone').style.display = 'none';
					$('mainGroup').style.display = 'block';
                    var jsonObject = Object.toJSON(responseMsg);
					this.gettingPassThroughMode = false;
                    if (!responseMsg.returnValue) {
						$('waitZone').innerHTML = "<b>Can\'t get current state</b>";
                  //      this.showAlertDialog($L("Error"), "Could not get current passthrough state");
                    	Mojo.Log.error("getPassthroughMode Response" + jsonObject);
                    }
                    else {
						this.needPassThroughModeRefresh = false;
                    	Mojo.Log.error("getPassthroughMode Response" + jsonObject);
                    	//Mojo.Log.info("getPassthroughMode Response" + jsonObject);
						
                        if (-1 != jsonObject.toString().search('/dev/ttyS2')) {
                            //We are in Serial UART mode
                            Mojo.Log.info("Passthrough is in Serial Mode");
							this.myAppModel.isUsbNetEnabled = responseMsg['haveConsole'];
                            if (null != responseMsg['/dev/ttyS2']) {
                                this.myAppModel.currentSerialMode = responseMsg['/dev/ttyS2'].joinPort;
                            }
                            else {
                                this.myAppModel.currentSerialMode = this.normalMode;
                            }
                        } else {
							//We are in USB mode
							Mojo.Log.info("Passthrough is in USB Mode");
							if (-1 != jsonObject.toString().search('haveConsole')) {
								this.myAppModel.isUsbNetEnabled = responseMsg['haveConsole'];
								Mojo.Log.info("Setting haveConsole:" + this.myAppModel.isUsbNetEnabled);
							} else {
								this.myAppModel.isUsbNetEnabled = false;
							}
							if (null != responseMsg['/dev/ttygs0']) {
								this.myAppModel.currentAcmMode = responseMsg['/dev/ttygs0'].joinPort;
								Mojo.Log.info("Setting ttygs0:" + this.myAppModel.currentAcmMode);
							} else {
								this.myAppModel.currentAcmMode = this.normalMode;
							}
							if (null != responseMsg['/dev/ttygs1']) {
								this.myAppModel.currentTty1Mode = responseMsg['/dev/ttygs1'].joinPort;
							} else {
								this.myAppModel.currentTty1Mode = this.normalMode;
							}
							if (null != responseMsg['/dev/ttygs2']) {
								this.myAppModel.currentTty2Mode = responseMsg['/dev/ttygs2'].joinPort;
							} else {
								this.myAppModel.currentTty2Mode = this.normalMode;
							}
						}
						$('waitZone').style.display = 'none';
						$('mainGroup').style.display = 'block';
						$('waitZone').innerHTML = "USB Passthrough status: OK";
                    }
                    this.controller.modelChanged(this.myAppModel, this);
                }.bind(this)
            });
        } 
        catch (e) {
			this.gettingPassThroughMode = false;
			$('waitZone').style.display = 'none';
			$('mainGroup').style.display = 'block';
			Mojo.Log.error ("getPassthroughMode() exception: " + e);
            this.showAlertDialog("Exception Error Getting Mode", "Getting USB Passthrough Mode Failed: <br/>" + e);
        }
    },
	
	showMSLDialog: function(config, func, msl, isP) {				
		this.dialogBox = this.controller.showDialog({
			template: 'template/msl-dialog',
			assistant: new MslAssistant(this, config, func, msl, isP),	
			preventCancel: false		
		});
	},
	
	gotoCarrierTest: function () {
        Mojo.Log.info("gotoCarrierTest called");
		Mojo.Controller.stageController.pushScene('carriertest');
	},
    
    setPassthroughMode: function(usbOptions, enableUsbNet){
        Mojo.Log.info("setPassthroughMode called");
        try {
            var passthroughConfig = {
                "bufferSize": 512,
                "numberOfBuffers": 64,
                "traceSize": 0,
                "haveConsole": this.myAppModel.isUsbNetEnabled,
                "/dev/ttygs0": {
                    "isAcm": false,
                },
            
            };
            
            
            if (this.myAppModel.currentSerialMode != this.normalMode) {
                //We only support one option with Serial Mode
                Mojo.Log.info("We are Setting up passthrough for Serial Mode");
                passthroughConfig["/dev/ttyS2"] = {
                    "isAcm": false,
                    "joinPort": this.myAppModel.currentSerialMode
                };
            }
            else {
                //USB Mode
                Mojo.Log.info("We are Setting up passthrough for USB Mode");
                if (this.myAppModel.currentAcmMode != this.normalMode) {
                    passthroughConfig["/dev/ttygs0"] = {
                        "isAcm": true,
                        "joinPort": this.myAppModel.currentAcmMode
                    };
                }
                if (this.myAppModel.currentTty1Mode != this.normalMode) {
                    passthroughConfig["/dev/ttygs1"] = {
                        "isAcm": false,
                        "joinPort": this.myAppModel.currentTty1Mode
                    };
                }
                if (this.myAppModel.currentTty2Mode != this.normalMode) {
                    passthroughConfig["/dev/ttygs2"] = {
                        "isAcm": false,
                        "joinPort": this.myAppModel.currentTty2Mode
                    };
                }
                
            }
            
            Mojo.Log.info("passthroughString" + Object.toJSON(passthroughConfig));
			
			//this.showMSLDialog (passthroughConfig, this.handlePassThroughReturn.bind(this), this.mslValue, this.isPixie);
			this.activateSpinner();
			this.setMessage ('i', 'C', '...');
			$('waitZone').style.display = 'block';

            this.controller.serviceRequest(this.serviceName, {
                method: 'setstate',
                parameters: passthroughConfig,
				onFailure: function(responseMsg){
					$('waitZone').innerHTML = "";
					$('waitZone').style.display = 'none';
					if (responseMsg.errorText){
						this.stopSpinner();
						this.resetMyAppModel();
						this.controller.modelChanged(this.myAppModel, this);
						this.showAlertDialog($L("Error"), "Can't set passthrough state: " + responseMsg.errorText);
					} else {
						this.getPassthroughMode();
					}
				}.bind(this),
                onSuccess: function(responseMsg){
					$('waitZone').innerHTML = "";
					$('waitZone').style.display = 'none';
                    if (!responseMsg.returnValue) {
                        this.showAlertDialog("Error Setting Mode", "Setting USB Passthrough Mode Failed");
                    }
                    this.getPassthroughMode();
                }.bind(this)                
            });
        } 
        catch (e) {
            this.showAlertDialog("Exception Error Setting Mode", "Setting USB Passthrough Mode Failed");
            //this.getPassthroughMode();
			this.needPassThroughModeRefresh = true;
        }
    },
	
	handlePassThroughReturn: function (isSuccess, responseMsg, msl) {
		Mojo.Log.info ("handlePassThroughReturn(): success:" + isSuccess + " Msg: " + Object.toJSON(responseMsg));
//		this.needPassThroughModeRefresh = true;
		if (isSuccess == true) {
			Mojo.Log.info ("handlePassThroughReturn(): save MSL #" + msl);
			this.mslValue = msl;
            this.getPassthroughMode();
		} else {
//            this.getPassthroughMode();
			this.resetMyAppModel();
			this.controller.modelChanged(this.myAppModel, this);
            this.showAlertDialog("Error Setting Mode", "Setting USB Passthrough Mode Failed<br><br>" + Object.toJSON(responseMsg));
		}
	},
	
	getSerialNumber: function () {
		try {
	        var getSnRequest = this.controller.serviceRequest('palm://com.palm.preferences', {
				method: 'systemProperties/Get',
				parameters: {
           			key: 'com.palm.properties.PalmSN'
        		},
				onSuccess: function(result){
					this.controller.cancelServiceRequest(getSnRequest);
					this.serialNumber = result["com.palm.properties.PalmSN"].toUpperCase();
					Mojo.Log.info("getSerialNumber(): Success: " + this.serialNumber);
					if (this.cookieSerialNumber && this.cookieSerialNumber.length > 0 && this.cookieSerialNumber != this.serialNumber) {
						Mojo.Log.info("getSerialNumber(): Old S/N from cookie " + this.cookieSerialNumber);
						this.cookieSerialNumber = this.serialNumber;
						this.saveMslCookie(""); // clear code parameter in cookie
						if (this.isActivationFile == true) {
							this.isActivationFile = false;
							$('masterGroup').style.display = 'none';
							$('menuGroup').style.display = 'none'; 
							$('entryGroup').style.display = 'block';
						}
					}
					//Mojo.Log.info("getSerialNumber(): Success: " + this.serialNumber);
				}.bind(this),
				onFailure: function(result){
					this.controller.cancelServiceRequest(getSnRequest);
					Mojo.Log.info("getSerialNumber(): Failed " + Object.toJSON(result));
					if (result && result.errorText == "no such key") {
						Mojo.Log.info("getSerialNumber(): Alternate processing");
						$('waitZone').innerHTML = "";
						$('waitZone').style.display = 'none';
						$('entryGroup').style.display = 'none';
						$('masterGroup').style.display = 'none'; // show 
						$('menuGroup').style.display = 'block'; // show menu
						this.isActivationFile = true;
						this.needPassThroughModeRefresh = true;
					}
					
				}.bind(this)
	    	});
		} catch (e) {
			Mojo.Log.error ("main.getSerialNumber(): exception: " + e)
		}
	},
	
	// check for Pixie by testing function currenty only available on Pixie
	//  a bit Hokey, is there something better?
	checkPixie: function() {
		try {
			Mojo.Log.info("checkPixie(): start");
			if (this.isPixie != null || this.gettingPixieTemp == true) return; // already determined
			this.gettingPixieTemp = true;
			var pixieTempRequest = this.controller.serviceRequest('luna://com.palm.crotest', {
				method: 'GetTemp',
				parameters: {},
				onSuccess: function(result){
					this.controller.cancelServiceRequest(pixieTempRequest);
					this.gettingPixieTemp = false;
					this.isPixie = true;
					Mojo.Log.info("checkPixie(): Success");
				}.bind(this),
				onFailure: function(result){
					this.controller.cancelServiceRequest(pixieTempRequest);
					this.gettingPixieTemp = false;
					this.isPixie = false;
					Mojo.Log.info("checkPixie(): Failed " + result.errorText);
				}.bind(this)
			});
		} catch (e) {
			Mojo.Log.error ("main.checkPixie(): exception: " + e)
		}
 	},
	
	checkF: function () {
		try {	
			if (PalmSystem.isMinimal === true) {
				Mojo.Log.info("checkF(): skipped");
				this.isActivationFile = true;
				this.getPassthroughMode();
			} else {
				this.needPassThroughModeRefresh = false;
				this.activateSpinner();
				var name = this.target + 'pass' + 'through' + '.json';
				this.setMessage ('i', 'V', '...');
				$('waitZone').style.display = 'block';
				$('masterGroup').style.display = 'none'; // hide 
				$('menuGroup').style.display = 'none'; // hide
	
				var jsonTempRequest = this.controller.serviceRequest('palm://com.palm.logctld', {
					method: 'importjsonfile',
					parameters: {
						"filename": name
					},
					onSuccess: function(result){
						this.controller.cancelServiceRequest(jsonTempRequest);
						var obj = undefined;
						Mojo.Log.info("checkF(): onSuccess - result: " + Object.toJSON(result));
						try {
							obj = (result.text ? result.text.evalJSON(true) : undefined);
						} catch (exception) {
							Mojo.Log.error("checkF(): exception: " + exception);
							obj = undefined;
						}
						this.stopSpinner();
						if (obj != undefined && obj.carrier && obj.carrier.length > 0) {
							$('waitZone').innerHTML = "";
							$('waitZone').style.display = 'none';
							$('masterGroup').style.display = 'none'; // show 
							$('menuGroup').style.display = 'block'; // show menu
							this.isActivationFile = true;
							this.getPassthroughMode();
						} else {
							$('masterGroup').style.display = 'none'; // hide 
							$('menuGroup').style.display = 'none'; // hide
							$('waitZone').style.left = '20px';
							this.setMessage ('b', 'I', ' p');
							Mojo.Log.error ("checkF(): File contents wrong! [" 
								+ (obj == undefined ? 'undefined' : ( !obj.carrier ? "no carrier": obj.carrier)) + ']');
							this.isActivationFile = false;
						}
					}.bind(this),
					onFailure: function(result){
						this.controller.cancelServiceRequest(jsonTempRequest);
						this.isActivationFile = false;
						this.stopSpinner();
						$('masterGroup').style.display = 'none'; // hide 
						$('menuGroup').style.display = 'none'; // hide
						Mojo.Log.error("checkF(): Failed: " + result.errorText);
						$('waitZone').style.left = '20px';
						this.setMessage ('b', 'I', ' p');
					}.bind(this)
				});
			}	
		} catch (e) {
			Mojo.Log.error ("main.checkF(): exception: " + e)
		}
	},
	
	activateSpinner: function () {
		try {
			Mojo.Log.info ("main.activateSpinner()");
			$('spinner-div').style.display = "block";
			var elem = this.controller.get('progressSpinner');
			elem.mojo.start();
			//this.spinnerModel.spinning = true;
			//this.controller.modelChanged(this.spinnerModel);
			this.controller.sceneScroller.mojo.revealElement('spinner-div');
			$('exit_button').style.display = "none";
		} catch (e) {
			Mojo.Log.error ("main.activateSpinner(): elem: " + elem + ", exception: " + e)
		}
	},
	
	stopSpinner: function () {
		try {
			Mojo.Log.info ("main.stopSpinner()");
			var elem = this.controller.get('progressSpinner');
			elem.mojo.stop();
			$('spinner-div').style.display = "none";
			//this.spinnerModel.spinning = false;
			//this.controller.modelChanged(this.spinnerModel);
			if (PalmSystem.isMinimal === true) {
				$('exit_button').style.display = "block";
			}
		} catch (e) {
			Mojo.Log.error ("main.stopSpinner(): elem: " + elem + ", exception: " + e)
		}
	},
	
	spinnerAttributes: {
		spinnerSize: 'large',
		//frameHeight:  '100px',
	}, 

	spinnerModel: {
		spinning: false
	},

});


